/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.trail;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorParser;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.photon.client.gameobject.emitter.Emitter;
import com.lowdragmc.photon.client.gameobject.emitter.ParticleQueueRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.trail.TrailConfig;
import com.lowdragmc.photon.client.gameobject.particle.TrailParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@LDLRegisterClient(name="trail", group="emitter")
public class TrailEmitter
extends Emitter {
    public static int VERSION = 2;
    @Persisted(subPersisted=true)
    public final TrailConfig config;
    protected TrailParticle trailParticle;

    public TrailEmitter() {
        this(new TrailConfig());
        this.config.smoothInterpolation = true;
        this.config.minVertexDistance = 0.1f;
    }

    public TrailEmitter(TrailConfig config) {
        this.config = config;
        this.init();
    }

    public void init() {
        this.trailParticle = new TrailParticle(this, this.config, this.getThreadSafeRandomSource());
    }

    @Override
    public TrailEmitter shallowCopy() {
        return new TrailEmitter(this.config);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_("_version", VERSION);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        int version;
        int n = version = tag.m_128441_("_version") ? tag.m_128451_("_version") : 0;
        if (version < 1) {
            CompoundTag configTag = tag;
            tag = new CompoundTag();
            tag.m_128365_("config", (Tag)configTag);
            tag.m_128359_("name", configTag.m_128461_("name"));
        }
        super.deserializeNBT(tag);
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ConfiguratorParser.createConfigurators((ConfiguratorGroup)father, new HashMap(), this.config.getClass(), (Object)this.config);
    }

    public int m_107273_() {
        return this.config.duration;
    }

    @Override
    protected void updateOrigin() {
        super.updateOrigin();
        this.m_107257_(this.config.duration);
    }

    @Override
    public boolean isLooping() {
        return this.config.isLooping();
    }

    @Override
    public int getParticleAmount() {
        return this.trailParticle.isAlive() ? 1 : 0;
    }

    @Override
    protected void update() {
        if (this.trailParticle.isAlive()) {
            this.trailParticle.tick();
        } else {
            this.m_107274_();
        }
        super.update();
    }

    @Override
    public void reset() {
        super.reset();
        this.init();
    }

    @Override
    public void m_5744_(@NotNull VertexConsumer buffer, Camera camera, float pPartialTicks) {
        super.m_5744_(buffer, camera, pPartialTicks);
        if (!ParticleQueueRenderType.INSTANCE.isRenderingQueue() && this.delay <= 0 && this.isVisible() && PhotonParticleRenderType.checkLayer(this.config.renderer.getLayer()) && (!this.config.renderer.getCull().isEnable() || PhotonParticleRenderType.checkFrustum(this.config.renderer.getCull().getCullAABB(this, pPartialTicks)))) {
            ParticleQueueRenderType.INSTANCE.pipeQueue(this.trailParticle.getRenderType(), Collections.singleton(this.trailParticle), camera, pPartialTicks);
        }
    }

    @Override
    @Nullable
    public AABB getCullBox(float partialTicks) {
        return this.config.renderer.getCull().isEnable() ? this.config.renderer.getCull().getCullAABB(this, partialTicks) : null;
    }

    @Override
    public void remove(boolean force) {
        this.trailParticle.setRemoved(true);
        super.remove(force);
        if (force) {
            this.trailParticle.getTails().clear();
        }
    }
}

