/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.trail;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.data.LightOverLifetimeSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.MaterialSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.RendererSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.UVAnimationSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.CustomShaderMaterial;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.Color;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.Gradient;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomColor;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomGradient;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.particle.TrailParticle;
import com.lowdragmc.photon.client.postprocessing.BloomEffect;
import com.lowdragmc.photon.core.mixins.accessor.BlendModeAccessor;
import com.lowdragmc.photon.core.mixins.accessor.ShaderInstanceAccessor;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.nbt.CompoundTag;

public class TrailConfig
implements IPersistedSerializable {
    @Configurable(tips={"photon.emitter.config.duration"})
    @NumberRange(range={1.0, 2.147483647E9})
    protected int duration = 100;
    @Configurable(tips={"photon.emitter.config.looping"})
    protected boolean looping = true;
    @Configurable(tips={"photon.emitter.config.startDelay"})
    @NumberRange(range={0.0, 2.147483647E9})
    protected int startDelay = 0;
    @Configurable(tips={"photon.emitter.trail.config.time"})
    @NumberRange(range={0.0, 2.147483647E9})
    protected int time = 20;
    @Configurable(tips={"photon.emitter.trail.config.minVertexDistance"})
    @NumberRange(range={0.0, 3.4028234663852886E38})
    protected float minVertexDistance = 0.05f;
    @Configurable(tips={"photon.emitter.trail.config.smoothInterpolation.0", "photon.emitter.trail.config.smoothInterpolation.1"})
    protected boolean smoothInterpolation = false;
    protected boolean calculateSmoothByShader = false;
    @Configurable(tips={"photon.emitter.config.parallelRendering.0", "photon.emitter.config.parallelRendering.1"})
    protected boolean parallelRendering = false;
    @Configurable(tips={"photon.emitter.trail.config.uvMode"})
    protected TrailParticle.UVMode uvMode = TrailParticle.UVMode.Stretch;
    @Configurable(tips={"photon.emitter.trail.config.widthOverTrail"})
    @NumberFunctionConfig(types={Constant.class, Curve.class}, min=0.0f, defaultValue=0.1f, curveConfig=@CurveConfig(bound={0.0f, 0.1f}, xAxis="trail position", yAxis="width"))
    protected NumberFunction widthOverTrail = NumberFunction.constant(Float.valueOf(0.2f));
    @Configurable(tips={"photon.emitter.trail.config.colorOverTrail"})
    @NumberFunctionConfig(types={Color.class, RandomColor.class, Gradient.class, RandomGradient.class}, defaultValue=-1.0f)
    protected NumberFunction colorOverTrail = new Gradient();
    @Configurable(name="Material", subConfigurable=true, tips={"photon.emitter.config.material"})
    public final MaterialSetting material = new MaterialSetting();
    @Configurable(name="Renderer", subConfigurable=true, tips={"photon.emitter.config.renderer"})
    public final RendererSetting renderer = new RendererSetting();
    @Configurable(name="Fixed Light", subConfigurable=true, tips={"photon.emitter.config.lights"})
    public final LightOverLifetimeSetting lights = new LightOverLifetimeSetting();
    @Configurable(name="UV Animation", subConfigurable=true, tips={"photon.emitter.config.uvAnimation"})
    public final UVAnimationSetting uvAnimation = new UVAnimationSetting();
    public final PhotonParticleRenderType particleRenderType = new RenderType();

    public TrailConfig() {
        this.material.setMaterial(new CustomShaderMaterial());
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        if (!tag.m_128441_("smoothInterpolation")) {
            NumberFunction numberFunction = this.widthOverTrail;
            if (numberFunction instanceof Constant) {
                Constant constant = (Constant)numberFunction;
                constant.setNumber(Float.valueOf(constant.getNumber().floatValue() / 10.0f));
            } else {
                numberFunction = this.widthOverTrail;
                if (numberFunction instanceof Curve) {
                    Curve curve = (Curve)numberFunction;
                    curve.setMax(curve.getMax() / 10.0f);
                    curve.setMin(curve.getMin() / 10.0f);
                    curve.setDefaultValue(curve.getDefaultValue() / 10.0f);
                }
            }
        }
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getTime() {
        return this.time;
    }

    public void setMinVertexDistance(float minVertexDistance) {
        this.minVertexDistance = minVertexDistance;
    }

    public float getMinVertexDistance() {
        return this.minVertexDistance;
    }

    public boolean isSmoothInterpolation() {
        return this.smoothInterpolation;
    }

    public boolean isCalculateSmoothByShader() {
        return this.calculateSmoothByShader;
    }

    public void setParallelRendering(boolean parallelRendering) {
        this.parallelRendering = parallelRendering;
    }

    public boolean isParallelRendering() {
        return this.parallelRendering;
    }

    public void setUvMode(TrailParticle.UVMode uvMode) {
        this.uvMode = uvMode;
    }

    public TrailParticle.UVMode getUvMode() {
        return this.uvMode;
    }

    public void setWidthOverTrail(NumberFunction widthOverTrail) {
        this.widthOverTrail = widthOverTrail;
    }

    public NumberFunction getWidthOverTrail() {
        return this.widthOverTrail;
    }

    public void setColorOverTrail(NumberFunction colorOverTrail) {
        this.colorOverTrail = colorOverTrail;
    }

    public NumberFunction getColorOverTrail() {
        return this.colorOverTrail;
    }

    public MaterialSetting getMaterial() {
        return this.material;
    }

    public RendererSetting getRenderer() {
        return this.renderer;
    }

    public LightOverLifetimeSetting getLights() {
        return this.lights;
    }

    public UVAnimationSetting getUvAnimation() {
        return this.uvAnimation;
    }

    private class RenderType
    extends PhotonParticleRenderType {
        private BlendMode lastBlend = null;

        private RenderType() {
        }

        @Override
        public void prepareStatus() {
            if (TrailConfig.this.renderer.isBloomEffect()) {
                this.beginBloom();
                BloomEffect.setBloomColor(TrailConfig.this.renderer.getBloomColor());
            } else {
                RenderSystem.setShader(GameRenderer::m_172829_);
            }
            TrailConfig.this.material.pre();
            TrailConfig.this.material.getMaterial().begin(false);
            ShaderInstance shaderInstance = RenderSystem.getShader();
            if (shaderInstance instanceof ShaderInstanceAccessor) {
                ShaderInstanceAccessor shader = (ShaderInstanceAccessor)shaderInstance;
                this.lastBlend = BlendModeAccessor.getLastApplied();
                BlendModeAccessor.setLastApplied(shader.getBlend());
            }
            RenderTarget input = BloomEffect.getInput();
            input.m_83947_(false);
            Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        }

        @Override
        public void begin(@Nonnull BufferBuilder bufferBuilder) {
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85813_);
        }

        @Override
        public void releaseStatus() {
            TrailConfig.this.material.getMaterial().end(false);
            TrailConfig.this.material.post();
            if (this.lastBlend != null) {
                this.lastBlend.m_85526_();
                this.lastBlend = null;
            }
            this.endParticle();
        }

        @Override
        public boolean isParallel() {
            return TrailConfig.this.isParallelRendering();
        }
    }
}

