/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.particle;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.data.ColorBySpeedSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.ColorOverLifetimeSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.EmissionSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.ForceOverLifetimeSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.InheritVelocitySetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.LifetimeByEmitterSpeedSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.LightOverLifetimeSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.MaterialSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.NoiseSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.PhysicsSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.RendererSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.RotationBySpeedSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.RotationOverLifetimeSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.ShapeSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.SizeBySpeedSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.SizeOverLifetimeSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.SubEmittersSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.TrailsSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.UVAnimationSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.VelocityOverLifetimeSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3Config;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.Color;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.Gradient;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomColor;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomGradient;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.postprocessing.BloomEffect;
import com.lowdragmc.photon.core.mixins.accessor.BlendModeAccessor;
import com.lowdragmc.photon.core.mixins.accessor.ShaderInstanceAccessor;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.nbt.CompoundTag;

public class ParticleConfig
implements IPersistedSerializable {
    @Configurable(tips={"photon.emitter.config.duration"})
    @NumberRange(range={1.0, 2.147483647E9})
    protected int duration = 100;
    @Configurable(tips={"photon.emitter.config.looping"})
    protected boolean looping = true;
    @Configurable(tips={"photon.emitter.config.startDelay"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, isDecimals=false, min=0.0f, curveConfig=@CurveConfig(bound={0.0f, 100.0f}, xAxis="duration", yAxis="delay"))
    protected NumberFunction startDelay = NumberFunction.constant(0);
    @Configurable(tips={"photon.emitter.config.startLifetime"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, isDecimals=false, min=0.0f, defaultValue=100.0f, curveConfig=@CurveConfig(bound={0.0f, 200.0f}, xAxis="duration", yAxis="life time"))
    protected NumberFunction startLifetime = NumberFunction.constant(100);
    @Configurable(tips={"photon.emitter.config.startSpeed"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, defaultValue=1.0f, curveConfig=@CurveConfig(bound={-2.0f, 2.0f}, xAxis="duration", yAxis="speed"))
    protected NumberFunction startSpeed = NumberFunction.constant(1);
    @Configurable(tips={"photon.emitter.config.startSize"})
    @NumberFunction3Config(common=@NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, defaultValue=0.1f, curveConfig=@CurveConfig(bound={0.0f, 1.0f}, xAxis="duration", yAxis="size")))
    protected NumberFunction3 startSize = new NumberFunction3(0.1, 0.1, 0.1);
    @Configurable(tips={"photon.emitter.config.startRotation"})
    @NumberFunction3Config(affectX=false, affectY=false, common=@NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=10.0f, curveConfig=@CurveConfig(bound={0.0f, 360.0f}, xAxis="duration", yAxis="rotation")))
    protected NumberFunction3 startRotation = new NumberFunction3(0, 0, 0);
    @Configurable(tips={"photon.emitter.config.startColor"})
    @NumberFunctionConfig(types={Color.class, RandomColor.class, Gradient.class, RandomGradient.class}, defaultValue=-1.0f)
    protected NumberFunction startColor = NumberFunction.color(-1);
    @Configurable(tips={"photon.emitter.config.simulationSpace"})
    protected Space simulationSpace = Space.Local;
    @Configurable(tips={"photon.emitter.config.maxParticles"})
    @NumberRange(range={0.0, 100000.0}, wheel=100.0)
    protected int maxParticles = 2000;
    @Configurable(tips={"photon.emitter.config.parallelUpdate.0", "photon.emitter.config.parallelUpdate.1"})
    protected boolean parallelUpdate = false;
    @Configurable(tips={"photon.emitter.config.parallelRendering.0", "photon.emitter.config.parallelRendering.1", "photon.emitter.config.parallelRendering.2"})
    protected boolean parallelRendering = false;
    @Configurable(name="Emission", subConfigurable=true, tips={"photon.emitter.config.emission"})
    public final EmissionSetting emission = new EmissionSetting();
    @Configurable(name="Shape", subConfigurable=true, tips={"photon.emitter.config.shape"})
    public final ShapeSetting shape = new ShapeSetting();
    @Configurable(name="Material", subConfigurable=true, tips={"photon.emitter.config.material"})
    public final MaterialSetting material = new MaterialSetting();
    @Configurable(name="Renderer", subConfigurable=true, tips={"photon.emitter.config.renderer"})
    public final RendererSetting.Particle renderer = new RendererSetting.Particle();
    @Configurable(name="Physics", subConfigurable=true, tips={"photon.emitter.config.physics"})
    public final PhysicsSetting physics = new PhysicsSetting();
    @Configurable(name="Fixed Light", subConfigurable=true, tips={"photon.emitter.config.lights"})
    public final LightOverLifetimeSetting lights = new LightOverLifetimeSetting();
    @Configurable(name="Velocity over Lifetime", subConfigurable=true, tips={"photon.emitter.config.velocityOverLifetime"})
    public final VelocityOverLifetimeSetting velocityOverLifetime = new VelocityOverLifetimeSetting();
    @Configurable(name="Inherit Velocity", subConfigurable=true, tips={"photon.emitter.config.inheritVelocity"})
    public final InheritVelocitySetting inheritVelocity = new InheritVelocitySetting();
    @Configurable(name="Lifetime by Emitter Speed", subConfigurable=true, tips={"photon.emitter.config.lifetimeByEmitterSpeed"})
    public final LifetimeByEmitterSpeedSetting lifetimeByEmitterSpeed = new LifetimeByEmitterSpeedSetting();
    @Configurable(name="Force over Lifetime", subConfigurable=true, tips={"photon.emitter.config.forceOverLifetime"})
    public final ForceOverLifetimeSetting forceOverLifetime = new ForceOverLifetimeSetting();
    @Configurable(name="Color over Lifetime", subConfigurable=true, tips={"photon.emitter.config.colorOverLifetime"})
    public final ColorOverLifetimeSetting colorOverLifetime = new ColorOverLifetimeSetting();
    @Configurable(name="Color by Speed", subConfigurable=true, tips={"photon.emitter.config.colorBySpeed"})
    public final ColorBySpeedSetting colorBySpeed = new ColorBySpeedSetting();
    @Configurable(name="Size over Lifetime", subConfigurable=true, tips={"photon.emitter.config.sizeOverLifetime"})
    public final SizeOverLifetimeSetting sizeOverLifetime = new SizeOverLifetimeSetting();
    @Configurable(name="Size by Speed", subConfigurable=true, tips={"photon.emitter.config.sizeBySpeed"})
    public final SizeBySpeedSetting sizeBySpeed = new SizeBySpeedSetting();
    @Configurable(name="Rotation over Lifetime", subConfigurable=true, tips={"photon.emitter.config.rotationOverLifetime"})
    public final RotationOverLifetimeSetting rotationOverLifetime = new RotationOverLifetimeSetting();
    @Configurable(name="Rotation by Speed", subConfigurable=true, tips={"photon.emitter.config.rotationBySpeed"})
    public final RotationBySpeedSetting rotationBySpeed = new RotationBySpeedSetting();
    @Configurable(name="Noise", subConfigurable=true, tips={"photon.emitter.config.noise"})
    public final NoiseSetting noise = new NoiseSetting();
    @Configurable(name="UV Animation", subConfigurable=true, tips={"photon.emitter.config.uvAnimation"})
    public final UVAnimationSetting uvAnimation = new UVAnimationSetting();
    @Configurable(name="Trails", subConfigurable=true, tips={"photon.emitter.config.trails"})
    public final TrailsSetting trails = new TrailsSetting();
    @Configurable(name="Sub Emitters", subConfigurable=true, tips={"photon.emitter.config.sub_emitters"})
    public final SubEmittersSetting subEmitters = new SubEmittersSetting();
    public final PhotonParticleRenderType particleRenderType = new RenderType();

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        if (!tag.m_128441_("simulationSpace")) {
            NumberFunction number = NumberFunction.deserializeWrapper(tag.m_128469_("startSize"));
            this.startSize = new NumberFunction3(number, NumberFunction.copy(number), NumberFunction.copy(number));
            this.startRotation = new NumberFunction3(this.startRotation.z, this.startRotation.y, this.startRotation.x);
            this.simulationSpace = Space.World;
        }
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setStartDelay(NumberFunction startDelay) {
        this.startDelay = startDelay;
    }

    public NumberFunction getStartDelay() {
        return this.startDelay;
    }

    public void setStartLifetime(NumberFunction startLifetime) {
        this.startLifetime = startLifetime;
    }

    public NumberFunction getStartLifetime() {
        return this.startLifetime;
    }

    public void setStartSpeed(NumberFunction startSpeed) {
        this.startSpeed = startSpeed;
    }

    public NumberFunction getStartSpeed() {
        return this.startSpeed;
    }

    public void setStartSize(NumberFunction3 startSize) {
        this.startSize = startSize;
    }

    public NumberFunction3 getStartSize() {
        return this.startSize;
    }

    public void setStartRotation(NumberFunction3 startRotation) {
        this.startRotation = startRotation;
    }

    public NumberFunction3 getStartRotation() {
        return this.startRotation;
    }

    public void setStartColor(NumberFunction startColor) {
        this.startColor = startColor;
    }

    public NumberFunction getStartColor() {
        return this.startColor;
    }

    public void setSimulationSpace(Space simulationSpace) {
        this.simulationSpace = simulationSpace;
    }

    public Space getSimulationSpace() {
        return this.simulationSpace;
    }

    public void setMaxParticles(int maxParticles) {
        this.maxParticles = maxParticles;
    }

    public int getMaxParticles() {
        return this.maxParticles;
    }

    public void setParallelUpdate(boolean parallelUpdate) {
        this.parallelUpdate = parallelUpdate;
    }

    public boolean isParallelUpdate() {
        return this.parallelUpdate;
    }

    public void setParallelRendering(boolean parallelRendering) {
        this.parallelRendering = parallelRendering;
    }

    public boolean isParallelRendering() {
        return this.parallelRendering;
    }

    public static enum Space {
        Local,
        World;

    }

    private class RenderType
    extends PhotonParticleRenderType {
        private BlendMode lastBlend = null;

        private RenderType() {
        }

        @Override
        public void prepareStatus() {
            if (ParticleConfig.this.renderer.isBloomEffect()) {
                this.beginBloom();
                BloomEffect.setBloomColor(ParticleConfig.this.renderer.getBloomColor());
            } else {
                RenderSystem.setShader(GameRenderer::m_172829_);
            }
            ParticleConfig.this.material.pre();
            ParticleConfig.this.material.getMaterial().begin(false);
            ShaderInstance shaderInstance = RenderSystem.getShader();
            if (shaderInstance instanceof ShaderInstanceAccessor) {
                ShaderInstanceAccessor shader = (ShaderInstanceAccessor)shaderInstance;
                this.lastBlend = BlendModeAccessor.getLastApplied();
                BlendModeAccessor.setLastApplied(shader.getBlend());
            }
            RenderTarget input = BloomEffect.getInput();
            input.m_83947_(false);
            Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        }

        @Override
        public void begin(@Nonnull BufferBuilder bufferBuilder) {
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        @Override
        public void releaseStatus() {
            ParticleConfig.this.material.getMaterial().end(false);
            ParticleConfig.this.material.post();
            if (this.lastBlend != null) {
                this.lastBlend.m_85526_();
                this.lastBlend = null;
            }
            this.endParticle();
        }

        @Override
        public boolean isParallel() {
            return ParticleConfig.this.isParallelRendering();
        }
    }
}

