/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.shape;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Vector3fHelper;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.data.shape.IShape;
import com.lowdragmc.photon.client.gameobject.emitter.data.shape.MeshData;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import com.lowdragmc.photon.gui.editor.FXProject;
import com.lowdragmc.photon.gui.editor.MeshesResource;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@LDLRegister(name="mesh", group="shape")
public class Mesh
implements IShape {
    @Configurable(tips={"photon.emitter.config.shape.mesh.type"})
    private Type type = Type.Triangle;
    private final MeshData meshData = new MeshData();

    @Override
    public void nextPosVel(TileParticle particle, IParticleEmitter emitter, Vector3f position, Vector3f rotation, Vector3f scale) {
        MeshData.Triangle triangle;
        Vector3f pos = null;
        RandomSource random = particle.getRandomSource();
        float t = random.m_188501_();
        if (this.type == Type.Vertex) {
            pos = this.meshData.getRandomVertex(t);
            if (pos != null) {
                pos = new Vector3f((Vector3fc)pos);
            }
        } else if (this.type == Type.Edge) {
            MeshData.Edge edge = this.meshData.getRandomEdge(t);
            if (edge != null) {
                pos = new Vector3f((Vector3fc)edge.b).sub((Vector3fc)edge.a).mul(random.m_188501_()).add((Vector3fc)edge.a);
            }
        } else if (this.type == Type.Triangle && (triangle = this.meshData.getRandomTriangle(t)) != null) {
            float sqrtR = (float)Math.sqrt(random.m_188501_());
            float A = 1.0f - sqrtR;
            float r2 = random.m_188501_();
            float B = sqrtR * (1.0f - r2);
            float C = sqrtR * r2;
            float x = A * triangle.a.x + B * triangle.b.x + C * triangle.c.x;
            float y = A * triangle.a.y + B * triangle.b.y + C * triangle.c.y;
            float z = A * triangle.a.z + B * triangle.b.z + C * triangle.c.z;
            pos = new Vector3f(x, y, z);
        }
        if (pos != null) {
            pos.mul((Vector3fc)scale);
            particle.setLocalPos(Vector3fHelper.rotateYXY((Vector3f)new Vector3f((Vector3fc)pos), (Vector3f)rotation).add((Vector3fc)position).add((Vector3fc)particle.getLocalPos()), true);
            particle.setInternalVelocity(new Vector3f(0.0f, 0.0f, 0.0f));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void buildConfigurator(ConfiguratorGroup father) {
        IProject iProject;
        IShape.super.buildConfigurator(father);
        if (Editor.INSTANCE != null && (iProject = Editor.INSTANCE.getCurrentProject()) instanceof FXProject) {
            FXProject project = (FXProject)iProject;
            Object v = project.getResources().resources.get("mesh");
            if (v instanceof MeshesResource) {
                MeshesResource meshesResource = (MeshesResource)((Object)v);
                SelectorConfigurator selectorConfigurator = new SelectorConfigurator("mesh", () -> this.meshData.meshName, name -> {
                    MeshData mesh = (MeshData)meshesResource.getBuiltinResource((String)name);
                    if (mesh == null) {
                        mesh = (MeshData)meshesResource.getStaticResource(meshesResource.getStaticResourceFile((String)name));
                    }
                    if (mesh != null) {
                        this.meshData.deserializeNBT(mesh.serializeNBT());
                    }
                }, (Object)this.meshData.meshName, true, meshesResource.allResources().map(Map.Entry::getKey).map(arg_0 -> ((MeshesResource)meshesResource).getResourceName(arg_0)).toList(), String::toString);
                selectorConfigurator.setDraggingConsumer(o -> o instanceof MeshData, o -> selectorConfigurator.getSelector().setButtonBackground(new IGuiTexture[]{ColorPattern.GREEN.rectTexture().setRadius(5.0f)}), o -> selectorConfigurator.getSelector().setButtonBackground(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)}), o -> {
                    if (o instanceof MeshData) {
                        MeshData m = (MeshData)o;
                        this.meshData.deserializeNBT(m.serializeNBT());
                    }
                    selectorConfigurator.getSelector().setButtonBackground(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)});
                });
                selectorConfigurator.setTips(new String[]{"photon.emitter.config.shape.mesh.mesh"});
                father.addConfigurators(new Configurator[]{selectorConfigurator});
                return;
            }
        }
        IGuiTexture[] iGuiTextureArray = new IGuiTexture[2];
        ColorRectTexture texture = ColorPattern.T_GRAY.rectTexture().setRadius(5.0f);
        iGuiTextureArray[0] = texture;
        iGuiTextureArray[1] = new TextTexture("meshName").setType(TextTexture.TextType.ROLL_ALWAYS).setWidth(200);
        ImageWidget imageWidget = new ImageWidget(0, 0, 200, 10, (IGuiTexture)new GuiTextureGroup(iGuiTextureArray));
        WrapperConfigurator wrapper = new WrapperConfigurator("", (Widget)imageWidget);
        wrapper.setTips(new String[]{"drag a mesh."});
        imageWidget.setDraggingConsumer(o -> o instanceof MeshData, arg_0 -> Mesh.lambda$buildConfigurator$7((IGuiTexture)texture, arg_0), arg_0 -> Mesh.lambda$buildConfigurator$8((IGuiTexture)texture, arg_0), arg_0 -> this.lambda$buildConfigurator$9((IGuiTexture)texture, arg_0));
        father.addConfigurators(new Configurator[]{wrapper});
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = IShape.super.serializeNBT();
        tag.m_128365_("mesh", (Tag)this.meshData.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        IShape.super.deserializeNBT(tag);
        this.meshData.deserializeNBT(tag.m_128469_("mesh"));
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public MeshData getMeshData() {
        return this.meshData;
    }

    private /* synthetic */ void lambda$buildConfigurator$9(IGuiTexture texture, Object o) {
        if (o instanceof MeshData) {
            MeshData m = (MeshData)o;
            this.meshData.deserializeNBT(m.serializeNBT());
        }
        texture.setColor(ColorPattern.T_GRAY.color);
    }

    private static /* synthetic */ void lambda$buildConfigurator$8(IGuiTexture texture, Object o) {
        texture.setColor(ColorPattern.T_GRAY.color);
    }

    private static /* synthetic */ void lambda$buildConfigurator$7(IGuiTexture texture, Object o) {
        texture.setColor(ColorPattern.GREEN.color);
    }

    public static enum Type {
        Vertex,
        Edge,
        Triangle;

    }
}

