/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.shape;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.utils.Vector3fHelper;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.data.shape.IShape;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import net.minecraft.util.RandomSource;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@LDLRegister(name="box", group="shape")
public class Box
implements IShape {
    @Configurable
    private Type emitFrom = Type.Volume;

    @Override
    public void nextPosVel(TileParticle particle, IParticleEmitter emitter, Vector3f position, Vector3f rotation, Vector3f scale) {
        RandomSource random = particle.getRandomSource();
        scale = new Vector3f(Math.abs(scale.x), Math.abs(scale.y), Math.abs(scale.z)).mul(0.5f);
        Vector3f pos = new Vector3f(random.m_188501_() * 2.0f * scale.x - scale.x, random.m_188501_() * 2.0f * scale.y - scale.y, random.m_188501_() * 2.0f * scale.z - scale.z);
        if (this.emitFrom == Type.Shell) {
            double xy = scale.x * scale.y;
            double yz = scale.y * scale.z;
            double xz = scale.x * scale.z;
            double randomValue = random.m_188500_() * (xy + yz + xz);
            if (randomValue < xy) {
                pos.z = (double)random.m_188501_() > 0.5 ? scale.z : -scale.z;
            } else if (randomValue < yz + xy) {
                pos.x = (double)random.m_188501_() > 0.5 ? scale.x : -scale.x;
            } else {
                pos.y = (double)random.m_188501_() > 0.5 ? scale.y : -scale.y;
            }
        } else if (this.emitFrom == Type.Edge) {
            double randomValue = random.m_188500_() * (double)(scale.x + scale.y + scale.z);
            if (randomValue < (double)scale.x) {
                pos.z = (double)random.m_188501_() > 0.5 ? scale.z : -scale.z;
                pos.y = (double)random.m_188501_() > 0.5 ? scale.y : -scale.y;
            } else if (randomValue < (double)(scale.x + scale.y)) {
                pos.z = (double)random.m_188501_() > 0.5 ? scale.z : -scale.z;
                pos.x = (double)random.m_188501_() > 0.5 ? scale.x : -scale.x;
            } else {
                pos.x = (double)random.m_188501_() > 0.5 ? scale.x : -scale.x;
                pos.y = (double)random.m_188501_() > 0.5 ? scale.y : -scale.y;
            }
        }
        particle.setLocalPos(Vector3fHelper.rotateYXY((Vector3f)new Vector3f((Vector3fc)pos), (Vector3f)rotation).add((Vector3fc)position).add((Vector3fc)particle.getLocalPos()), true);
        particle.setInternalVelocity(Vector3fHelper.rotateYXY((Vector3f)new Vector3f(0.0f, 0.05f, 0.0f), (Vector3f)rotation));
    }

    public Type getEmitFrom() {
        return this.emitFrom;
    }

    public void setEmitFrom(Type emitFrom) {
        this.emitFrom = emitFrom;
    }

    public static enum Type {
        Volume,
        Shell,
        Edge;

    }
}

