/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.number.curve;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.ECBCurves;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CurveTexture
extends TransformTexture {
    private final ECBCurves curves;
    private int color;
    private float width;

    public CurveTexture(ECBCurves curves) {
        this.color = ColorPattern.T_RED.color;
        this.width = 0.5f;
        this.curves = curves;
    }

    public CurveTexture setColor(int color) {
        this.color = color;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawInternal(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        ArrayList<Vec2> points = new ArrayList<Vec2>();
        for (int i = 0; i < width; ++i) {
            float coordX = (float)i * 1.0f / (float)width;
            points.add(new Vec2(coordX, this.curves.getCurveY(coordX)));
        }
        points.add(new Vec2(1.0f, this.curves.getCurveY(1.0f)));
        DrawerHelper.drawLines((GuiGraphics)graphics, points.stream().map(coord -> new Vec2(x + (float)width * coord.f_82470_, y + (float)height * (1.0f - coord.f_82471_))).toList(), (int)this.color, (int)this.color, (float)this.width);
    }

    public void setWidth(float width) {
        this.width = width;
    }
}

