/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.number.color;

import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.utils.GradientColor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class RandomGradientColorTexture
extends TransformTexture {
    public final GradientColor gradientColor0;
    public final GradientColor gradientColor1;

    public RandomGradientColorTexture(GradientColor gradientColor0, GradientColor gradientColor1) {
        this.gradientColor0 = gradientColor0;
        this.gradientColor1 = gradientColor1;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawInternal(GuiGraphics graphics, int mouseX, int mouseY, float posx, float posy, int width, int height) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Matrix4f mat = graphics.m_280168_().m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Function<Float, Float> getXPosition = coordX -> Float.valueOf(posx + (float)width * coordX.floatValue());
        float yh = (float)height / 2.0f + posy;
        RandomGradientColorTexture.drawGradient(posy, width, mat, buffer, getXPosition, yh, this.gradientColor0);
        yh = (float)height / 2.0f + (posy += (float)height / 2.0f);
        RandomGradientColorTexture.drawGradient(posy, width, mat, buffer, getXPosition, yh, this.gradientColor1);
        tesselator.m_85914_();
    }

    static void drawGradient(float posy, int width, Matrix4f mat, BufferBuilder buffer, Function<Float, Float> getXPosition, float yh, GradientColor gradientColor) {
        for (int i = 0; i < width; ++i) {
            Float x = getXPosition.apply(Float.valueOf((float)i * 1.0f / (float)width));
            Float xw = getXPosition.apply(Float.valueOf(((float)i + 1.0f) / (float)width));
            int startColor = gradientColor.getColor((float)i * 1.0f / (float)width);
            int endColor = gradientColor.getColor(((float)i + 1.0f) / (float)width);
            float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
            float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
            float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
            float startBlue = (float)(startColor & 0xFF) / 255.0f;
            float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
            float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
            float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
            float endBlue = (float)(endColor & 0xFF) / 255.0f;
            buffer.m_252986_(mat, xw.floatValue(), posy, 0.0f).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
            buffer.m_252986_(mat, x.floatValue(), posy, 0.0f).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
            buffer.m_252986_(mat, x.floatValue(), yh, 0.0f).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
            buffer.m_252986_(mat, xw.floatValue(), yh, 0.0f).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        }
    }
}

