/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.number.color;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.GradientColorWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.GradientColor;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.GradientColorTexture;
import com.lowdragmc.photon.gui.editor.GradientsResource;
import com.lowdragmc.photon.gui.editor.configurator.NumberFunctionConfigurator;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;

public class Gradient
implements NumberFunction {
    private final GradientColor gradientColor;

    public Gradient() {
        this.gradientColor = new GradientColor();
    }

    public Gradient(int color) {
        this.gradientColor = new GradientColor(new int[]{color, color});
    }

    public Gradient(NumberFunctionConfig config) {
        this((int)config.defaultValue());
    }

    @Override
    public Number get(RandomSource randomSource, float t) {
        return this.gradientColor.getColor(t);
    }

    @Override
    public Number get(float t, Supplier<Float> lerp) {
        return this.gradientColor.getColor(t);
    }

    @Override
    public NumberFunction copy() {
        Gradient copied = new Gradient();
        copied.deserializeNBT(this.serializeNBT());
        return copied;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Gradient) {
            Gradient gradient = (Gradient)obj;
            return this.gradientColor.serializeNBT().equals((Object)gradient.gradientColor.serializeNBT());
        }
        return super.equals(obj);
    }

    @Override
    public void createConfigurator(WidgetGroup group, NumberFunctionConfigurator configurator) {
        ColorBorderTexture background = ColorPattern.T_GRAY.borderTexture(1);
        group.addWidget(new ButtonWidget(0, 2, group.getSize().width, 10, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{background, new GradientColorTexture(this.gradientColor)}), cd -> {
            if (Editor.INSTANCE != null) {
                Size size = new Size(160, 188);
                Position position = group.getPosition();
                int rightPlace = group.getGui().getScreenWidth() - size.width;
                GradientColorWidget gradientWidget = new GradientColorWidget(5, 0, 150, this.gradientColor);
                gradientWidget.setOnUpdate(g -> configurator.updateValue(this));
                DialogWidget dialog = Editor.INSTANCE.openDialog(new DialogWidget(Math.min(position.x, rightPlace), Math.max(0, position.y - size.height), size.width, size.height));
                dialog.setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.BLACK.rectTexture(), ColorPattern.T_WHITE.borderTexture(-1)})});
                dialog.setClickClose(true);
                dialog.addWidget((Widget)gradientWidget);
            }
        }).setDraggingConsumer(o -> {
            GradientsResource.Gradients g;
            return o instanceof GradientsResource.Gradients && !(g = (GradientsResource.Gradients)o).isRandomGradient();
        }, o -> background.setColor(ColorPattern.GREEN.color), o -> background.setColor(ColorPattern.T_GRAY.color), o -> {
            if (o instanceof GradientsResource.Gradients) {
                GradientsResource.Gradients g = (GradientsResource.Gradients)o;
                this.gradientColor.deserializeNBT(g.gradient0.serializeNBT());
                configurator.updateValue(this);
                background.setColor(ColorPattern.T_GRAY.color);
            }
        }));
    }

    public CompoundTag serializeNBT() {
        return this.gradientColor.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.gradientColor.deserializeNBT(nbt);
    }

    public GradientColor getGradientColor() {
        return this.gradientColor;
    }
}

