/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.number;

import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.gui.editor.configurator.NumberFunctionConfigurator;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;

public class Constant
implements NumberFunction {
    private Number number;

    public Constant() {
        this.number = 0;
    }

    public Constant(Number number) {
        this.number = number;
    }

    public Constant(NumberFunctionConfig config) {
        this(Float.valueOf(config.isDecimals() ? config.defaultValue() : (float)((int)config.defaultValue())));
    }

    @Override
    public Number get(RandomSource randomSource, float t) {
        return this.number;
    }

    @Override
    public Number get(float t, Supplier<Float> lerp) {
        return this.number;
    }

    @Override
    public NumberFunction copy() {
        return new Constant(this.number);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Constant) {
            Constant constant = (Constant)obj;
            return this.number.equals(constant.number);
        }
        return super.equals(obj);
    }

    @Override
    public void createConfigurator(WidgetGroup group, NumberFunctionConfigurator configurator) {
        NumberConfigurator widget = new NumberConfigurator("", () -> Float.valueOf(configurator.getConfig().isDecimals() ? this.number.floatValue() : (float)this.number.intValue()), number -> {
            this.setNumber((Number)number);
            configurator.updateValue(this);
        }, this.number, true);
        group.addWidget((Widget)widget);
        widget.setRange((Number)Float.valueOf(configurator.getConfig().min()), (Number)Float.valueOf(configurator.getConfig().max()));
        widget.setWheel((Number)Float.valueOf(configurator.getConfig().isDecimals() ? configurator.getConfig().wheelDur() : (float)Math.max(1, (int)configurator.getConfig().wheelDur())));
        widget.setConfiguratorContainer(configurator.getConfiguratorContainer());
        widget.init(group.getSize().width);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.number instanceof Float || this.number instanceof Double) {
            tag.m_128350_("number", this.number.floatValue());
        } else {
            tag.m_128405_("number", this.number.intValue());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.number = nbt.m_128425_("number", 3) ? (Number)nbt.m_128451_("number") : (Number)Float.valueOf(nbt.m_128457_("number"));
    }

    public void setNumber(Number number) {
        this.number = number;
    }

    public Number getNumber() {
        return this.number;
    }
}

