/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.material;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.photon.Photon;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.IMaterial;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.ShaderInstanceMaterial;
import com.lowdragmc.photon.client.postprocessing.BloomEffect;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class TextureMaterial
extends ShaderInstanceMaterial {
    @Configurable
    public ResourceLocation texture = new ResourceLocation("textures/particle/glow.png");
    @Configurable
    @NumberRange(range={0.0, 1.0})
    public float discardThreshold = 0.01f;

    public TextureMaterial() {
    }

    public TextureMaterial(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    public CompoundTag serializeNBT(CompoundTag tag) {
        tag.m_128359_("texture", this.texture.toString());
        tag.m_128350_("discardThreshold", this.discardThreshold);
        return tag;
    }

    @Override
    public IMaterial copy() {
        TextureMaterial mat = new TextureMaterial(this.texture);
        mat.discardThreshold = this.discardThreshold;
        return mat;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.texture = new ResourceLocation(nbt.m_128461_("texture"));
        this.discardThreshold = nbt.m_128457_("discardThreshold");
    }

    @Override
    public ShaderInstance getShader() {
        return BloomEffect.getParticleShader();
    }

    @Override
    public void setupUniform() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        BloomEffect.getParticleShader().m_173356_("DiscardThreshold").m_5985_(this.discardThreshold);
    }

    @Override
    public void begin(boolean isInstancing) {
        if (Photon.isUsingShaderPack() && Editor.INSTANCE == null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        } else {
            RenderSystem.setShader(this::getShader);
            this.setupUniform();
        }
    }

    @Override
    public IGuiTexture preview() {
        return new ResourceTexture(this.texture.toString());
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        WidgetGroup widgetGroup = new WidgetGroup(0, 0, 100, 100);
        widgetGroup.addWidget((Widget)new ImageWidget(0, 0, 100, 100, () -> new ResourceTexture(this.texture.toString())).setBorder(2, ColorPattern.T_WHITE.color));
        widgetGroup.addWidget((Widget)new ButtonWidget(0, 0, 100, 100, IGuiTexture.EMPTY, cd -> {
            if (Editor.INSTANCE == null) {
                return;
            }
            File path = new File(Editor.INSTANCE.getWorkSpace(), "assets/ldlib/textures");
            DialogWidget.showFileDialog((WidgetGroup)Editor.INSTANCE, (String)"ldlib.gui.editor.tips.select_image", (File)path, (boolean)true, (Predicate)DialogWidget.suffixFilter((String[])new String[]{".png"}), r -> {
                if (r != null && r.isFile()) {
                    this.texture = new ResourceLocation("ldlib:" + r.getPath().replace(path.getPath(), "textures").replace('\\', '/'));
                }
            });
        }));
        WrapperConfigurator base = new WrapperConfigurator("ldlib.gui.editor.group.base_image", (Widget)widgetGroup);
        base.setTips(new String[]{"ldlib.gui.editor.tips.click_select_image"});
        father.addConfigurators(new Configurator[]{base});
        super.buildConfigurator(father);
    }
}

