/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.material;

import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.BlockTextureSheetMaterial;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.CustomShaderMaterial;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.TextureMaterial;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public interface IMaterial
extends IConfigurable,
ITagSerializable<CompoundTag> {
    public static final List<Class<? extends IMaterial>> MATERIALS = new ArrayList<Class<BlockTextureSheetMaterial>>(List.of(TextureMaterial.class, CustomShaderMaterial.class, BlockTextureSheetMaterial.class));

    public static IMaterial deserializeWrapper(CompoundTag tag) {
        String type = tag.m_128461_("_type");
        for (Class<? extends IMaterial> clazz : MATERIALS) {
            if (!clazz.getSimpleName().equals(type)) continue;
            try {
                IMaterial shape = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                shape.deserializeNBT((Tag)tag);
                return shape;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public void begin(boolean var1);

    public void end(boolean var1);

    public IGuiTexture preview();

    default public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("_type", this.getClass().getSimpleName());
        return this.serializeNBT(tag);
    }

    public CompoundTag serializeNBT(CompoundTag var1);

    default public IMaterial copy() {
        return IMaterial.deserializeWrapper(this.serializeNBT());
    }
}

