/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.material;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ColorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextBoxWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.IMaterial;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.ShaderInstanceMaterial;
import com.lowdragmc.photon.client.postprocessing.BloomEffect;
import com.lowdragmc.photon.core.mixins.accessor.ShaderInstanceAccessor;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class CustomShaderMaterial
extends ShaderInstanceMaterial {
    private static final Map<ResourceLocation, ShaderInstance> COMPILED_SHADERS = new HashMap<ResourceLocation, ShaderInstance>();
    @Configurable
    public ResourceLocation shader = new ResourceLocation("photon:circle");
    protected CompoundTag uniformTag = new CompoundTag();
    private String compiledErrorMessage = "";
    private Runnable uniformCache = null;

    public CustomShaderMaterial() {
        CompoundTag uniforms = new CompoundTag();
        ListTag list = new ListTag();
        list.add((Object)FloatTag.m_128566_((float)0.3f));
        uniforms.m_128365_("Radius", (Tag)list);
        this.uniformTag.m_128365_("uniforms", (Tag)uniforms);
    }

    public CustomShaderMaterial(ResourceLocation shader) {
        this.shader = shader;
    }

    @Override
    public CompoundTag serializeNBT(CompoundTag tag) {
        tag.m_128359_("shader", this.shader.toString());
        tag.m_128365_("uniform", (Tag)this.uniformTag);
        return tag;
    }

    @Override
    public IMaterial copy() {
        CustomShaderMaterial mat = new CustomShaderMaterial(this.shader);
        mat.uniformTag = this.uniformTag.m_6426_();
        return mat;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.uniformCache = null;
        this.shader = new ResourceLocation(nbt.m_128461_("shader"));
        this.uniformTag = nbt.m_128469_("uniform");
        this.compiledErrorMessage = "";
    }

    public boolean isCompiledError() {
        return this.getShader() == BloomEffect.getParticleShader();
    }

    public void recompile() {
        this.uniformTag = new CompoundTag();
        this.uniformCache = null;
        this.compiledErrorMessage = "";
        ShaderInstance removed = COMPILED_SHADERS.remove(this.shader);
        if (removed != null && removed != BloomEffect.getParticleShader()) {
            removed.close();
        }
    }

    @Override
    public ShaderInstance getShader() {
        return COMPILED_SHADERS.computeIfAbsent(this.shader, shader -> {
            try {
                return new ShaderInstance((ResourceProvider)Minecraft.m_91087_().m_91098_(), shader.toString(), DefaultVertexFormat.f_85813_);
            }
            catch (Throwable e) {
                this.compiledErrorMessage = e.getMessage();
                return BloomEffect.getParticleShader();
            }
        });
    }

    private Runnable combineRunnable(Runnable a, Runnable b) {
        return () -> {
            a.run();
            b.run();
        };
    }

    @Override
    public void setupUniform() {
        if (!this.isCompiledError()) {
            ShaderInstance shaderInstance;
            if (this.uniformCache != null) {
                this.uniformCache.run();
            } else if (!this.uniformTag.m_128456_() && (shaderInstance = this.getShader()) instanceof ShaderInstanceAccessor) {
                ShaderInstanceAccessor shaderInstance2 = (ShaderInstanceAccessor)shaderInstance;
                this.uniformCache = () -> {};
                if (this.uniformTag.m_128441_("samplers")) {
                    CompoundTag samplers = this.uniformTag.m_128469_("samplers");
                    HashSet<String> samplerNames = new HashSet<String>(shaderInstance2.getSamplerNames());
                    for (String key : samplers.m_128431_()) {
                        int index = -1;
                        ResourceLocation texture = null;
                        try {
                            index = Integer.parseInt(key);
                            texture = new ResourceLocation(samplers.m_128461_(key));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (index < 0 || texture == null || !samplerNames.contains("Sampler" + index)) continue;
                        int finalIndex = index;
                        ResourceLocation finalTexture = texture;
                        this.uniformCache = this.combineRunnable(this.uniformCache, () -> RenderSystem.setShaderTexture((int)finalIndex, (ResourceLocation)finalTexture));
                    }
                }
                if (this.uniformTag.m_128441_("uniforms")) {
                    CompoundTag uniforms = this.uniformTag.m_128469_("uniforms");
                    Map<String, Uniform> uniformMap = shaderInstance2.getUniformMap();
                    for (String key : uniforms.m_128431_()) {
                        Uniform u;
                        ListTag data = uniforms.m_128437_(key, 5);
                        if (!uniformMap.containsKey(key) || data.isEmpty() || (u = uniformMap.get(key)).m_166758_() != data.size()) continue;
                        int type = u.m_166759_();
                        if (type == 4) {
                            float value = data.m_128775_(0);
                            this.uniformCache = this.combineRunnable(this.uniformCache, () -> this.getShader().m_173356_(key).m_5985_(value));
                        }
                        if (type == 5) {
                            float[] value = new float[]{data.m_128775_(0), data.m_128775_(1)};
                            this.uniformCache = this.combineRunnable(this.uniformCache, () -> this.getShader().m_173356_(key).m_7971_(value[0], value[1]));
                        }
                        if (type == 6) {
                            float[] value = new float[]{data.m_128775_(0), data.m_128775_(1), data.m_128775_(2)};
                            this.uniformCache = this.combineRunnable(this.uniformCache, () -> this.getShader().m_173356_(key).m_5889_(value[0], value[1], value[2]));
                        }
                        if (type != 7) continue;
                        float[] value = new float[]{data.m_128775_(0), data.m_128775_(1), data.m_128775_(2), data.m_128775_(3)};
                        this.uniformCache = this.combineRunnable(this.uniformCache, () -> this.getShader().m_173356_(key).m_5805_(value[0], value[1], value[2], value[3]));
                    }
                }
            } else {
                this.uniformCache = () -> {};
            }
        }
    }

    @Override
    public IGuiTexture preview() {
        return this.isCompiledError() ? new TextTexture(this.compiledErrorMessage.isEmpty() ? "error" : this.compiledErrorMessage, -65536) : this.preview;
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        WidgetGroup preview = new WidgetGroup(0, 0, 100, 120);
        WidgetGroup shaderConfigurator = new WidgetGroup(0, 0, 200, 0);
        preview.addWidget((Widget)new ImageWidget(0, 0, 100, 100, () -> this.isCompiledError() ? new TextTexture(this.compiledErrorMessage.isEmpty() ? "error" : this.compiledErrorMessage, -65536) : this.preview).setBorder(2, ColorPattern.T_WHITE.color));
        preview.addWidget((Widget)new ButtonWidget(0, 0, 100, 100, IGuiTexture.EMPTY, cd -> {
            if (Editor.INSTANCE == null) {
                return;
            }
            File path = new File(Editor.INSTANCE.getWorkSpace(), "assets/ldlib/shaders/core");
            DialogWidget.showFileDialog((WidgetGroup)Editor.INSTANCE, (String)"select a shader config", (File)path, (boolean)true, (Predicate)DialogWidget.suffixFilter((String[])new String[]{".json"}), r -> {
                if (r != null && r.isFile()) {
                    this.shader = new ResourceLocation("ldlib:" + r.getName().substring(0, r.getName().length() - 5));
                    this.uniformTag = new CompoundTag();
                    this.uniformCache = null;
                    this.updateShaderUniformConfigurator(shaderConfigurator);
                    father.computeLayout();
                }
            });
        }));
        preview.addWidget((Widget)new ButtonWidget(5, 110, 90, 10, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), new TextTexture("recompile")}), cd -> {
            this.recompile();
            this.updateShaderUniformConfigurator(shaderConfigurator);
            father.computeLayout();
        }));
        this.updateShaderUniformConfigurator(shaderConfigurator);
        WrapperConfigurator base = new WrapperConfigurator("ldlib.gui.editor.group.shader", (Widget)preview);
        base.setTips(new String[]{"ldlib.gui.editor.tips.click_select_shader"});
        father.addConfigurators(new Configurator[]{base});
        super.buildConfigurator(father);
        father.addConfigurators(new Configurator[]{new WrapperConfigurator("uniform settings", (Widget)shaderConfigurator)});
    }

    public void updateShaderUniformConfigurator(WidgetGroup group) {
        group.clearAllWidgets();
        if (this.isCompiledError()) {
            TextBoxWidget box = new TextBoxWidget(0, 0, 200, List.of(this.compiledErrorMessage.isEmpty() ? "error" : this.compiledErrorMessage)).setFontColor(-1);
            group.addWidget((Widget)box);
            group.setSize(new Size(200, box.getSize().height));
        } else {
            int height = 5;
            ShaderInstance shaderInstance = this.getShader();
            if (shaderInstance instanceof ShaderInstanceAccessor) {
                ShaderInstanceAccessor shaderAccessor = (ShaderInstanceAccessor)shaderInstance;
                List<String> samplerNames = shaderAccessor.getSamplerNames();
                for (String samplerName : samplerNames) {
                    if (!samplerName.startsWith("Sampler")) continue;
                    int index = -1;
                    try {
                        index = Integer.parseInt(samplerName.replaceAll("Sampler", ""));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (index < 0 || index == 2) continue;
                    WidgetGroup preview = new WidgetGroup(50, height + 10, 100, 100);
                    int finalIndex = index;
                    preview.addWidget((Widget)new ImageWidget(0, 0, 100, 100, () -> {
                        if (!this.uniformTag.m_128469_("samplers").m_128441_(String.valueOf(finalIndex))) {
                            return IGuiTexture.EMPTY;
                        }
                        return new ResourceTexture(this.uniformTag.m_128469_("samplers").m_128461_(String.valueOf(finalIndex)));
                    }).setBorder(2, ColorPattern.T_WHITE.color));
                    preview.addWidget((Widget)new ButtonWidget(0, 0, 100, 100, IGuiTexture.EMPTY, cd -> {
                        if (Editor.INSTANCE == null) {
                            return;
                        }
                        File path = new File(Editor.INSTANCE.getWorkSpace(), "assets/ldlib/textures");
                        DialogWidget.showFileDialog((WidgetGroup)Editor.INSTANCE, (String)"ldlib.gui.editor.tips.select_image", (File)path, (boolean)true, (Predicate)DialogWidget.suffixFilter((String[])new String[]{".png"}), r -> {
                            if (r != null && r.isFile()) {
                                String texture = "ldlib:" + r.getPath().replace(path.getPath(), "textures").replace('\\', '/');
                                this.uniformCache = null;
                                CompoundTag tag = this.uniformTag.m_128469_("samplers");
                                tag.m_128359_(String.valueOf(finalIndex), texture);
                                this.uniformTag.m_128365_("samplers", (Tag)tag);
                            }
                        });
                    }));
                    group.addWidget((Widget)new LabelWidget(10, height, samplerName));
                    group.addWidget((Widget)preview);
                    height += 115;
                }
                Map<String, Uniform> uniformMap = shaderAccessor.getUniformMap();
                for (Map.Entry<String, Uniform> entry : uniformMap.entrySet()) {
                    String uniformName = entry.getKey();
                    Uniform uniform = entry.getValue();
                    int type = uniform.m_166759_();
                    if (uniformName.equals("GameTime") || uniformName.equals("FogEnd") || uniformName.equals("ColorModulator") || uniformName.equals("FogStart") || uniformName.equals("FogColor")) continue;
                    if (type == 4) {
                        height = this.addUniformConfigurator(uniformName, group, 0, height);
                    } else if (type == 5) {
                        height = this.addUniformConfigurator(uniformName + ".x", group, 0, height);
                        height = this.addUniformConfigurator(uniformName + ".y", group, 1, height);
                    } else if (type == 6) {
                        height = this.addUniformConfigurator(uniformName + ".x", group, 0, height);
                        height = this.addUniformConfigurator(uniformName + ".y", group, 1, height);
                        height = this.addUniformConfigurator(uniformName + ".z", group, 2, height);
                    } else if (type == 7) {
                        if (uniformName.toLowerCase().contains("color")) {
                            height = this.addColorUniformConfigurator(uniformName, group, height);
                        } else {
                            height = this.addUniformConfigurator(uniformName + ".x", group, 0, height);
                            height = this.addUniformConfigurator(uniformName + ".y", group, 1, height);
                            height = this.addUniformConfigurator(uniformName + ".z", group, 2, height);
                            height = this.addUniformConfigurator(uniformName + ".w", group, 3, height);
                        }
                    }
                    height += 5;
                }
            }
            group.setSize(new Size(200, height == 5 ? 0 : height));
        }
    }

    private int addUniformConfigurator(String uniformName, WidgetGroup group, int index, int height) {
        NumberConfigurator configurator = new NumberConfigurator(uniformName, () -> {
            if (this.uniformTag.m_128469_("uniforms").m_128437_(uniformName, 5).size() < index) {
                return 0;
            }
            return Float.valueOf(this.uniformTag.m_128469_("uniforms").m_128437_(uniformName, 5).m_128775_(index));
        }, number -> {
            ListTag list = this.uniformTag.m_128469_("uniforms").m_128437_(uniformName, 5);
            while (list.size() < index + 1) {
                list.add((Object)FloatTag.m_128566_((float)0.0f));
            }
            list.set(index, (Tag)FloatTag.m_128566_((float)number.floatValue()));
            CompoundTag tag = this.uniformTag.m_128469_("uniforms");
            tag.m_128365_(uniformName, (Tag)list);
            this.uniformCache = null;
            this.uniformTag.m_128365_("uniforms", (Tag)tag);
        }, (Number)0, true);
        configurator.setRange((Number)Float.valueOf(-3.4028235E38f), (Number)Float.valueOf(Float.MAX_VALUE));
        configurator.init(200);
        configurator.addSelfPosition(0, height);
        group.addWidget((Widget)configurator);
        return height += 15;
    }

    private int addColorUniformConfigurator(String uniformName, WidgetGroup group, int height) {
        ColorConfigurator configurator = new ColorConfigurator(uniformName, () -> {
            ListTag list = this.uniformTag.m_128469_("uniforms").m_128437_(uniformName, 5);
            if (list.size() < 3) {
                return 0;
            }
            return ColorUtils.color((float)list.m_128775_(3), (float)list.m_128775_(0), (float)list.m_128775_(1), (float)list.m_128775_(2));
        }, number -> {
            ListTag list = this.uniformTag.m_128469_("uniforms").m_128437_(uniformName, 5);
            while (list.size() < 4) {
                list.add((Object)FloatTag.m_128566_((float)0.0f));
            }
            int color = number.intValue();
            list.set(0, (Tag)FloatTag.m_128566_((float)ColorUtils.red((int)color)));
            list.set(1, (Tag)FloatTag.m_128566_((float)ColorUtils.green((int)color)));
            list.set(2, (Tag)FloatTag.m_128566_((float)ColorUtils.blue((int)color)));
            list.set(3, (Tag)FloatTag.m_128566_((float)ColorUtils.alpha((int)color)));
            CompoundTag tag = this.uniformTag.m_128469_("uniforms");
            tag.m_128365_(uniformName, (Tag)list);
            this.uniformCache = null;
            this.uniformTag.m_128365_("uniforms", (Tag)tag);
        }, (Number)0, true);
        configurator.init(200);
        configurator.addSelfPosition(0, height);
        group.addWidget((Widget)configurator);
        return height += 15;
    }
}

