/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.utils.Vector3fHelper;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3Config;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class VelocityOverLifetimeSetting
extends ToggleGroup {
    @Configurable(tips={"photon.emitter.config.velocityOverLifetime.linear"})
    @NumberFunction3Config(common=@NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=1.0f, curveConfig=@CurveConfig(bound={-2.0f, 2.0f}, xAxis="lifetime", yAxis="additional velocity")))
    protected NumberFunction3 linear = new NumberFunction3(0, 0, 0);
    @Configurable(tips={"photon.emitter.config.velocityOverLifetime.orbitalMode"})
    protected OrbitalMode orbitalMode = OrbitalMode.AngularVelocity;
    @Configurable(tips={"photon.emitter.config.velocityOverLifetime.orbital"})
    @NumberFunction3Config(common=@NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=1.0f, curveConfig=@CurveConfig(bound={-2.0f, 2.0f}, xAxis="lifetime", yAxis="orbital velocity")))
    protected NumberFunction3 orbital = new NumberFunction3(0, 0, 0);
    @Configurable(tips={"photon.emitter.config.velocityOverLifetime.offset"})
    @NumberFunction3Config(common=@NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=1.0f, curveConfig=@CurveConfig(bound={-3.0f, 3.0f}, xAxis="lifetime", yAxis="orbital offset")))
    protected NumberFunction3 offset = new NumberFunction3(0, 0, 0);
    @Configurable(tips={"photon.emitter.config.velocityOverLifetime.speedModifier"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, defaultValue=1.0f, curveConfig=@CurveConfig(bound={-1.0f, 1.0f}, xAxis="lifetime", yAxis="speed modifier"))
    protected NumberFunction speedModifier = NumberFunction.constant(1);

    public Vector3f getVelocityAddition(TileParticle particle) {
        float lifetime = particle.getT();
        Vector3f addition = this.linear.get(lifetime, () -> Float.valueOf(particle.getMemRandom("vol0"))).mul(0.05f);
        Vector3f orbitalVec = this.orbital.get(lifetime, () -> Float.valueOf(particle.getMemRandom("vol1")));
        Vector3f center = this.offset.get(lifetime, () -> Float.valueOf(particle.getMemRandom("vol2")));
        if (!Vector3fHelper.isZero((Vector3f)orbitalVec)) {
            if (this.orbitalMode == OrbitalMode.AngularVelocity) {
                Vector3f radiusVec;
                Vector3f toPoint = new Vector3f((Vector3fc)particle.getLocalPos()).sub((Vector3fc)center);
                if (orbitalVec.x != 0.0f) {
                    radiusVec = new Vector3f((Vector3fc)toPoint).sub((Vector3fc)Vector3fHelper.project((Vector3f)new Vector3f((Vector3fc)toPoint), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f)));
                    addition.add((Vector3fc)new Vector3f((Vector3fc)radiusVec).rotateX(orbitalVec.x * 0.05f).sub((Vector3fc)radiusVec));
                }
                if (orbitalVec.y != 0.0f) {
                    radiusVec = new Vector3f((Vector3fc)toPoint).sub((Vector3fc)Vector3fHelper.project((Vector3f)new Vector3f((Vector3fc)toPoint), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f)));
                    addition.add((Vector3fc)new Vector3f((Vector3fc)radiusVec).rotateY(orbitalVec.y * 0.05f).sub((Vector3fc)radiusVec));
                }
                if (orbitalVec.z != 0.0f) {
                    radiusVec = new Vector3f((Vector3fc)toPoint).sub((Vector3fc)Vector3fHelper.project((Vector3f)new Vector3f((Vector3fc)toPoint), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f)));
                    addition.add((Vector3fc)new Vector3f((Vector3fc)radiusVec).rotateZ(orbitalVec.z * 0.05f).sub((Vector3fc)radiusVec));
                }
            } else if (this.orbitalMode == OrbitalMode.LinearVelocity) {
                float r;
                Vector3f radiusVec;
                Vector3f toPoint = particle.getLocalPos().sub((Vector3fc)center);
                if (orbitalVec.x != 0.0f) {
                    radiusVec = new Vector3f((Vector3fc)toPoint).sub((Vector3fc)Vector3fHelper.project((Vector3f)new Vector3f((Vector3fc)toPoint), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f)));
                    r = radiusVec.length();
                    addition.add((Vector3fc)new Vector3f((Vector3fc)radiusVec).rotateX(orbitalVec.x * 0.05f / r).sub((Vector3fc)radiusVec));
                }
                if (orbitalVec.y != 0.0f) {
                    radiusVec = new Vector3f((Vector3fc)toPoint).sub((Vector3fc)Vector3fHelper.project((Vector3f)new Vector3f((Vector3fc)toPoint), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f)));
                    r = radiusVec.length();
                    addition.add((Vector3fc)new Vector3f((Vector3fc)radiusVec).rotateY(orbitalVec.y * 0.05f / r).sub((Vector3fc)radiusVec));
                }
                if (orbitalVec.z != 0.0f) {
                    radiusVec = new Vector3f((Vector3fc)toPoint).sub((Vector3fc)Vector3fHelper.project((Vector3f)new Vector3f((Vector3fc)toPoint), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f)));
                    r = radiusVec.length();
                    addition.add((Vector3fc)new Vector3f((Vector3fc)radiusVec).rotateZ(orbitalVec.z * 0.05f / r).sub((Vector3fc)radiusVec));
                }
            } else if (this.orbitalMode == OrbitalMode.FixedVelocity) {
                Vector3f toCenter = center.sub((Vector3fc)particle.getLocalPos());
                if (orbitalVec.x != 0.0f) {
                    addition.add((Vector3fc)new Vector3f((Vector3fc)toCenter).cross((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)).normalize().mul(orbitalVec.x * 0.05f));
                }
                if (orbitalVec.y != 0.0f) {
                    addition.add((Vector3fc)new Vector3f((Vector3fc)toCenter).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).normalize().mul(orbitalVec.y * 0.05f));
                }
                if (orbitalVec.z != 0.0f) {
                    addition.add((Vector3fc)new Vector3f((Vector3fc)toCenter).cross((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)).normalize().mul(orbitalVec.z * 0.05f));
                }
            }
        }
        return addition;
    }

    public float getVelocityMultiplier(IParticle particle) {
        float lifetime = particle.getT();
        return this.speedModifier.get(lifetime, () -> Float.valueOf(particle.getMemRandom(this))).floatValue();
    }

    public NumberFunction3 getLinear() {
        return this.linear;
    }

    public OrbitalMode getOrbitalMode() {
        return this.orbitalMode;
    }

    public NumberFunction3 getOrbital() {
        return this.orbital;
    }

    public NumberFunction3 getOffset() {
        return this.offset;
    }

    public NumberFunction getSpeedModifier() {
        return this.speedModifier;
    }

    public void setLinear(NumberFunction3 linear) {
        this.linear = linear;
    }

    public void setOrbitalMode(OrbitalMode orbitalMode) {
        this.orbitalMode = orbitalMode;
    }

    public void setOrbital(NumberFunction3 orbital) {
        this.orbital = orbital;
    }

    public void setOffset(NumberFunction3 offset) {
        this.offset = offset;
    }

    public void setSpeedModifier(NumberFunction speedModifier) {
        this.speedModifier = speedModifier;
    }

    public static enum OrbitalMode {
        AngularVelocity,
        LinearVelocity,
        FixedVelocity;

    }
}

