/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorParser;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.Vector3fHelper;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.Color;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.Gradient;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomColor;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomGradient;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.emitter.particle.ParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.trail.TrailConfig;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import com.lowdragmc.photon.client.gameobject.particle.TrailParticle;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@OnlyIn(value=Dist.CLIENT)
public class TrailsSetting
extends ToggleGroup
implements IPersistedSerializable {
    @Configurable(tips={"photon.emitter.config.trails.ratio"})
    @NumberRange(range={0.0, 1.0})
    protected float ratio = 1.0f;
    @Configurable(tips={"photon.emitter.config.trails.lifetime"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, max=1.0f, defaultValue=1.0f, curveConfig=@CurveConfig(xAxis="lifetime", yAxis="trail length"))
    protected NumberFunction lifetime = NumberFunction.constant(1);
    @Configurable(tips={"photon.emitter.config.trails.dieWithParticles"})
    protected boolean dieWithParticles = false;
    @Configurable(tips={"photon.emitter.config.trails.sizeAffectsWidth"})
    protected boolean sizeAffectsWidth = true;
    @Configurable(tips={"photon.emitter.config.trails.sizeAffectsLifetime"})
    protected boolean sizeAffectsLifetime = false;
    @Configurable(tips={"photon.emitter.config.trails.inheritParticleColor"})
    protected boolean inheritParticleColor = true;
    @Configurable(tips={"photon.emitter.config.trails.colorOverLifetime"})
    @NumberFunctionConfig(types={Color.class, RandomColor.class, Gradient.class, RandomGradient.class}, defaultValue=-1.0f)
    protected NumberFunction colorOverLifetime = new Gradient();
    @Persisted(subPersisted=true)
    public final TrailConfig config = new TrailConfig();

    public TrailsSetting() {
        this.config.setWidthOverTrail(NumberFunction.constant(Float.valueOf(0.5f)));
        this.config.setParallelRendering(true);
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        if (tag.m_128441_("material")) {
            this.config.getMaterial().deserializeNBT(tag.m_128469_("material"));
            this.config.setColorOverTrail(NumberFunction.deserializeWrapper(tag.m_128469_("colorOverTrail")));
            this.config.setWidthOverTrail(NumberFunction.deserializeWrapper(tag.m_128469_("widthOverTrail")));
            this.config.setUvMode(TrailParticle.UVMode.valueOf(tag.m_128461_("uvMode")));
            this.config.setMinVertexDistance(tag.m_128457_("minimumVertexDistance"));
        }
    }

    public void setup(ParticleEmitter emitter, TileParticle particle) {
        RandomSource random = emitter.getRandomSource();
        if (random.m_188501_() < this.ratio) {
            TrailParticle trail = new TrailParticle(emitter, this.config, emitter.getThreadSafeRandomSource());
            trail.setDelay(particle.getDelay() + trail.getDelay());
            trail.setHeadPositionSupplier((Float2ObjectFunction<Vector3f>)((Float2ObjectFunction)particle::getWorldPos));
            trail.setDieWhenAllTailsRemoved(!this.dieWithParticles);
            trail.setOnUpdate(() -> {
                if (particle.isRemoved()) {
                    trail.setRemoved(true);
                }
            });
            trail.setLifetimeSupplier(() -> {
                float time = this.lifetime.get(particle.getT(), () -> Float.valueOf(particle.getMemRandom("trails-lifetime"))).floatValue() * (float)particle.getLifetime();
                if (this.sizeAffectsLifetime) {
                    time *= Vector3fHelper.max((Vector3f)particle.getRealSize(0.0f));
                }
                return Float.valueOf(time);
            });
            trail.setWidthMultiplier(() -> {
                if (this.sizeAffectsWidth) {
                    return Float.valueOf(Vector3fHelper.max((Vector3f)particle.getRealSize(0.0f)));
                }
                return Float.valueOf(1.0f);
            });
            trail.setColorMultiplier((Float2ObjectFunction<Vector4f>)((Float2ObjectFunction)t -> {
                Vector4f color = new Vector4f(1.0f);
                if (this.inheritParticleColor) {
                    color.mul((Vector4fc)particle.getRealColor(t));
                }
                if (this.colorOverLifetime != null) {
                    int c = this.colorOverLifetime.get(particle.getT(t), () -> Float.valueOf(particle.getMemRandom("trails-color"))).intValue();
                    color.mul(ColorUtils.red((int)c), ColorUtils.green((int)c), ColorUtils.blue((int)c), ColorUtils.alpha((int)c));
                }
                return color;
            }));
            emitter.emitParticle(trail);
        }
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ConfiguratorParser.createConfigurators((ConfiguratorGroup)father, new HashMap(), this.config.getClass(), (Object)this.config);
        for (Configurator configurator : father.getConfigurators()) {
            if (!configurator.getName().equals("time")) continue;
            father.removeConfigurator(configurator);
            break;
        }
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setLifetime(NumberFunction lifetime) {
        this.lifetime = lifetime;
    }

    public NumberFunction getLifetime() {
        return this.lifetime;
    }

    public void setDieWithParticles(boolean dieWithParticles) {
        this.dieWithParticles = dieWithParticles;
    }

    public boolean isDieWithParticles() {
        return this.dieWithParticles;
    }

    public void setSizeAffectsWidth(boolean sizeAffectsWidth) {
        this.sizeAffectsWidth = sizeAffectsWidth;
    }

    public boolean isSizeAffectsWidth() {
        return this.sizeAffectsWidth;
    }

    public void setSizeAffectsLifetime(boolean sizeAffectsLifetime) {
        this.sizeAffectsLifetime = sizeAffectsLifetime;
    }

    public boolean isSizeAffectsLifetime() {
        return this.sizeAffectsLifetime;
    }

    public void setInheritParticleColor(boolean inheritParticleColor) {
        this.inheritParticleColor = inheritParticleColor;
    }

    public boolean isInheritParticleColor() {
        return this.inheritParticleColor;
    }

    public void setColorOverLifetime(NumberFunction colorOverLifetime) {
        this.colorOverLifetime = colorOverLifetime;
    }

    public NumberFunction getColorOverLifetime() {
        return this.colorOverLifetime;
    }
}

