/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.utils.Range;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3Config;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class SizeBySpeedSetting
extends ToggleGroup {
    @Configurable(tips={"photon.emitter.config.sizeBySpeed.size"})
    @NumberFunction3Config(common=@NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, curveConfig=@CurveConfig(bound={-1.0f, 1.0f}, xAxis="speed", yAxis="size")))
    protected NumberFunction3 size = new NumberFunction3(1, 1, 1);
    @Configurable(tips={"photon.emitter.config.sizeBySpeed.speedRange"})
    @NumberRange(range={0.0, 1000.0})
    protected Range speedRange = new Range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f));

    public Vector3f getSize(TileParticle particle) {
        float value = particle.getRealVelocity().length() * 20.0f;
        float t = (value - this.speedRange.getA().floatValue()) / (this.speedRange.getB().floatValue() - this.speedRange.getA().floatValue());
        return this.size.get(t, () -> Float.valueOf(particle.getMemRandom("sbs0")));
    }

    public void setSize(NumberFunction3 size) {
        this.size = size;
    }

    public void setSpeedRange(Range speedRange) {
        this.speedRange = speedRange;
    }

    public NumberFunction3 getSize() {
        return this.size;
    }

    public Range getSpeedRange() {
        return this.speedRange;
    }
}

