/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RotationOverLifetimeSetting
extends ToggleGroup {
    @Configurable(tips={"photon.emitter.config.rotation.roll"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=10.0f, curveConfig=@CurveConfig(bound={0.0f, 360.0f}, xAxis="lifetime", yAxis="roll"))
    protected NumberFunction roll = NumberFunction.constant(0);
    @Configurable(tips={"photon.emitter.config.rotation.pitch"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=10.0f, curveConfig=@CurveConfig(bound={0.0f, 360.0f}, xAxis="lifetime", yAxis="pitch"))
    protected NumberFunction pitch = NumberFunction.constant(0);
    @Configurable(tips={"photon.emitter.config.rotation.yaw"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=10.0f, curveConfig=@CurveConfig(bound={0.0f, 360.0f}, xAxis="lifetime", yAxis="yaw"))
    protected NumberFunction yaw = NumberFunction.constant(0);

    public Vector3f getRotation(IParticle particle, float partialTicks) {
        float t = particle.getT(partialTicks);
        return new Vector3f(this.yaw.get(t, () -> Float.valueOf(particle.getMemRandom("rol2"))).floatValue(), this.pitch.get(t, () -> Float.valueOf(particle.getMemRandom("rol1"))).floatValue(), this.roll.get(t, () -> Float.valueOf(particle.getMemRandom("rol0"))).floatValue()).mul((float)Math.PI / 180);
    }

    public void setRoll(NumberFunction roll) {
        this.roll = roll;
    }

    public void setPitch(NumberFunction pitch) {
        this.pitch = pitch;
    }

    public void setYaw(NumberFunction yaw) {
        this.yaw = yaw;
    }

    public NumberFunction getRoll() {
        return this.roll;
    }

    public NumberFunction getPitch() {
        return this.pitch;
    }

    public NumberFunction getYaw() {
        return this.yaw;
    }
}

