/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.utils.Range;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RotationBySpeedSetting
extends ToggleGroup {
    @Configurable(tips={"photon.emitter.config.rotation.roll"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=10.0f, curveConfig=@CurveConfig(bound={0.0f, 360.0f}, xAxis="speed", yAxis="roll"))
    protected NumberFunction roll = NumberFunction.constant(0);
    @Configurable(tips={"photon.emitter.config.rotation.pitch"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=10.0f, curveConfig=@CurveConfig(bound={0.0f, 360.0f}, xAxis="speed", yAxis="pitch"))
    protected NumberFunction pitch = NumberFunction.constant(0);
    @Configurable(tips={"photon.emitter.config.rotation.yaw"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=10.0f, curveConfig=@CurveConfig(bound={0.0f, 360.0f}, xAxis="speed", yAxis="yaw"))
    protected NumberFunction yaw = NumberFunction.constant(0);
    @Configurable(tips={"photon.emitter.config.rotationBySpeed.speedRange"})
    @NumberRange(range={0.0, 1000.0})
    protected Range speedRange = new Range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f));

    public Vector3f getRotation(TileParticle particle) {
        float value = particle.getRealVelocity().length() * 20.0f;
        float t = (value - this.speedRange.getA().floatValue()) / (this.speedRange.getB().floatValue() - this.speedRange.getA().floatValue());
        return new Vector3f(this.roll.get(t, () -> Float.valueOf(particle.getMemRandom("rbs0"))).floatValue(), this.pitch.get(t, () -> Float.valueOf(particle.getMemRandom("rbs1"))).floatValue(), this.yaw.get(t, () -> Float.valueOf(particle.getMemRandom("rbs2"))).floatValue()).mul((float)Math.PI / 180);
    }

    public void setRoll(NumberFunction roll) {
        this.roll = roll;
    }

    public void setPitch(NumberFunction pitch) {
        this.pitch = pitch;
    }

    public void setYaw(NumberFunction yaw) {
        this.yaw = yaw;
    }

    public void setSpeedRange(Range speedRange) {
        this.speedRange = speedRange;
    }

    public NumberFunction getRoll() {
        return this.roll;
    }

    public NumberFunction getPitch() {
        return this.pitch;
    }

    public NumberFunction getYaw() {
        return this.yaw;
    }

    public Range getSpeedRange() {
        return this.speedRange;
    }
}

