/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.noise.PerlinNoise;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3Config;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class NoiseSetting
extends ToggleGroup {
    private final ThreadLocal<PerlinNoise> noise = ThreadLocal.withInitial(PerlinNoise::new);
    @Configurable(tips={"photon.emitter.config.noise.frequency"})
    @NumberRange(range={1.401298464324817E-45, 3.4028234663852886E38})
    protected float frequency = 1.0f;
    @Configurable(tips={"photon.emitter.config.noise.quality"})
    protected Quality quality = Quality.Noise2D;
    @Configurable(subConfigurable=true, tips={"photon.emitter.config.noise.remap"})
    protected final Remap remap = new Remap();
    @Configurable(tips={"photon.emitter.config.noise.position"})
    @NumberFunction3Config(common=@NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, curveConfig=@CurveConfig(bound={0.0f, 1.0f}, xAxis="lifetime", yAxis="strength")))
    protected NumberFunction3 position = new NumberFunction3(0.1, 0.1, 0.1);
    @Configurable(tips={"photon.emitter.config.noise.rotation"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=10.0f, curveConfig=@CurveConfig(bound={0.0f, 180.0f}, xAxis="rotation amount", yAxis="lifetime"))
    protected NumberFunction rotation = NumberFunction.constant(0);
    @Configurable(tips={"photon.emitter.config.noise.size"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, curveConfig=@CurveConfig(bound={-1.0f, 1.0f}, xAxis="size amount", yAxis="lifetime"))
    protected NumberFunction size = NumberFunction.constant(0);

    public float getNoise(float t) {
        float value;
        float input = t * this.frequency;
        switch (this.quality) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Noise1D: {
                float f = (float)this.noise.get().noise((double)input);
                break;
            }
            case Noise2D: {
                float f = (float)this.noise.get().noise((double)input, (double)input);
                break;
            }
            case Noise3D: {
                float f = value = (float)this.noise.get().noise((double)input, (double)input, (double)input);
            }
        }
        if (this.remap.isEnable()) {
            value = this.remap.remapCurve.get((value + 1.0f) / 2.0f, () -> Float.valueOf(0.0f)).floatValue();
        }
        return value;
    }

    public void setupSeed(IParticle particle) {
        this.noise.get().setSeed((double)(particle.getMemRandom("noise-seed", randomSource -> Float.valueOf((float)randomSource.m_188583_())) * 255.0f));
    }

    public Vector3f getRotation(IParticle particle, float partialTicks) {
        this.setupSeed(particle);
        float t = particle.getT(partialTicks);
        float degree = this.rotation.get(t, () -> Float.valueOf(particle.getMemRandom("noise-rotation"))).floatValue();
        if (degree != 0.0f) {
            return new Vector3f(degree, 0.0f, 0.0f).mul(this.getNoise((t + 10.0f * particle.getMemRandom("noise-rotation-degree")) * 100.0f) * ((float)Math.PI * 2) / 360.0f);
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public Vector3f getSize(IParticle particle, float partialTicks) {
        this.setupSeed(particle);
        float t = particle.getT(partialTicks);
        float scale = this.size.get(t, () -> Float.valueOf(particle.getMemRandom("noise-size"))).floatValue();
        if (scale != 0.0f) {
            return new Vector3f(scale, scale, scale).mul(this.getNoise((t + 10.0f * particle.getMemRandom("noise-size-scale")) * 100.0f));
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public Vector3f getPosition(IParticle particle, float partialTicks) {
        this.setupSeed(particle);
        float t = particle.getT(partialTicks);
        Vector3f offset = this.position.get(t, () -> Float.valueOf(particle.getMemRandom("noise-position")));
        if (offset.x != 0.0f || offset.y != 0.0f || offset.z != 0.0f) {
            offset.mul(this.getNoise((t + 10.0f * particle.getMemRandom("noise-position-x")) * 100.0f), this.getNoise((t + 10.0f * particle.getMemRandom("noise-position-y")) * 100.0f), this.getNoise((t + 10.0f * particle.getMemRandom("noise-position-z")) * 100.0f));
            return offset;
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        father.addConfigurator(0, (Configurator)new WrapperConfigurator("Noise preview", (Widget)new ImageWidget(0, 0, 100, 100, (IGuiTexture)new NoisePreview(LDLib.random.nextGaussian() * 255.0))));
    }

    public void setFrequency(float frequency) {
        this.frequency = frequency;
    }

    public void setQuality(Quality quality) {
        this.quality = quality;
    }

    public void setPosition(NumberFunction3 position) {
        this.position = position;
    }

    public void setRotation(NumberFunction rotation) {
        this.rotation = rotation;
    }

    public void setSize(NumberFunction size) {
        this.size = size;
    }

    public ThreadLocal<PerlinNoise> getNoise() {
        return this.noise;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public Remap getRemap() {
        return this.remap;
    }

    public NumberFunction3 getPosition() {
        return this.position;
    }

    public NumberFunction getRotation() {
        return this.rotation;
    }

    public NumberFunction getSize() {
        return this.size;
    }

    public static enum Quality {
        Noise1D,
        Noise2D,
        Noise3D;

    }

    public static class Remap
    extends ToggleGroup {
        @Configurable
        @NumberFunctionConfig(types={Curve.class}, defaultValue=1.0f, curveConfig=@CurveConfig(bound={-1.0f, 1.0f}, xAxis="base noise", yAxis="remap result"))
        protected NumberFunction remapCurve = new Curve(-2.1474836E9f, 2.1474836E9f, -1.0f, 1.0f, 1.0f, "base noise", "remap result");

        public void setRemapCurve(NumberFunction remapCurve) {
            this.remapCurve = remapCurve;
        }

        public NumberFunction getRemapCurve() {
            return this.remapCurve;
        }
    }

    private class NoisePreview
    implements IGuiTexture {
        private final double seed;

        public NoisePreview(double seed) {
            this.seed = seed;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
            NoiseSetting.this.noise.get().setSeed(this.seed);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Matrix4f mat = graphics.m_280168_().m_85850_().m_252922_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            RenderSystem.setShader(GameRenderer::m_172811_);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            for (int i = 0; i < width; ++i) {
                if (NoiseSetting.this.quality == Quality.Noise1D) {
                    float value = ((float)NoiseSetting.this.noise.get().noise((double)((float)i * NoiseSetting.this.frequency)) + 1.0f) / 2.0f;
                    if (NoiseSetting.this.remap.isEnable()) {
                        value = (NoiseSetting.this.remap.remapCurve.get(value, () -> Float.valueOf(0.0f)).floatValue() + 1.0f) / 2.0f;
                    }
                    buffer.m_252986_(mat, x + (float)i + 1.0f, y, 0.0f).m_85950_(value, value, value, 1.0f).m_5752_();
                    buffer.m_252986_(mat, x + (float)i, y, 0.0f).m_85950_(value, value, value, 1.0f).m_5752_();
                    buffer.m_252986_(mat, x + (float)i, y + (float)height, 0.0f).m_85950_(value, value, value, 1.0f).m_5752_();
                    buffer.m_252986_(mat, x + (float)i + 1.0f, y + (float)height, 0.0f).m_85950_(value, value, value, 1.0f).m_5752_();
                    continue;
                }
                for (int j = 0; j < height; ++j) {
                    float value = NoiseSetting.this.quality == Quality.Noise2D ? ((float)NoiseSetting.this.noise.get().noise((double)((float)i * NoiseSetting.this.frequency), (double)((float)j * NoiseSetting.this.frequency)) + 1.0f) / 2.0f : ((float)NoiseSetting.this.noise.get().noise((double)((float)i * NoiseSetting.this.frequency), (double)((float)j * NoiseSetting.this.frequency), 1.0) + 1.0f) / 2.0f;
                    if (NoiseSetting.this.remap.isEnable()) {
                        value = (NoiseSetting.this.remap.remapCurve.get(value, () -> Float.valueOf(0.0f)).floatValue() + 1.0f) / 2.0f;
                    }
                    buffer.m_252986_(mat, x + (float)i + 1.0f, y + (float)j, 0.0f).m_85950_(value, value, value, 1.0f).m_5752_();
                    buffer.m_252986_(mat, x + (float)i, y + (float)j, 0.0f).m_85950_(value, value, value, 1.0f).m_5752_();
                    buffer.m_252986_(mat, x + (float)i, y + (float)j + 1.0f, 0.0f).m_85950_(value, value, value, 1.0f).m_5752_();
                    buffer.m_252986_(mat, x + (float)i + 1.0f, y + (float)j + 1.0f, 0.0f).m_85950_(value, value, value, 1.0f).m_5752_();
                }
            }
            tesselator.m_85914_();
        }
    }
}

