/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LightOverLifetimeSetting
extends ToggleGroup {
    @Configurable(tips={"photon.emitter.config.lights.skyLight"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, isDecimals=false, defaultValue=15.0f, min=0.0f, max=15.0f, wheelDur=1.0f, curveConfig=@CurveConfig(xAxis="lifetime", yAxis="speed modifier"))
    protected NumberFunction skyLight = NumberFunction.constant(15);
    @Configurable(tips={"photon.emitter.config.lights.blockLight"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, isDecimals=false, defaultValue=15.0f, min=0.0f, max=15.0f, wheelDur=1.0f, curveConfig=@CurveConfig(xAxis="lifetime", yAxis="speed modifier"))
    protected NumberFunction blockLight = NumberFunction.constant(15);

    public LightOverLifetimeSetting() {
        this.enable = true;
    }

    public int getLight(IParticle particle, float partialTicks) {
        int sky = this.skyLight.get(particle.getT(partialTicks), () -> Float.valueOf(particle.getMemRandom("sky-light"))).intValue();
        int block = this.blockLight.get(particle.getT(partialTicks), () -> Float.valueOf(particle.getMemRandom("block-light"))).intValue();
        return sky << 20 | block << 4;
    }

    public void setSkyLight(NumberFunction skyLight) {
        this.skyLight = skyLight;
    }

    public void setBlockLight(NumberFunction blockLight) {
        this.blockLight = blockLight;
    }

    public NumberFunction getSkyLight() {
        return this.skyLight;
    }

    public NumberFunction getBlockLight() {
        return this.blockLight;
    }
}

