/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.utils.Range;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LifetimeByEmitterSpeedSetting
extends ToggleGroup {
    @Configurable(tips={"photon.emitter.config.lifetimeByEmitterSpeed.multiplier"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, defaultValue=1.0f, curveConfig=@CurveConfig(bound={0.0f, 1.0f}, xAxis="multiplier", yAxis="emitter velocity"))
    protected NumberFunction multiplier = NumberFunction.constant(1);
    @Configurable(tips={"photon.emitter.config.lifetimeByEmitterSpeed.speedRange"})
    @NumberRange(range={0.0, 1000.0})
    protected Range speedRange = new Range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f));

    public int getLifetime(IParticle particle, IParticleEmitter emitter, int initialLifetime) {
        float value = emitter.getVelocity().length() * 20.0f;
        return (int)(this.multiplier.get((value - this.speedRange.getA().floatValue()) / (this.speedRange.getB().floatValue() - this.speedRange.getA().floatValue()), () -> Float.valueOf(particle.getMemRandom(this))).floatValue() * (float)initialLifetime);
    }

    public void setMultiplier(NumberFunction multiplier) {
        this.multiplier = multiplier;
    }

    public void setSpeedRange(Range speedRange) {
        this.speedRange = speedRange;
    }

    public NumberFunction getMultiplier() {
        return this.multiplier;
    }

    public Range getSpeedRange() {
        return this.speedRange;
    }
}

