/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.Gradient;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomGradient;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class ColorOverLifetimeSetting
extends ToggleGroup {
    @Configurable(tips={"photon.emitter.config.colorOverLifetime.color"})
    @NumberFunctionConfig(types={Gradient.class, RandomGradient.class}, defaultValue=-1.0f)
    protected NumberFunction color = new Gradient();

    public Vector4f getColor(IParticle particle, float partialTicks) {
        int c = this.color.get(particle.getT(partialTicks), () -> Float.valueOf(particle.getMemRandom(this))).intValue();
        return new Vector4f((float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c & 0xFF) / 255.0f, (float)(c >> 24 & 0xFF) / 255.0f);
    }

    public void setColor(NumberFunction color) {
        this.color = color;
    }

    public NumberFunction getColor() {
        return this.color;
    }
}

