/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.beam;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorParser;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.photon.client.gameobject.emitter.Emitter;
import com.lowdragmc.photon.client.gameobject.emitter.ParticleQueueRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.beam.BeamConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.TextureMaterial;
import com.lowdragmc.photon.client.gameobject.particle.BeamParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@LDLRegisterClient(name="beam", group="emitter")
public class BeamEmitter
extends Emitter {
    public static int VERSION = 2;
    @Persisted(subPersisted=true)
    protected final BeamConfig config;
    protected BeamParticle beamParticle;

    public BeamEmitter() {
        this(new BeamConfig());
        this.config.material.setMaterial(new TextureMaterial(new ResourceLocation("photon:textures/particle/laser.png")));
    }

    public BeamEmitter(BeamConfig config) {
        this.config = config;
        this.init();
    }

    public void init() {
        this.beamParticle = new BeamParticle(this, this.config, this.getThreadSafeRandomSource());
    }

    @Override
    public BeamEmitter shallowCopy() {
        return new BeamEmitter(this.config);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_("_version", VERSION);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        int version;
        int n = version = tag.m_128441_("_version") ? tag.m_128451_("_version") : 0;
        if (version < 1) {
            CompoundTag configTag = tag;
            tag = new CompoundTag();
            tag.m_128365_("config", (Tag)configTag);
            tag.m_128359_("name", configTag.m_128461_("name"));
        }
        super.deserializeNBT(tag);
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ConfiguratorParser.createConfigurators((ConfiguratorGroup)father, new HashMap(), this.config.getClass(), (Object)this.config);
    }

    @Override
    public int getParticleAmount() {
        return this.beamParticle.isAlive() ? 1 : 0;
    }

    public int m_107273_() {
        return this.config.duration;
    }

    @Override
    protected void updateOrigin() {
        super.updateOrigin();
        this.m_107257_(this.config.duration);
    }

    @Override
    public boolean isLooping() {
        return this.config.isLooping();
    }

    @Override
    protected void update() {
        if (this.beamParticle.isAlive()) {
            this.beamParticle.tick();
        } else {
            this.m_107274_();
        }
        super.update();
    }

    @Override
    public void reset() {
        super.reset();
        this.init();
    }

    @Override
    public void m_5744_(@NotNull VertexConsumer buffer, Camera camera, float pPartialTicks) {
        super.m_5744_(buffer, camera, pPartialTicks);
        if (!ParticleQueueRenderType.INSTANCE.isRenderingQueue() && this.delay <= 0 && this.isVisible() && PhotonParticleRenderType.checkLayer(this.config.renderer.getLayer()) && (!this.config.renderer.getCull().isEnable() || PhotonParticleRenderType.checkFrustum(this.config.renderer.getCull().getCullAABB(this, pPartialTicks)))) {
            ParticleQueueRenderType.INSTANCE.pipeQueue(this.beamParticle.getRenderType(), Collections.singleton(this.beamParticle), camera, pPartialTicks);
        }
    }

    @Override
    @Nullable
    public AABB getCullBox(float partialTicks) {
        return this.config.renderer.getCull().isEnable() ? this.config.renderer.getCull().getCullAABB(this, partialTicks) : null;
    }

    @Override
    public void remove(boolean force) {
        super.remove(force);
        this.beamParticle.setRemoved(true);
    }

    public BeamConfig getConfig() {
        return this.config;
    }
}

