/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.beam;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.data.LightOverLifetimeSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.MaterialSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.RendererSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.UVAnimationSetting;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.Color;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.Gradient;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomColor;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomGradient;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.postprocessing.BloomEffect;
import com.lowdragmc.photon.core.mixins.accessor.BlendModeAccessor;
import com.lowdragmc.photon.core.mixins.accessor.ShaderInstanceAccessor;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Vector3f;

public class BeamConfig {
    @Configurable(tips={"photon.emitter.config.duration"})
    @NumberRange(range={1.0, 2.147483647E9})
    protected int duration = 100;
    @Configurable(tips={"photon.emitter.config.looping"})
    protected boolean looping = true;
    @Configurable(tips={"photon.emitter.config.startDelay"})
    @NumberRange(range={0.0, 2.147483647E9})
    protected int startDelay = 0;
    @Configurable(tips={"photon.emitter.beam.config.end"})
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38})
    protected Vector3f end = new Vector3f(3.0f, 0.0f, 0.0f);
    @Configurable(tips={"photon.emitter.beam.config.width"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, curveConfig=@CurveConfig(bound={0.0f, 1.0f}, xAxis="duration", yAxis="width"))
    protected NumberFunction width = NumberFunction.constant(0.2);
    @Configurable(tips={"photon.emitter.beam.config.emitRate"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, curveConfig=@CurveConfig(bound={0.0f, 1.0f}, xAxis="duration", yAxis="width"))
    protected NumberFunction emitRate = NumberFunction.constant(0);
    @Configurable(tips={"photon.emitter.beam.config.color"})
    @NumberFunctionConfig(types={Color.class, RandomColor.class, Gradient.class, RandomGradient.class}, defaultValue=-1.0f)
    protected NumberFunction color = new Color();
    @Configurable(name="Material", subConfigurable=true, tips={"photon.emitter.config.material"})
    public final MaterialSetting material = new MaterialSetting();
    @Configurable(name="Renderer", subConfigurable=true, tips={"photon.emitter.config.renderer"})
    public final RendererSetting renderer = new RendererSetting();
    @Configurable(name="UV Animation", subConfigurable=true, tips={"photon.emitter.config.uvAnimation"})
    public final UVAnimationSetting uvAnimation = new UVAnimationSetting();
    @Configurable(name="Fixed Light", subConfigurable=true, tips={"photon.emitter.config.lights"})
    public final LightOverLifetimeSetting lights = new LightOverLifetimeSetting();
    public final PhotonParticleRenderType particleRenderType = new RenderType();

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public Vector3f getEnd() {
        return this.end;
    }

    public void setWidth(NumberFunction width) {
        this.width = width;
    }

    public NumberFunction getWidth() {
        return this.width;
    }

    public void setEmitRate(NumberFunction emitRate) {
        this.emitRate = emitRate;
    }

    public NumberFunction getEmitRate() {
        return this.emitRate;
    }

    public void setColor(NumberFunction color) {
        this.color = color;
    }

    public NumberFunction getColor() {
        return this.color;
    }

    public MaterialSetting getMaterial() {
        return this.material;
    }

    public RendererSetting getRenderer() {
        return this.renderer;
    }

    public LightOverLifetimeSetting getLights() {
        return this.lights;
    }

    private class RenderType
    extends PhotonParticleRenderType {
        private BlendMode lastBlend = null;

        private RenderType() {
        }

        @Override
        public void prepareStatus() {
            if (BeamConfig.this.renderer.isBloomEffect()) {
                this.beginBloom();
                BloomEffect.setBloomColor(BeamConfig.this.renderer.getBloomColor());
            } else {
                RenderSystem.setShader(GameRenderer::m_172829_);
            }
            BeamConfig.this.material.pre();
            BeamConfig.this.material.getMaterial().begin(false);
            ShaderInstance shaderInstance = RenderSystem.getShader();
            if (shaderInstance instanceof ShaderInstanceAccessor) {
                ShaderInstanceAccessor shader = (ShaderInstanceAccessor)shaderInstance;
                this.lastBlend = BlendModeAccessor.getLastApplied();
                BlendModeAccessor.setLastApplied(shader.getBlend());
            }
            RenderTarget input = BloomEffect.getInput();
            input.m_83947_(false);
            Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        }

        @Override
        public void begin(@Nonnull BufferBuilder bufferBuilder) {
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        @Override
        public void releaseStatus() {
            BeamConfig.this.material.getMaterial().end(false);
            BeamConfig.this.material.post();
            if (this.lastBlend != null) {
                this.lastBlend.m_85526_();
                this.lastBlend = null;
            }
            this.endParticle();
        }
    }
}

