/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter;

import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.utils.PositionedRect;
import com.lowdragmc.photon.IrisFramebufferUtils;
import com.lowdragmc.photon.Photon;
import com.lowdragmc.photon.client.gameobject.emitter.data.RendererSetting;
import com.lowdragmc.photon.client.postprocessing.BloomEffect;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL20;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public abstract class PhotonParticleRenderType
implements ParticleRenderType {
    @Nullable
    private static Frustum FRUSTUM;
    private static RendererSetting.Layer LAYER;
    public static boolean bloomMark;

    public static void renderBloom() {
        if (bloomMark) {
            PositionedRect lastViewport = new PositionedRect(GlStateManager.Viewport.m_157126_(), GlStateManager.Viewport.m_157127_(), GlStateManager.Viewport.m_157128_(), GlStateManager.Viewport.m_157129_());
            RenderTarget input = BloomEffect.getInput();
            RenderTarget output = BloomEffect.getOutput();
            RenderTarget background = Minecraft.m_91087_().m_91385_();
            if (lastViewport.position.x != 0 || lastViewport.position.y != 0 || lastViewport.size.width != background.f_83915_ || lastViewport.size.height != background.f_83916_) {
                RenderSystem.viewport((int)0, (int)0, (int)background.f_83915_, (int)background.f_83916_);
            }
            BloomEffect.renderBloom(background.f_83915_, background.f_83916_, LAYER == RendererSetting.Layer.Opaque ? Photon.getSolidTextureID() : Photon.getTranslucentTextureID(true), input.m_83975_(), output);
            input.m_83947_(false);
            GL20.glDrawBuffers((int[])new int[]{36065});
            GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            int i = 16384;
            GlStateManager._clear((int)i, (boolean)Minecraft.f_91002_);
            GL20.glDrawBuffers((int[])new int[]{36064, 36065});
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager._disableDepthTest();
            GlStateManager._depthMask((boolean)false);
            GlStateManager._glBindFramebuffer((int)36160, (int)(LAYER == RendererSetting.Layer.Opaque ? Photon.getSolidFrameBufferID() : Photon.getTranslucentFrameBufferID()));
            Shaders.getBlitShader().m_173350_("DiffuseSampler", (Object)output.m_83975_());
            Shaders.getBlitShader().m_173363_();
            GlStateManager._enableBlend();
            RenderSystem.defaultBlendFunc();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
            bufferbuilder.m_5483_(-1.0, 1.0, 0.0).m_5752_();
            bufferbuilder.m_5483_(-1.0, -1.0, 0.0).m_5752_();
            bufferbuilder.m_5483_(1.0, -1.0, 0.0).m_5752_();
            bufferbuilder.m_5483_(1.0, 1.0, 0.0).m_5752_();
            BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            Shaders.getBlitShader().m_173362_();
            GlStateManager._depthMask((boolean)true);
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager._enableDepthTest();
            if (lastViewport.position.x != 0 || lastViewport.position.y != 0 || lastViewport.size.width != background.f_83915_ || lastViewport.size.height != background.f_83916_) {
                RenderSystem.viewport((int)lastViewport.position.x, (int)lastViewport.position.y, (int)lastViewport.size.width, (int)lastViewport.size.height);
            }
            bloomMark = false;
        }
    }

    public static void prepareForParticleRendering(@Nullable Frustum cullingFrustum) {
        FRUSTUM = cullingFrustum;
        LAYER = RendererSetting.Layer.Opaque;
    }

    public static void finishRender() {
        if (LAYER == RendererSetting.Layer.Opaque || IrisFramebufferUtils.isRenderingGUIScreen()) {
            PhotonParticleRenderType.renderBloom();
        }
        if (LAYER == RendererSetting.Layer.Opaque) {
            LAYER = RendererSetting.Layer.Translucent;
        }
    }

    public void beginBloom() {
        BloomEffect.bindBloomShader();
        bloomMark = true;
    }

    public void endParticle() {
        BloomEffect.setBloomColor(new Vector4f(0.0f));
        RenderTarget background = Minecraft.m_91087_().m_91385_();
        background.m_83947_(false);
    }

    public boolean isParallel() {
        return false;
    }

    @Deprecated
    public final void m_6505_(BufferBuilder builder, TextureManager textureManager) {
        this.prepareStatus();
        this.begin(builder);
    }

    @Deprecated
    public final void m_6294_(Tesselator tesselator) {
        this.end(tesselator.m_85915_());
        this.releaseStatus();
    }

    public void prepareStatus() {
    }

    public void begin(BufferBuilder builder) {
    }

    public void end(BufferBuilder builder) {
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public void releaseStatus() {
    }

    public static boolean checkLayer(RendererSetting.Layer layer) {
        return LAYER == layer;
    }

    public static boolean checkFrustum(AABB aabb) {
        if (FRUSTUM == null) {
            return true;
        }
        return FRUSTUM.m_113029_(aabb);
    }

    public static Comparator<ParticleRenderType> makeParticleRenderTypeComparator(List<ParticleRenderType> renderOrder) {
        Comparator<ParticleRenderType> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((ParticleRenderType)typeOne, (ParticleRenderType)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            return vanillaOne ? -1 : 1;
        };
    }

    @Nullable
    public static Frustum getFRUSTUM() {
        return FRUSTUM;
    }

    public static RendererSetting.Layer getLAYER() {
        return LAYER;
    }

    static {
        LAYER = RendererSetting.Layer.Translucent;
        bloomMark = false;
    }
}

