/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.fx;

import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.IScene;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneObject;
import com.lowdragmc.photon.Photon;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXData;
import com.lowdragmc.photon.client.fx.IEffect;
import com.lowdragmc.photon.client.gameobject.EmptyFXObject;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class FXRuntime
implements IScene {
    public final FX fx;
    public final FXData fxData;
    public final Map<UUID, IFXObject> objects = new LinkedHashMap<UUID, IFXObject>();
    public final IFXObject root;
    private final boolean isCopy;

    public FXRuntime(FX fx, FXData fxData, boolean copy, boolean deepCopy) {
        this.fx = fx;
        this.fxData = fxData;
        this.isCopy = copy;
        this.root = new EmptyFXObject();
        this.addSceneObjectInternal(this.root);
        this.root.setName("root");
        for (IFXObject fxObject : fxData.objects()) {
            if (copy) {
                IFXObject copied = fxObject.copy(deepCopy);
                this.addSceneObjectInternal(copied);
                continue;
            }
            this.addSceneObjectInternal(fxObject);
        }
        this.awake();
        for (IFXObject fxObject : this.objects.values()) {
            if (fxObject == this.root || fxObject.transform().parent() != null) continue;
            fxObject.transform().parent(this.root.transform(), false);
        }
    }

    @Nullable
    public ISceneObject getSceneObject(UUID uuid) {
        return this.objects.getOrDefault(uuid, this.root);
    }

    public Collection<ISceneObject> getAllSceneObjects() {
        return this.objects.values().stream().map(ISceneObject.class::cast).toList();
    }

    public void addSceneObject(ISceneObject sceneObject) {
        super.addSceneObject(sceneObject);
        if (!this.isCopy && sceneObject instanceof IFXObject) {
            IFXObject fxObject = (IFXObject)sceneObject;
            this.fxData.objects().add(fxObject);
        }
    }

    public void removeSceneObject(ISceneObject sceneObject) {
        super.removeSceneObject(sceneObject);
        if (!this.isCopy && sceneObject instanceof IFXObject) {
            IFXObject fxObject = (IFXObject)sceneObject;
            this.fxData.objects().remove(fxObject);
        }
    }

    public void addSceneObjectInternal(ISceneObject sceneObject) {
        if (sceneObject instanceof IFXObject) {
            IFXObject fxObject = (IFXObject)sceneObject;
            fxObject.setScene(this);
            IFXObject previous = this.objects.put(fxObject.id(), fxObject);
            if (previous != null && previous != fxObject) {
                Photon.LOGGER.warn("Duplicate fx runtime object id %s is replaced".formatted(fxObject.id()));
            }
        } else {
            throw new IllegalArgumentException("%s is not an instance of IFXObject".formatted(sceneObject));
        }
    }

    public void removeSceneObjectInternal(ISceneObject sceneObject) {
        if (sceneObject instanceof IFXObject) {
            IFXObject fxObject = (IFXObject)sceneObject;
            this.objects.remove(fxObject.id());
            if (!this.isCopy) {
                this.fxData.objects().remove(fxObject);
            }
        } else {
            throw new IllegalArgumentException("%s is not an instance of IFXObject".formatted(sceneObject));
        }
    }

    public void emmit(IEffect effect) {
        for (IFXObject fxObject : this.objects.values()) {
            fxObject.reset();
            fxObject.emmit(effect);
        }
    }

    public boolean isAlive() {
        return this.objects.values().stream().anyMatch(IFXObject::m_107276_);
    }

    public void destroy(boolean force) {
        for (IFXObject fxObject : this.objects.values()) {
            fxObject.remove(force);
        }
    }

    @Nullable
    public IFXObject findObject(String name) {
        for (IFXObject fxObject : this.objects.values()) {
            if (!fxObject.getName().equals(name)) continue;
            return fxObject;
        }
        return null;
    }

    public List<IFXObject> findObjects(String name) {
        ArrayList<IFXObject> list = new ArrayList<IFXObject>();
        for (IFXObject fxObject : this.objects.values()) {
            if (!fxObject.getName().equals(name)) continue;
            list.add(fxObject);
        }
        return list;
    }

    public FX getFx() {
        return this.fx;
    }

    public FXData getFxData() {
        return this.fxData;
    }

    public Map<UUID, IFXObject> getObjects() {
        return this.objects;
    }

    public IFXObject getRoot() {
        return this.root;
    }

    public boolean isCopy() {
        return this.isCopy;
    }
}

