/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.fx;

import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.photon.client.fx.FXData;
import com.lowdragmc.photon.client.fx.FXRuntime;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class FX
implements ITagSerializable<CompoundTag> {
    @Nullable
    private ResourceLocation fxLocation;
    private final FXData mainFX;
    private final Map<String, FXData> subFXs = new LinkedHashMap<String, FXData>();

    public FX() {
        this.mainFX = new FXData();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("mainFX", (Tag)this.mainFX.serializeNBT());
        CompoundTag subFXs = new CompoundTag();
        for (Map.Entry<String, FXData> entry : this.subFXs.entrySet()) {
            subFXs.m_128365_(entry.getKey(), (Tag)entry.getValue().serializeNBT());
        }
        tag.m_128365_("subFXs", (Tag)subFXs);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.mainFX.deserializeNBT(tag.m_128469_("mainFX"));
        this.subFXs.clear();
        CompoundTag subFXs = tag.m_128469_("subFXs");
        for (String key : subFXs.m_128431_()) {
            FXData subFX = new FXData();
            subFX.deserializeNBT(subFXs.m_128469_(key));
            this.subFXs.put(key, subFX);
        }
    }

    public FXRuntime createRuntime() {
        return new FXRuntime(this, this.mainFX, true, false);
    }

    public FXRuntime createRuntime(boolean deepCopy) {
        return new FXRuntime(this, this.mainFX, true, deepCopy);
    }

    public FXRuntime createInternalRuntime() {
        return new FXRuntime(this, this.mainFX, false, false);
    }

    @Nullable
    public FXRuntime createSubFXRuntime(String name) {
        if (!this.subFXs.containsKey(name)) {
            return null;
        }
        return new FXRuntime(this, this.subFXs.get(name), true, false);
    }

    @Nullable
    public ResourceLocation getFxLocation() {
        return this.fxLocation;
    }

    public FXData getMainFX() {
        return this.mainFX;
    }

    public Map<String, FXData> getSubFXs() {
        return this.subFXs;
    }

    public void setFxLocation(@Nullable ResourceLocation fxLocation) {
        this.fxLocation = fxLocation;
    }
}

