/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.fx;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXEffect;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class EntityEffect
extends FXEffect {
    public static Map<Entity, List<EntityEffect>> CACHE = new HashMap<Entity, List<EntityEffect>>();
    public final Entity entity;
    public final AutoRotate autoRotate;

    public EntityEffect(FX fx, Level level, Entity entity, AutoRotate autoRotate) {
        super(fx, level);
        this.entity = entity;
        this.autoRotate = autoRotate;
    }

    @Override
    public void updateFXObjectTick(IFXObject fxObject) {
        if (this.runtime != null && fxObject == this.runtime.root && !this.entity.m_6084_()) {
            this.runtime.destroy(this.forcedDeath);
            CACHE.computeIfAbsent(this.entity, p -> new ArrayList()).remove(this);
            if (CACHE.get(this.entity).isEmpty()) {
                CACHE.remove(this.entity);
            }
        }
    }

    @Override
    public void updateFXObjectFrame(IFXObject fxObject, float partialTicks) {
        if (this.runtime != null && fxObject == this.runtime.root) {
            Vec3 position = this.entity.m_20318_(partialTicks);
            this.runtime.root.updatePos(new Vector3f((float)(position.f_82479_ + (double)this.offset.x), (float)(position.f_82480_ + (double)this.offset.y), (float)(position.f_82481_ + (double)this.offset.z)));
            if (this.autoRotate != AutoRotate.NONE) {
                switch (this.autoRotate) {
                    case FORWARD: {
                        Vec3 forward = this.entity.m_20156_();
                        Quaternionf newRotation = new Quaternionf((Quaternionfc)this.rotation).rotateXYZ(0.0f, (float)Math.atan2((double)(-forward.f_82481_), (double)forward.f_82479_), (float)forward.f_82480_);
                        this.runtime.root.updateRotation(newRotation);
                        break;
                    }
                    case LOOK: {
                        Vec3 lookAngles = this.entity.m_20154_();
                        Quaternionf newRotation = new Quaternionf((Quaternionfc)this.rotation).rotateXYZ(0.0f, (float)Math.atan2((double)(-lookAngles.f_82481_), (double)lookAngles.f_82479_), (float)lookAngles.f_82480_);
                        this.runtime.root.updateRotation(newRotation);
                        break;
                    }
                    case XROT: {
                        Quaternionf newRotation = new Quaternionf((Quaternionfc)this.rotation).rotateXYZ(0.0f, Math.toRadians((float)(-90.0f - this.entity.m_213816_())), 0.0f);
                        this.runtime.root.updateRotation(newRotation);
                    }
                }
            }
        }
    }

    @Override
    public void start() {
        if (!this.entity.m_6084_()) {
            return;
        }
        List effects = CACHE.computeIfAbsent(this.entity, p -> new ArrayList());
        if (!this.allowMulti) {
            Iterator iter = effects.iterator();
            while (iter.hasNext()) {
                EntityEffect effect = (EntityEffect)iter.next();
                boolean removed = false;
                if (effect.runtime != null && !effect.runtime.isAlive()) {
                    iter.remove();
                    removed = true;
                }
                if (!effect.fx.equals(this.fx) && !Objects.equals(effect.fx.getFxLocation(), this.fx.getFxLocation()) || removed) continue;
                return;
            }
        }
        this.runtime = this.fx.createRuntime();
        IFXObject root = this.runtime.getRoot();
        root.updatePos(this.entity.m_20318_(0.0f).m_252839_().add(this.offset.x, this.offset.y, this.offset.z));
        root.updateRotation(this.rotation);
        root.updateScale(this.scale);
        this.runtime.emmit(this);
        effects.add(this);
    }

    public static enum AutoRotate {
        NONE,
        FORWARD,
        LOOK,
        XROT;

    }
}

