/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.photon.IrisFramebufferUtils;
import com.lowdragmc.photon.forge.PhotonImpl;
import com.mojang.blaze3d.pipeline.RenderTarget;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Photon {
    public static final String MOD_ID = "photon";
    public static final String NAME = "Photon";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Photon");

    public static void init() {
        LOGGER.info("{} is initializing on platform: {}", (Object)NAME, (Object)Platform.platformName());
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isStencilEnabled(RenderTarget target) {
        return PhotonImpl.isStencilEnabled(target);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean useCombinedDepthStencilAttachment() {
        return PhotonImpl.useCombinedDepthStencilAttachment();
    }

    public static boolean isShaderModInstalled() {
        return LDLib.isModLoaded((String)"iris") || LDLib.isModLoaded((String)"oculus");
    }

    public static boolean isUsingShaderPack() {
        return Photon.isShaderModInstalled() && IrisFramebufferUtils.isUsingShaderPack();
    }

    public static int getSolidFrameBufferID() {
        if (Photon.isUsingShaderPack()) {
            return IrisFramebufferUtils.getIrisSolidFboId();
        }
        return Minecraft.m_91087_().m_91385_().f_83920_;
    }

    public static int getTranslucentFrameBufferID() {
        if (Photon.isUsingShaderPack()) {
            return IrisFramebufferUtils.getIrisTranslucentFboId();
        }
        return Minecraft.m_91087_().m_91385_().f_83920_;
    }

    public static int getDepthTextureID() {
        if (Photon.isUsingShaderPack()) {
            return IrisFramebufferUtils.getIrisDepthTextureId();
        }
        return Minecraft.m_91087_().m_91385_().m_83980_();
    }

    public static int getSolidTextureID() {
        if (Photon.isUsingShaderPack()) {
            return IrisFramebufferUtils.getIrisSolidTextureId();
        }
        return Minecraft.m_91087_().m_91385_().m_83975_();
    }

    public static int getTranslucentTextureID(boolean writeBuffer) {
        if (Photon.isUsingShaderPack()) {
            return IrisFramebufferUtils.getIrisTranslucentTextureId(writeBuffer);
        }
        return Minecraft.m_91087_().m_91385_().m_83975_();
    }
}

