/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon;

import com.lowdragmc.lowdraglib.LDLib;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.SodiumTerrainPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.properties.ParticleRenderingSettings;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL30C;

public class IrisFramebufferUtils {
    private static boolean renderingGUIScreen = false;
    private static WorldRenderingPipeline lastPipeline = null;
    private static Field cachedField = null;
    private static int cachedSolidFramebufferId = -1;
    private static int cachedTranslucentFramebufferId = -1;
    private static int cachedDepthTextureId = -1;
    private static int cachedSolidTextureId = -1;
    private static int cachedTranslucentTextureId = -1;
    private static boolean depthTextureRefreshed = false;
    private static boolean solidTextureRefreshed = false;
    private static boolean translucentTextureRefreshed = false;

    public static int getIrisSolidFboId() {
        return IrisFramebufferUtils.getFramebufferID(true);
    }

    public static int getIrisTranslucentFboId() {
        return IrisFramebufferUtils.getFramebufferID(false);
    }

    private static int getFramebufferID(boolean solid) {
        int cached;
        if (renderingGUIScreen) {
            return Minecraft.m_91087_().m_91385_().f_83920_;
        }
        Optional optional = Iris.getPipelineManager().getPipeline();
        if (optional.isEmpty()) {
            return Minecraft.m_91087_().m_91385_().f_83920_;
        }
        WorldRenderingPipeline pipeline = (WorldRenderingPipeline)optional.get();
        if (pipeline != lastPipeline) {
            lastPipeline = pipeline;
            cachedField = null;
            cachedTranslucentFramebufferId = -1;
            cachedSolidFramebufferId = -1;
            translucentTextureRefreshed = false;
            solidTextureRefreshed = false;
            depthTextureRefreshed = false;
        }
        int n = cached = solid ? cachedSolidFramebufferId : cachedTranslucentFramebufferId;
        if (cached != -1) {
            return cached;
        }
        try {
            if (pipeline instanceof IrisRenderingPipeline) {
                if (cachedField == null) {
                    cachedField = IrisRenderingPipeline.class.getDeclaredField("sodiumTerrainPipeline");
                    cachedField.setAccessible(true);
                }
                SodiumTerrainPipeline stp = (SodiumTerrainPipeline)cachedField.get(pipeline);
                GlFramebuffer solidBuffer = stp.getTerrainSolidFramebuffer();
                GlFramebuffer translucentBuffer = stp.getTranslucentFramebuffer();
                cachedSolidFramebufferId = solidBuffer.getId();
                cachedTranslucentFramebufferId = translucentBuffer.getId();
                return solid ? cachedSolidFramebufferId : cachedTranslucentFramebufferId;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Minecraft.m_91087_().m_91385_().f_83920_;
    }

    public static int getIrisDepthTextureId() {
        return IrisFramebufferUtils.getTextureIdFromFramebuffer(IrisFramebufferUtils.getIrisSolidFboId(), 36096, () -> cachedDepthTextureId, id -> {
            cachedDepthTextureId = id;
        }, () -> depthTextureRefreshed, refreshed -> {
            depthTextureRefreshed = refreshed;
        }, () -> cachedSolidFramebufferId);
    }

    public static int getIrisSolidTextureId() {
        return IrisFramebufferUtils.getTextureIdFromFramebuffer(IrisFramebufferUtils.getIrisSolidFboId(), 36064, () -> cachedSolidTextureId, id -> {
            cachedSolidTextureId = id;
        }, () -> solidTextureRefreshed, refreshed -> {
            solidTextureRefreshed = refreshed;
        }, () -> cachedSolidFramebufferId);
    }

    public static int getIrisTranslucentTextureId(boolean writeBuffer) {
        if (!writeBuffer && IrisFramebufferUtils.beforeEntitiesRendering()) {
            return IrisFramebufferUtils.getIrisSolidTextureId();
        }
        return IrisFramebufferUtils.getTextureIdFromFramebuffer(IrisFramebufferUtils.getIrisTranslucentFboId(), 36064, () -> cachedTranslucentTextureId, id -> {
            cachedTranslucentTextureId = id;
        }, () -> translucentTextureRefreshed, refreshed -> {
            translucentTextureRefreshed = refreshed;
        }, () -> cachedTranslucentFramebufferId);
    }

    private static int getTextureIdFromFramebuffer(int framebufferId, int attachment, IntSupplier cacheGetter, Consumer<Integer> cacheSetter, BooleanSupplier refreshedGetter, Consumer<Boolean> refreshedSetter, IntSupplier cachedFramebufferGetter) {
        if (renderingGUIScreen) {
            return attachment == 36096 ? Minecraft.m_91087_().m_91385_().m_83980_() : Minecraft.m_91087_().m_91385_().m_83975_();
        }
        if (cachedFramebufferGetter.getAsInt() != framebufferId || !refreshedGetter.getAsBoolean()) {
            refreshedSetter.accept(true);
            cacheSetter.accept(attachment == 36096 ? Minecraft.m_91087_().m_91385_().m_83980_() : Minecraft.m_91087_().m_91385_().m_83975_());
            RenderSystem.assertOnRenderThreadOrInit();
            GlStateManager._glBindFramebuffer((int)36160, (int)framebufferId);
            int[] type = new int[1];
            GL30C.glGetFramebufferAttachmentParameteriv((int)36160, (int)attachment, (int)36048, (int[])type);
            if (type[0] == 5890) {
                int[] id = new int[1];
                GL30C.glGetFramebufferAttachmentParameteriv((int)36160, (int)attachment, (int)36049, (int[])id);
                cacheSetter.accept(id[0]);
            }
        }
        return cacheGetter.getAsInt();
    }

    public static Field getFboCachedField() {
        if (IrisFramebufferUtils.isUsingShaderPack()) {
            IrisFramebufferUtils.getIrisSolidFboId();
            IrisFramebufferUtils.getIrisTranslucentFboId();
        }
        return cachedField;
    }

    public static boolean isUsingShaderPack() {
        return (LDLib.isModLoaded((String)"iris") || LDLib.isModLoaded((String)"oculus")) && IrisApi.getInstance().isShaderPackInUse();
    }

    public static boolean isRenderingGUIScreen() {
        return renderingGUIScreen;
    }

    public static void setRenderingGUIScreen(boolean renderingGUIScreen) {
        IrisFramebufferUtils.renderingGUIScreen = renderingGUIScreen;
    }

    private static boolean beforeEntitiesRendering() {
        return Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::getParticleRenderingSettings).orElse(ParticleRenderingSettings.MIXED) == ParticleRenderingSettings.BEFORE;
    }
}

