/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.utils;

import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;
import site.siredvin.peripheralium.xplat.XplatRegistries;
import site.siredvin.peripheralworks.utils.SensorCollection;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lsite/siredvin/peripheralworks/utils/SensorCollection;", "", "()V", "MAX_Y", "", "MIN_Y", "VANILLA_SLIME_CHUNK_SALT", "", "analyzeDimensions", "Ldan200/computercraft/api/lua/MethodResult;", "owner", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "decodeMoonPhase", "", "level", "Lnet/minecraft/world/level/Level;", "inspectBiome", "inspectCalendar", "inspectChunk", "inspectDimension", "inspectLight", "inspectOrientationAngle", "inspectTime", "inspectWeather", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nSensorCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SensorCollection.kt\nsite/siredvin/peripheralworks/utils/SensorCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1549#2:122\n1620#2,3:123\n*S KotlinDebug\n*F\n+ 1 SensorCollection.kt\nsite/siredvin/peripheralworks/utils/SensorCollection\n*L\n29#1:122\n29#1:123,3\n*E\n"})
public final class SensorCollection {
    @NotNull
    public static final SensorCollection INSTANCE = new SensorCollection();
    public static final int MIN_Y = -64;
    public static final int MAX_Y = 320;
    public static final long VANILLA_SLIME_CHUNK_SALT = 987234911L;

    private SensorCollection() {
    }

    @NotNull
    public final MethodResult inspectDimension(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        if (level == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Something isn't loaded correctly\")");
            return methodResult;
        }
        Level level2 = level;
        MethodResult methodResult = MethodResult.of((Object)level2.m_46472_().m_135782_().toString());
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(level.dimension().location().toString())");
        return methodResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MethodResult analyzeDimensions(@NotNull IPeripheralOwner owner) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Something isn't loaded correctly\")");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        MinecraftServer minecraftServer = level2.m_7654_();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"level.server");
        MinecraftServer server = minecraftServer;
        Iterable iterable = server.m_129785_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"server.allLevels");
        Iterable $this$map$iv = iterable;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServerLevel serverLevel2 = (ServerLevel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.m_46472_().m_135782_().toString());
        }
        MethodResult methodResult = MethodResult.of((Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(server.allLevels.map \u2026.location().toString() })");
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectBiome(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Something isn't loaded correctly\")");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        MethodResult methodResult = MethodResult.of((Object)level2.m_204166_(owner.getPos()).m_203543_().map(arg_0 -> SensorCollection.inspectBiome$lambda$1(inspectBiome.1.INSTANCE, arg_0)).orElse("unknown"));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(level.getBiome(owner.\u2026ng() }.orElse(\"unknown\"))");
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectWeather(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Something isn't loaded correctly\")");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        if (level2.m_46470_()) {
            MethodResult methodResult = MethodResult.of((Object)"thunder");
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(\"thunder\")");
            return methodResult;
        }
        if (level2.m_46471_()) {
            MethodResult methodResult = MethodResult.of((Object)"rain");
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(\"rain\")");
            return methodResult;
        }
        MethodResult methodResult = MethodResult.of((Object)"stable");
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(\"stable\")");
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectOrientationAngle(@NotNull IPeripheralOwner owner) {
        MethodResult methodResult;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        switch (WhenMappings.$EnumSwitchMapping$0[owner.getFacing().ordinal()]) {
            case 1: {
                MethodResult methodResult2 = MethodResult.of((Object)0);
                methodResult = methodResult2;
                Intrinsics.checkNotNullExpressionValue((Object)methodResult2, (String)"of(0)");
                break;
            }
            case 2: {
                MethodResult methodResult3 = MethodResult.of((Object)180);
                methodResult = methodResult3;
                Intrinsics.checkNotNullExpressionValue((Object)methodResult3, (String)"of(180)");
                break;
            }
            case 3: {
                MethodResult methodResult4 = MethodResult.of((Object)270);
                methodResult = methodResult4;
                Intrinsics.checkNotNullExpressionValue((Object)methodResult4, (String)"of(270)");
                break;
            }
            case 4: {
                MethodResult methodResult5 = MethodResult.of((Object)90);
                methodResult = methodResult5;
                Intrinsics.checkNotNullExpressionValue((Object)methodResult5, (String)"of(90)");
                break;
            }
            default: {
                Object[] objectArray = new Object[]{null, "Cannot determinate angle to north pole"};
                MethodResult methodResult6 = MethodResult.of((Object[])objectArray);
                methodResult = methodResult6;
                Intrinsics.checkNotNullExpressionValue((Object)methodResult6, (String)"of(null, \"Cannot determinate angle to north pole\")");
            }
        }
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectTime(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Something isn't loaded correctly\")");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        MethodResult methodResult = MethodResult.of((Object)level2.m_46468_());
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(level.dayTime)");
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectLight(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Pair[] pairArray = owner.getLevel();
        ServerLevel serverLevel = pairArray instanceof ServerLevel ? (ServerLevel)pairArray : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Something isn't loaded correctly\")");
            return methodResult;
        }
        ServerLevel level = serverLevel;
        pairArray = new Pair[]{TuplesKt.to((Object)"light", (Object)level.m_45517_(LightLayer.BLOCK, owner.getPos().m_7494_())), TuplesKt.to((Object)"sunlight", (Object)level.m_45517_(LightLayer.SKY, owner.getPos().m_7494_()))};
        MethodResult methodResult = MethodResult.of((Object)MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(\n            mapOf(\n \u2026\n            ),\n        )");
        return methodResult;
    }

    private final String decodeMoonPhase(Level level) {
        return switch (level.m_46941_()) {
            case 0 -> "Full moon";
            case 1 -> "Waning gibbous";
            case 2 -> "Third quarter";
            case 3 -> "Waning crescent";
            case 4 -> "New moon";
            case 5 -> "Waxing crescent";
            case 6 -> "First quarter";
            case 7 -> "Waxing gibbous";
            default -> "Unknown moon phase";
        };
    }

    @NotNull
    public final MethodResult inspectCalendar(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Something isn't loaded correctly\")");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        Map inspectionData = new LinkedHashMap();
        inspectionData.put("day", level2.m_46468_() / 24000L % Integer.MAX_VALUE);
        if (Intrinsics.areEqual((Object)level2.m_46472_(), (Object)Level.f_46428_)) {
            inspectionData.put("moonPhase", this.decodeMoonPhase((Level)level2));
        }
        MethodResult methodResult = MethodResult.of((Object)inspectionData);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(inspectionData)");
        return methodResult;
    }

    @NotNull
    public final MethodResult inspectChunk(@NotNull IPeripheralOwner owner) {
        int n;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Level level = owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            Object[] objectArray = new Object[]{null, "Something isn't loaded correctly"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Something isn't loaded correctly\")");
            return methodResult;
        }
        ServerLevel level2 = serverLevel;
        Map information = new LinkedHashMap();
        Map ores = new LinkedHashMap();
        ChunkPos chunkPos = new ChunkPos(owner.getPos());
        int x = chunkPos.m_45604_();
        if (x <= (n = chunkPos.m_45608_())) {
            while (true) {
                int n2;
                int z;
                if ((z = chunkPos.m_45605_()) <= (n2 = chunkPos.m_45609_())) {
                    while (true) {
                        for (int y = -64; y < 321; ++y) {
                            String key;
                            BlockState blockState = level2.m_8055_(new BlockPos(x, y, z));
                            if (blockState.m_60795_()) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"blockState");
                            if (!PeripheraliumPlatform.Companion.isOre(blockState)) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)XplatRegistries.INSTANCE.getBLOCKS().getKey((Object)blockState.m_60734_()).toString(), (String)"XplatRegistries.BLOCKS.g\u2026ckState.block).toString()");
                            if (!ores.containsKey(key)) {
                                ores.put(key, 0);
                            }
                            Object v = ores.get(key);
                            Intrinsics.checkNotNull(v);
                            ores.put(key, ((Number)v).intValue() + 1);
                        }
                        if (z == n2) break;
                        ++z;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        information.put("oresDistribution", ores);
        information.put("isSlime", WorldgenRandom.m_224681_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (long)level2.m_7328_(), (long)987234911L).m_188503_(10) == 0);
        MethodResult methodResult = MethodResult.of((Object)information);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(information)");
        return methodResult;
    }

    private static final String inspectBiome$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

