/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.ContainerWrapper;
import site.siredvin.peripheralium.storages.MergedContainer;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lsite/siredvin/peripheralworks/utils/MinecartUtils;", "", "()V", "SEARCH_MARGIN", "", "getContainerMinecarts", "", "Lnet/minecraft/world/entity/vehicle/AbstractMinecartContainer;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "getMinecarts", "Lnet/minecraft/world/entity/vehicle/AbstractMinecart;", "getSearchShape", "Lnet/minecraft/world/phys/AABB;", "minecartExtractor", "Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "obj", "peripheralworks-forge-1.20.1"})
public final class MinecartUtils {
    @NotNull
    public static final MinecartUtils INSTANCE = new MinecartUtils();
    private static final double SEARCH_MARGIN = 0.2;

    private MinecartUtils() {
    }

    @NotNull
    public final AABB getSearchShape(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return new AABB((double)pos.m_123341_() + 0.2, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.2, (double)(pos.m_123341_() + 1) - 0.2, (double)(pos.m_123342_() + 1) - 0.2, (double)(pos.m_123343_() + 1) - 0.2);
    }

    @NotNull
    public final List<AbstractMinecart> getMinecarts(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List list = level.m_45976_(AbstractMinecart.class, this.getSearchShape(pos));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"level.getEntitiesOfClass\u2026ava, getSearchShape(pos))");
        return list;
    }

    @NotNull
    public final List<AbstractMinecartContainer> getContainerMinecarts(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List list = level.m_45976_(AbstractMinecartContainer.class, this.getSearchShape(pos));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"level.getEntitiesOfClass\u2026ava, getSearchShape(pos))");
        return list;
    }

    @Nullable
    public final SlottedItemStorage minecartExtractor(@NotNull Level level, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!(obj instanceof BlockPos)) {
            return null;
        }
        BlockState state = level.m_8055_((BlockPos)obj);
        if (!state.m_60713_(Blocks.f_50030_)) {
            return null;
        }
        List<AbstractMinecartContainer> containers = this.getContainerMinecarts(level, (BlockPos)obj);
        if (containers.isEmpty()) {
            return null;
        }
        return (SlottedItemStorage)new ContainerWrapper((Container)new MergedContainer(containers));
    }
}

