/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.occultism;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u001e\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lsite/siredvin/peripheralworks/integrations/occultism/OccultismItemStorage;", "Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "storageController", "Lcom/klikli_dev/occultism/api/common/blockentity/IStorageController;", "(Lcom/klikli_dev/occultism/api/common/blockentity/IStorageController;)V", "getItems", "", "Lnet/minecraft/world/item/ItemStack;", "setChanged", "", "storeItem", "stack", "takeItems", "predicate", "Ljava/util/function/Predicate;", "limit", "", "peripheralworks-forge-1.20.1"})
public final class OccultismItemStorage
implements ItemStorage {
    @NotNull
    private final IStorageController storageController;

    public OccultismItemStorage(@NotNull IStorageController storageController) {
        Intrinsics.checkNotNullParameter((Object)storageController, (String)"storageController");
        this.storageController = storageController;
    }

    @NotNull
    public Iterator<ItemStack> getItems() {
        return this.storageController.getStacks().iterator();
    }

    public void setChanged() {
        this.storageController.onContentsChanged();
    }

    @NotNull
    public ItemStack storeItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int returnedAmount = this.storageController.insertStack(stack, false);
        ItemStack itemStack = stack.m_255036_(returnedAmount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"stack.copyWithCount(returnedAmount)");
        return itemStack;
    }

    @NotNull
    public ItemStack takeItems(@NotNull Predicate<ItemStack> predicate, int limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        ItemStack itemStack = this.storageController.getItemStack(predicate, limit, false);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"storageController.getIte\u2026(predicate, limit, false)");
        return itemStack;
    }

    @Nullable
    public String getMovableType() {
        return ItemStorage.DefaultImpls.getMovableType((ItemStorage)this);
    }

    public int moveFrom(@NotNull ItemStorage from, int limit, int fromSlot, @NotNull Predicate<ItemStack> takePredicate) {
        return ItemStorage.DefaultImpls.moveFrom((ItemStorage)this, (ItemStorage)from, (int)limit, (int)fromSlot, takePredicate);
    }

    public int moveTo(@NotNull ItemSink to, int limit, int toSlot, @NotNull Predicate<ItemStack> takePredicate) {
        return ItemStorage.DefaultImpls.moveTo((ItemStorage)this, (ItemSink)to, (int)limit, (int)toSlot, takePredicate);
    }
}

