/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.easy_villagers;

import dan200.computercraft.api.lua.LuaFunction;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.util.representation.EnrichersKt;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lsite/siredvin/peripheralworks/integrations/easy_villagers/TraderPlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "trader", "Lde/maxhenkel/easyvillagers/blocks/tileentity/TraderTileentityBase;", "(Lde/maxhenkel/easyvillagers/blocks/tileentity/TraderTileentityBase;)V", "additionalType", "", "getAdditionalType", "()Ljava/lang/String;", "hasVillager", "", "inspect", "", "", "peripheralworks-forge-1.20.1"})
public class TraderPlugin
implements IPeripheralPlugin {
    @NotNull
    private final TraderTileentityBase trader;

    public TraderPlugin(@NotNull TraderTileentityBase trader) {
        Intrinsics.checkNotNullParameter((Object)trader, (String)"trader");
        this.trader = trader;
    }

    @NotNull
    public String getAdditionalType() {
        return "easy_trader";
    }

    @LuaFunction(mainThread=true)
    public final boolean hasVillager() {
        return this.trader.hasVillager();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, Object> inspect() {
        if (!this.trader.hasVillager()) {
            return null;
        }
        EasyVillagerEntity villager = this.trader.getVillagerEntity();
        Intrinsics.checkNotNullExpressionValue((Object)villager, (String)"villager");
        Map base = LuaRepresentation.INSTANCE.forEntity((Entity)villager);
        EnrichersKt.getMerchantData().accept(villager, base);
        EnrichersKt.getVillagerData().accept(villager, base);
        return base;
    }

    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral((IPeripheralPlugin)this);
    }

    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral((IPeripheralPlugin)this, (IPluggablePeripheral)value);
    }

    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations((IPeripheralPlugin)this);
    }

    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods((IPeripheralPlugin)this, (MinecraftServer)server);
    }
}

