/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.ae2;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.pathing.IPathingService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.grid.AENetworkBlockEntity;
import com.google.common.collect.ImmutableSet;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;
import site.siredvin.peripheralium.xplat.RegistryWrapper;
import site.siredvin.peripheralium.xplat.XplatRegistries;
import site.siredvin.peripheralworks.api.PeripheralPluginProvider;
import site.siredvin.peripheralworks.integrations.ae2.AE2Helper;
import site.siredvin.peripheralworks.integrations.ae2.Configuration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\b\u0010\f\u001a\u00020\nH\u0007J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0007J\u0018\u0010\u0011\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000f\u0012\u0002\b\u00030\u000e0\u0012H\u0007J\u0018\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000f\u0012\u0002\b\u00030\u000e0\u0012H\u0007J\u0018\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000f\u0012\u0002\b\u00030\u000e0\u0012H\u0007J(\u0010\u0015\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000f\u0012\u0002\b\u00030\u000e0\u00122\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0007J4\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "(Lnet/minecraft/world/level/Level;Lappeng/blockentity/grid/AENetworkBlockEntity;)V", "getActiveCraftings", "Ldan200/computercraft/api/lua/MethodResult;", "getAverageEnergyDemand", "", "getAverageEnergyIncome", "getChannelEnergyDemand", "getChannelInformation", "", "", "", "getCraftableFluids", "", "getCraftableItems", "getCraftingCPUs", "getPatternsFor", "mode", "id_key", "scheduleCrafting", "amount", "Ljava/util/Optional;", "", "targetCPU", "Companion", "Provider", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nMENetworkBlockPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MENetworkBlockPlugin.kt\nsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,209:1\n1855#2,2:210\n1855#2,2:212\n1855#2,2:214\n1855#2:216\n1856#2:223\n1855#2,2:224\n223#2,2:226\n13579#3,2:217\n13579#3:219\n13579#3,2:220\n13580#3:222\n*S KotlinDebug\n*F\n+ 1 MENetworkBlockPlugin.kt\nsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin\n*L\n77#1:210,2\n94#1:212,2\n104#1:214,2\n120#1:216\n120#1:223\n154#1:224,2\n196#1:226,2\n124#1:217,2\n125#1:219\n132#1:220,2\n125#1:222\n*E\n"})
public final class MENetworkBlockPlugin
implements IPeripheralPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Level level;
    @NotNull
    private final AENetworkBlockEntity entity;
    @NotNull
    public static final String PLUGIN_TYPE = "ae2";

    public MENetworkBlockPlugin(@NotNull Level level, @NotNull AENetworkBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.level = level;
        this.entity = entity;
    }

    @LuaFunction(mainThread=true)
    public final double getAverageEnergyDemand() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getEnergyService() : null;
        if (object == null) {
            return 0.0;
        }
        IEnergyService energyService = object;
        return energyService.getAvgPowerUsage();
    }

    @LuaFunction(mainThread=true)
    public final double getAverageEnergyIncome() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getEnergyService() : null;
        if (object == null) {
            return 0.0;
        }
        IEnergyService energyService = object;
        return energyService.getAvgPowerInjection();
    }

    @LuaFunction(mainThread=true)
    public final double getChannelEnergyDemand() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getEnergyService() : null;
        if (object == null) {
            return 0.0;
        }
        IEnergyService energyService = object;
        return energyService.getChannelPowerUsage();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<String, Object> getChannelInformation() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getPathingService() : null;
        if (object == null) {
            return MapsKt.emptyMap();
        }
        IPathingService pathingService = object;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"maxChannels", (Object)pathingService.getChannelMode().getAdHocNetworkChannels()), TuplesKt.to((Object)"usedChannels", (Object)pathingService.getUsedChannels())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getCraftingCPUs() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        ICraftingService craftingService = object;
        List data = new ArrayList();
        ImmutableSet immutableSet = craftingService.getCpus();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"craftingService.cpus");
        Iterable $this$forEach$iv = (Iterable)immutableSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICraftingCPU it = (ICraftingCPU)element$iv;
            boolean bl = false;
            Map cpuInformation = new LinkedHashMap();
            if (it.getName() != null) {
                String string;
                Map map = cpuInformation;
                String string2 = "name";
                Component component = it.getName();
                Intrinsics.checkNotNull((Object)component);
                Intrinsics.checkNotNullExpressionValue((Object)component.getString(), (String)"it.name!!.string");
                map.put(string2, string);
            }
            cpuInformation.put("capacity", 1 + it.getCoProcessors());
            cpuInformation.put("storage", it.getAvailableStorage());
            cpuInformation.put("isBusy", it.isBusy());
            data.add(cpuInformation);
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getCraftableItems() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        ICraftingService craftingService = object;
        List data = new ArrayList();
        Set set = craftingService.getCraftables(MENetworkBlockPlugin::getCraftableItems$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"craftingService.getCraftables { it is AEItemKey }");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AEKey it = (AEKey)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type appeng.api.stacks.AEItemKey");
            Item item = ((AEItemKey)it).getItem();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"it as AEItemKey).item");
            data.add(LuaRepresentation.INSTANCE.forItem(item));
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getCraftableFluids() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        ICraftingService craftingService = object;
        List data = new ArrayList();
        Set set = craftingService.getCraftables(MENetworkBlockPlugin::getCraftableFluids$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"craftingService.getCraftables { it is AEFluidKey }");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AEKey it = (AEKey)element$iv;
            boolean bl = false;
            RegistryWrapper registryWrapper = XplatRegistries.INSTANCE.getFLUIDS();
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type appeng.api.stacks.AEFluidKey");
            data.add(MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)registryWrapper.getKey((Object)((AEFluidKey)it).getFluid()).toString())));
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getPatternsFor(@NotNull String mode, @NotNull String id_key) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)id_key, (String)"id_key");
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        ICraftingService craftingService = object;
        AEKey key = AE2Helper.INSTANCE.buildKey(mode, id_key);
        Collection patterns = craftingService.getCraftingFor(key);
        List data = new ArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)patterns, (String)"patterns");
        Iterable $this$forEach$iv = patterns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GenericStack it;
            IPatternDetails pattern = (IPatternDetails)element$iv;
            boolean bl = false;
            Map patternRepresentation = new LinkedHashMap();
            List outputs = new ArrayList();
            List inputs = new ArrayList();
            GenericStack[] genericStackArray = pattern.getOutputs();
            Intrinsics.checkNotNullExpressionValue((Object)genericStackArray, (String)"pattern.outputs");
            Object[] $this$forEach$iv2 = genericStackArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (GenericStack)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                outputs.add(AE2Helper.INSTANCE.genericStackToMap(it));
            }
            IPatternDetails.IInput[] iInputArray = pattern.getInputs();
            Intrinsics.checkNotNullExpressionValue((Object)iInputArray, (String)"pattern.inputs");
            $this$forEach$iv2 = iInputArray;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (IPatternDetails.IInput)element$iv2;
                boolean bl3 = false;
                Map inputData = null;
                if (it.getPossibleInputs().length == 1) {
                    GenericStack genericStack = it.getPossibleInputs()[0];
                    Intrinsics.checkNotNullExpressionValue((Object)genericStack, (String)"it.possibleInputs[0]");
                    Map map = inputData = AE2Helper.INSTANCE.genericStackToMap(genericStack);
                    var25_25 = "count";
                    Object object2 = inputData.get("count");
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                    Long l = (long)((Integer)object2).intValue() * it.getMultiplier();
                    map.put((String)var25_25, (Object)l);
                } else {
                    List inputVariants = new ArrayList();
                    GenericStack[] genericStackArray2 = it.getPossibleInputs();
                    Intrinsics.checkNotNullExpressionValue((Object)genericStackArray2, (String)"it.possibleInputs");
                    Object[] $this$forEach$iv3 = genericStackArray2;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        Map<String, Object> pInputResult;
                        GenericStack pInput = (GenericStack)element$iv3;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)pInput, (String)"pInput");
                        Map<String, Object> map = pInputResult = AE2Helper.INSTANCE.genericStackToMap(pInput);
                        String string = "count";
                        Object object3 = pInputResult.get("count");
                        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
                        Long l = (long)((Integer)object3).intValue() * it.getMultiplier();
                        map.put(string, l);
                        inputVariants.add(pInputResult);
                    }
                    var25_25 = new Pair[]{TuplesKt.to((Object)"variants", (Object)inputVariants)};
                    inputData = MapsKt.mutableMapOf((Pair[])var25_25);
                }
                inputs.add(inputData);
            }
            patternRepresentation.put("inputs", inputs);
            patternRepresentation.put("outputs", outputs);
            data.add(patternRepresentation);
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getActiveCraftings() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            Object[] objectArray = new Object[]{null, "AE2 network is not connected"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"AE2 network is not connected\")");
            return methodResult;
        }
        ICraftingService craftingService = object;
        List craftingList = new ArrayList();
        ImmutableSet immutableSet = craftingService.getCpus();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"craftingService.cpus");
        Iterable $this$forEach$iv = (Iterable)immutableSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CraftingJobStatus jobStatus;
            ICraftingCPU it = (ICraftingCPU)element$iv;
            boolean bl = false;
            if (!it.isBusy() || it.getJobStatus() == null) continue;
            Intrinsics.checkNotNull((Object)it.getJobStatus());
            Object object2 = new Pair[3];
            GenericStack genericStack = jobStatus.crafting();
            Intrinsics.checkNotNullExpressionValue((Object)genericStack, (String)"jobStatus.crafting");
            object2[0] = TuplesKt.to((Object)"target", AE2Helper.INSTANCE.genericStackToMap(genericStack));
            object2[1] = TuplesKt.to((Object)"amount", (Object)jobStatus.totalItems());
            object2[2] = TuplesKt.to((Object)"progress", (Object)jobStatus.progress());
            Map baseMap = MapsKt.mutableMapOf((Pair[])object2);
            if (it.getName() != null) {
                String string;
                object2 = baseMap;
                String string2 = "CPU";
                Component component = it.getName();
                Intrinsics.checkNotNull((Object)component);
                Intrinsics.checkNotNullExpressionValue((Object)component.getString(), (String)"it.name!!.string");
                object2.put(string2, string);
            }
            craftingList.add(baseMap);
        }
        MethodResult methodResult = MethodResult.of((Object)craftingList);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(craftingList)");
        return methodResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @LuaFunction(mainThread=false)
    @NotNull
    public final MethodResult scheduleCrafting(@NotNull String mode, @NotNull String id_key, @NotNull Optional<Long> amount, @NotNull Optional<String> targetCPU) {
        ICraftingCPU iCraftingCPU;
        long realAmount;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)id_key, (String)"id_key");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter(targetCPU, (String)"targetCPU");
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            Object[] objectArray = new Object[]{null, "AE2 network is not connected"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"AE2 network is not connected\")");
            return methodResult;
        }
        ICraftingService craftingService = object;
        AEKey key = AE2Helper.INSTANCE.buildKey(mode, id_key);
        IActionSource source = IActionSource.ofMachine((IActionHost)((IActionHost)this.entity));
        Future future = craftingService.beginCraftingCalculation(this.level, () -> MENetworkBlockPlugin.scheduleCrafting$lambda$10(source), key, realAmount = (Intrinsics.areEqual((Object)mode, (Object)"item") ? amount.orElse(1L) : Long.valueOf(((Number)amount.orElse(1000L)).longValue() * (long)PeripheraliumPlatform.Companion.getFluidCompactDivider())).longValue(), CalculationStrategy.REPORT_MISSING_ITEMS);
        ICraftingPlan plan = (ICraftingPlan)future.get();
        if (!plan.missingItems().isEmpty()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = false;
            objectArray[1] = "Missing items";
            KeyCounter keyCounter = plan.missingItems();
            Intrinsics.checkNotNullExpressionValue((Object)keyCounter, (String)"plan.missingItems()");
            objectArray[2] = AE2Helper.keyCounterToLua$default(AE2Helper.INSTANCE, keyCounter, null, false, 6, null);
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(false, \"Missing items\u2026Lua(plan.missingItems()))");
            return methodResult;
        }
        if (targetCPU.isPresent()) {
            ICraftingCPU iCraftingCPU2;
            try {
                Object element$iv;
                boolean bl;
                ImmutableSet immutableSet = craftingService.getCpus();
                Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"craftingService.cpus");
                Iterable $this$first$iv = (Iterable)immutableSet;
                boolean $i$f$first = false;
                Iterator iterator = $this$first$iv.iterator();
                do {
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    element$iv = iterator.next();
                    ICraftingCPU it = (ICraftingCPU)element$iv;
                    boolean bl2 = false;
                    if (it.getName() != null) {
                        Component component = it.getName();
                        Intrinsics.checkNotNull((Object)component);
                        if (component.getString().equals(targetCPU.get())) {
                            bl = true;
                            continue;
                        }
                    }
                    bl = false;
                } while (!bl);
                iCraftingCPU2 = (ICraftingCPU)element$iv;
            }
            catch (NoSuchElementException e) {
                Object[] objectArray = new Object[]{null, "Cannot find target CPU"};
                MethodResult methodResult = MethodResult.of((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find target CPU\")");
                return methodResult;
            }
            iCraftingCPU = iCraftingCPU2;
        } else {
            iCraftingCPU = null;
        }
        ICraftingCPU realTargetCPU = iCraftingCPU;
        craftingService.submitJob(plan, null, realTargetCPU, false, source);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @Nullable
    public String getAdditionalType() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalType((IPeripheralPlugin)this);
    }

    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral((IPeripheralPlugin)this);
    }

    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral((IPeripheralPlugin)this, (IPluggablePeripheral)value);
    }

    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations((IPeripheralPlugin)this);
    }

    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods((IPeripheralPlugin)this, (MinecraftServer)server);
    }

    private static final boolean getCraftableItems$lambda$1(AEKey it) {
        return it instanceof AEItemKey;
    }

    private static final boolean getCraftableFluids$lambda$3(AEKey it) {
        return it instanceof AEFluidKey;
    }

    private static final IActionSource scheduleCrafting$lambda$10(IActionSource $source) {
        return $source;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin$Companion;", "", "()V", "PLUGIN_TYPE", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin$Provider;", "Lsite/siredvin/peripheralworks/api/PeripheralPluginProvider;", "()V", "pluginType", "", "getPluginType", "()Ljava/lang/String;", "provide", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "side", "Lnet/minecraft/core/Direction;", "peripheralworks-forge-1.20.1"})
    public static final class Provider
    implements PeripheralPluginProvider {
        @NotNull
        public static final Provider INSTANCE = new Provider();

        private Provider() {
        }

        @Override
        @NotNull
        public String getPluginType() {
            return MENetworkBlockPlugin.PLUGIN_TYPE;
        }

        @Override
        @Nullable
        public IPeripheralPlugin provide(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction side) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            if (!Configuration.INSTANCE.getEnableMEInterface()) {
                return null;
            }
            BlockEntity entity = level.m_7702_(pos);
            if (!(entity instanceof AENetworkBlockEntity)) {
                return null;
            }
            return new MENetworkBlockPlugin(level, (AENetworkBlockEntity)entity);
        }

        @Override
        @NotNull
        public Set<String> getConflictWith() {
            return PeripheralPluginProvider.DefaultImpls.getConflictWith(this);
        }

        @Override
        public int getPriority() {
            return PeripheralPluginProvider.DefaultImpls.getPriority(this);
        }

        @Override
        public int compareTo(@NotNull PeripheralPluginProvider other) {
            return PeripheralPluginProvider.DefaultImpls.compareTo(this, other);
        }
    }
}

