/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.ae2;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.blockentity.grid.AENetworkBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.fluid.ExtensionsKt;
import site.siredvin.peripheralium.storages.fluid.FluidSink;
import site.siredvin.peripheralium.storages.fluid.FluidStack;
import site.siredvin.peripheralium.storages.fluid.FluidStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u001e\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/AEFluidStorage;", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "storage", "Lappeng/api/storage/MEStorage;", "entity", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "(Lappeng/api/storage/MEStorage;Lappeng/blockentity/grid/AENetworkBlockEntity;)V", "getFluids", "", "Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "setChanged", "", "storeFluid", "stack", "takeFluid", "predicate", "Ljava/util/function/Predicate;", "limit", "", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nAEFluidStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AEFluidStorage.kt\nsite/siredvin/peripheralworks/integrations/ae2/AEFluidStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1603#2,9:44\n1855#2:53\n1856#2:55\n1612#2:56\n1#3:54\n*S KotlinDebug\n*F\n+ 1 AEFluidStorage.kt\nsite/siredvin/peripheralworks/integrations/ae2/AEFluidStorage\n*L\n13#1:44,9\n13#1:53\n13#1:55\n13#1:56\n13#1:54\n*E\n"})
public final class AEFluidStorage
implements FluidStorage {
    @NotNull
    private final MEStorage storage;
    @NotNull
    private final AENetworkBlockEntity entity;

    public AEFluidStorage(@NotNull MEStorage storage, @NotNull AENetworkBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.storage = storage;
        this.entity = entity;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterator<FluidStack> getFluids() {
        void $this$mapNotNullTo$iv$iv;
        KeyCounter keyCounter = this.storage.getAvailableStacks();
        Intrinsics.checkNotNullExpressionValue((Object)keyCounter, (String)"storage.availableStacks");
        Iterable $this$mapNotNull$iv = (Iterable)keyCounter;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FluidStack fluidStack;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object2LongMap.Entry it = (Object2LongMap.Entry)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getKey() instanceof AEFluidKey)) {
                fluidStack = null;
            } else {
                Object object = it.getKey();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type appeng.api.stacks.AEFluidKey");
                net.minecraftforge.fluids.FluidStack fluidStack2 = ((AEFluidKey)object).toStack((int)it.getLongValue());
                Intrinsics.checkNotNullExpressionValue((Object)fluidStack2, (String)"it.key as AEFluidKey).to\u2026ack(it.longValue.toInt())");
                fluidStack = ExtensionsKt.toVanilla((net.minecraftforge.fluids.FluidStack)fluidStack2);
            }
            if (fluidStack == null) continue;
            FluidStack it$iv$iv = fluidStack;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return ((List)destination$iv$iv).iterator();
    }

    public void setChanged() {
        this.entity.m_6596_();
    }

    @NotNull
    public FluidStack storeFluid(@NotNull FluidStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        long insertedAmount = this.storage.insert((AEKey)AEFluidKey.of((net.minecraftforge.fluids.FluidStack)ExtensionsKt.toForge((FluidStack)stack)), stack.getAmount(), Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
        if (insertedAmount == 0L) {
            return stack;
        }
        stack.shrink((int)insertedAmount);
        return stack;
    }

    @NotNull
    public FluidStack takeFluid(@NotNull Predicate<FluidStack> predicate, long limit) {
        Object v3;
        block5: {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            KeyCounter keyCounter = this.storage.getAvailableStacks();
            Intrinsics.checkNotNullExpressionValue((Object)keyCounter, (String)"storage.availableStacks");
            Iterable iterable = (Iterable)keyCounter;
            for (Object t : iterable) {
                boolean bl;
                Object2LongMap.Entry it = (Object2LongMap.Entry)t;
                boolean bl2 = false;
                AEKey aeKey = (AEKey)it.getKey();
                if (!(aeKey instanceof AEFluidKey)) {
                    bl = false;
                } else {
                    net.minecraftforge.fluids.FluidStack fluidStack = ((AEFluidKey)aeKey).toStack((int)it.getLongValue());
                    Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"aeKey.toStack(it.longValue.toInt())");
                    bl = predicate.test(ExtensionsKt.toVanilla((net.minecraftforge.fluids.FluidStack)fluidStack));
                }
                if (!bl) continue;
                v3 = t;
                break block5;
            }
            v3 = null;
        }
        Object2LongMap.Entry entry = v3;
        if (entry == null) {
            return FluidStack.Companion.getEMPTY();
        }
        Object2LongMap.Entry fluidToTransfer = entry;
        long extractedAmount = this.storage.extract((AEKey)fluidToTransfer.getKey(), Math.min(limit, fluidToTransfer.getLongValue()), Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
        if (extractedAmount == 0L) {
            return FluidStack.Companion.getEMPTY();
        }
        Object object = fluidToTransfer.getKey();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type appeng.api.stacks.AEFluidKey");
        net.minecraftforge.fluids.FluidStack fluidStack = ((AEFluidKey)object).toStack((int)extractedAmount);
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"fluidToTransfer.key as A\u2026(extractedAmount.toInt())");
        return ExtensionsKt.toVanilla((net.minecraftforge.fluids.FluidStack)fluidStack);
    }

    @Nullable
    public String getMovableType() {
        return FluidStorage.DefaultImpls.getMovableType((FluidStorage)this);
    }

    public long moveFrom(@NotNull FluidStorage from, long limit, @NotNull Predicate<FluidStack> takePredicate) {
        return FluidStorage.DefaultImpls.moveFrom((FluidStorage)this, (FluidStorage)from, (long)limit, takePredicate);
    }

    public long moveTo(@NotNull FluidSink to, long limit, @NotNull Predicate<FluidStack> takePredicate) {
        return FluidStorage.DefaultImpls.moveTo((FluidStorage)this, (FluidSink)to, (long)limit, takePredicate);
    }
}

