/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.ae2;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyService;
import appeng.blockentity.grid.AENetworkBlockEntity;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.energy.EnergySink;
import site.siredvin.peripheralium.storages.energy.EnergyStack;
import site.siredvin.peripheralium.storages.energy.EnergyStorage;
import site.siredvin.peripheralium.storages.energy.ForgeEnergies;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u001e\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/AEEnergyStorage;", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorage;", "energyService", "Lappeng/api/networking/energy/IEnergyService;", "entity", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "(Lappeng/api/networking/energy/IEnergyService;Lappeng/blockentity/grid/AENetworkBlockEntity;)V", "capacity", "", "getCapacity", "()J", "energy", "Lsite/siredvin/peripheralium/storages/energy/EnergyStack;", "getEnergy", "()Lsite/siredvin/peripheralium/storages/energy/EnergyStack;", "setChanged", "", "storeEnergy", "stack", "takeEnergy", "predicate", "Ljava/util/function/Predicate;", "limit", "peripheralworks-forge-1.20.1"})
public final class AEEnergyStorage
implements EnergyStorage {
    @NotNull
    private final IEnergyService energyService;
    @NotNull
    private final AENetworkBlockEntity entity;

    public AEEnergyStorage(@NotNull IEnergyService energyService, @NotNull AENetworkBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)energyService, (String)"energyService");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.energyService = energyService;
        this.entity = entity;
    }

    public long getCapacity() {
        return (long)this.energyService.getMaxStoredPower();
    }

    @NotNull
    public EnergyStack getEnergy() {
        return new EnergyStack(ForgeEnergies.INSTANCE.getFORGE(), (long)this.energyService.getStoredPower());
    }

    public void setChanged() {
        this.entity.m_6596_();
    }

    @NotNull
    public EnergyStack storeEnergy(@NotNull EnergyStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!Intrinsics.areEqual((Object)stack.getUnit(), (Object)ForgeEnergies.INSTANCE.getFORGE())) {
            return stack;
        }
        double leftover = this.energyService.injectPower((double)stack.getAmount(), Actionable.MODULATE);
        return stack.copyWithCount((long)leftover);
    }

    @NotNull
    public EnergyStack takeEnergy(@NotNull Predicate<EnergyStack> predicate, long limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getEnergy())) {
            return EnergyStack.Companion.getEMPTY();
        }
        double extracted = this.energyService.extractAEPower((double)limit, Actionable.MODULATE, PowerMultiplier.CONFIG);
        return new EnergyStack(ForgeEnergies.INSTANCE.getFORGE(), (long)extracted);
    }

    @Nullable
    public String getMovableType() {
        return EnergyStorage.DefaultImpls.getMovableType((EnergyStorage)this);
    }

    public long moveFrom(@NotNull EnergyStorage from, long limit, @NotNull Predicate<EnergyStack> takePredicate) {
        return EnergyStorage.DefaultImpls.moveFrom((EnergyStorage)this, (EnergyStorage)from, (long)limit, takePredicate);
    }

    public long moveTo(@NotNull EnergySink to, long limit, @NotNull Predicate<EnergyStack> takePredicate) {
        return EnergyStorage.DefaultImpls.moveTo((EnergyStorage)this, (EnergySink)to, (long)limit, takePredicate);
    }
}

