/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.plugins.specific;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IObservingPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.extra.plugins.PeripheralPluginUtils;
import site.siredvin.peripheralium.storages.ContainerWrapper;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.ItemStorageExtractor;
import site.siredvin.peripheralium.storages.item.ItemStorageUtils;
import site.siredvin.peripheralium.util.TextBookUtils;
import site.siredvin.peripheralium.util.ValidationHelpersKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0011H\u0007J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0007J\b\u0010\u001d\u001a\u00020\u0018H\u0007J\b\u0010\u001e\u001a\u00020\u0018H\u0007J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110 H\u0007J\b\u0010!\u001a\u00020\"H\u0007J\"\u0010#\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00112\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\b\u0010'\u001a\u00020\"H\u0007J\b\u0010(\u001a\u00020\u0013H\u0016J\b\u0010)\u001a\u00020\u0013H\u0016J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lsite/siredvin/peripheralworks/computercraft/plugins/specific/LecternPlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IObservingPeripheralPlugin;", "target", "Lnet/minecraft/world/level/block/entity/LecternBlockEntity;", "(Lnet/minecraft/world/level/block/entity/LecternBlockEntity;)V", "_connectedPeripheral", "Lsite/siredvin/peripheralium/api/peripheral/IPluggablePeripheral;", "value", "connectedPeripheral", "getConnectedPeripheral", "()Lsite/siredvin/peripheralium/api/peripheral/IPluggablePeripheral;", "setConnectedPeripheral", "(Lsite/siredvin/peripheralium/api/peripheral/IPluggablePeripheral;)V", "addPage", "Ldan200/computercraft/api/lua/MethodResult;", "text", "Ljava/util/Optional;", "", "assertBook", "", "assertEditableBook", "assertNoBook", "editPage", "page", "", "ejectBook", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "toName", "getActivePage", "getPageCount", "getText", "", "hasBook", "", "injectBook", "fromName", "bookQuery", "", "isBookEditable", "onFirstAttach", "onLastDetach", "removePage", "setActivePage", "Companion", "peripheralworks-forge-1.20.1"})
public final class LecternPlugin
implements IObservingPeripheralPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LecternBlockEntity target;
    @Nullable
    private IPluggablePeripheral _connectedPeripheral;
    @NotNull
    private static final Map<BlockPos, WeakHashMap<IPluggablePeripheral, Boolean>> OBSERVED_LECTERNS = new LinkedHashMap();

    public LecternPlugin(@NotNull LecternBlockEntity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
    }

    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return this._connectedPeripheral;
    }

    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        this._connectedPeripheral = value;
    }

    private final void assertBook() {
        if (!this.target.m_59567_()) {
            throw new LuaException("Lectern should contain book");
        }
    }

    private final void assertNoBook() {
        if (this.target.m_59567_()) {
            throw new LuaException("Lectern shouldn't contain book");
        }
    }

    private final void assertEditableBook() {
        if (!this.isBookEditable()) {
            throw new LuaException("Book should be editable");
        }
    }

    @LuaFunction(mainThread=true)
    public final boolean hasBook() {
        return this.target.m_59567_();
    }

    @LuaFunction(mainThread=true)
    public final int getPageCount() {
        this.assertBook();
        return this.target.f_59529_;
    }

    @LuaFunction(mainThread=true)
    public final int getActivePage() {
        this.assertBook();
        return this.target.m_59568_() + 1;
    }

    @LuaFunction(mainThread=true)
    public final void setActivePage(int page) {
        this.assertBook();
        ValidationHelpersKt.assertBetween((int)page, (int)1, (int)this.target.f_59529_, (String)"page");
        this.target.m_59532_(page - 1);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<String> getText() {
        this.assertBook();
        ItemStack itemStack = this.target.m_59566_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"target.book");
        return TextBookUtils.INSTANCE.getBookText(itemStack);
    }

    @LuaFunction(mainThread=true)
    public final boolean isBookEditable() {
        this.assertBook();
        return this.target.m_59566_().m_150930_(Items.f_42614_);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult addPage(@NotNull Optional<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        this.assertEditableBook();
        CompoundTag compoundTag = this.target.m_59566_().m_41783_();
        Intrinsics.checkNotNull((Object)compoundTag);
        ListTag pagesData = compoundTag.m_128437_("pages", 8);
        String string = text.orElse("");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.orElse(\"\")");
        pagesData.add((Object)StringTag.m_129297_((String)TextBookUtils.INSTANCE.stripText(string)));
        CompoundTag compoundTag2 = this.target.m_59566_().m_41783_();
        Intrinsics.checkNotNull((Object)compoundTag2);
        compoundTag2.m_128365_("pages", (Tag)pagesData);
        LecternBlockEntity lecternBlockEntity = this.target;
        ++lecternBlockEntity.f_59529_;
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult removePage(int page) {
        this.assertEditableBook();
        ValidationHelpersKt.assertBetween((int)page, (int)1, (int)this.target.f_59529_, (String)"page");
        CompoundTag compoundTag = this.target.m_59566_().m_41783_();
        Intrinsics.checkNotNull((Object)compoundTag);
        ListTag pagesData = compoundTag.m_128437_("pages", 8);
        pagesData.remove(page - 1);
        CompoundTag compoundTag2 = this.target.m_59566_().m_41783_();
        Intrinsics.checkNotNull((Object)compoundTag2);
        compoundTag2.m_128365_("pages", (Tag)pagesData);
        LecternBlockEntity lecternBlockEntity = this.target;
        --lecternBlockEntity.f_59529_;
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult editPage(int page, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.assertEditableBook();
        ValidationHelpersKt.assertBetween((int)page, (int)1, (int)this.target.f_59529_, (String)"page");
        CompoundTag compoundTag = this.target.m_59566_().m_41783_();
        Intrinsics.checkNotNull((Object)compoundTag);
        ListTag pagesData = compoundTag.m_128437_("pages", 8);
        pagesData.set(page - 1, (Tag)StringTag.m_129297_((String)TextBookUtils.INSTANCE.stripText(text)));
        CompoundTag compoundTag2 = this.target.m_59566_().m_41783_();
        Intrinsics.checkNotNull((Object)compoundTag2);
        compoundTag2.m_128365_("pages", (Tag)pagesData);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult ejectBook(@NotNull IComputerAccess computer, @NotNull String toName) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        this.assertBook();
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        Level level = this.target.m_58904_();
        Intrinsics.checkNotNull((Object)level);
        ItemSink itemSink = ItemStorageExtractor.INSTANCE.extractItemSinkFromUnknown(level, location.getTarget());
        if (itemSink == null) {
            throw new LuaException("Target '" + toName + "' is not an item inventory");
        }
        ItemSink toStorage = itemSink;
        Container container = this.target.f_59525_;
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"target.bookAccess");
        int moved = ItemStorage.DefaultImpls.moveTo$default((ItemStorage)((ItemStorage)new ContainerWrapper(container)), (ItemSink)toStorage, (int)1, (int)0, (Predicate)ItemStorageUtils.INSTANCE.getALWAYS(), (int)4, null);
        if (moved == 0) {
            Object[] objectArray = new Object[]{null, "Not enough space in target inventory"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Not enough space in target inventory\")");
            return methodResult;
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult injectBook(@NotNull IComputerAccess computer, @NotNull String fromName, @Nullable Object bookQuery) {
        ItemStack extractedBook;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        this.assertNoBook();
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        Level level = this.target.m_58904_();
        Intrinsics.checkNotNull((Object)level);
        ItemStorage itemStorage = ItemStorageExtractor.INSTANCE.extractStorageFromUnknown(level, location.getTarget());
        if (itemStorage == null) {
            throw new LuaException("Target '" + fromName + "' is not an item inventory");
        }
        ItemStorage fromStorage = itemStorage;
        Predicate<ItemStack> predicate = LecternPlugin::injectBook$lambda$0;
        if (bookQuery != null) {
            Predicate<ItemStack> predicate2 = predicate.and(PeripheralPluginUtils.INSTANCE.itemQueryToPredicate(bookQuery));
            Intrinsics.checkNotNullExpressionValue(predicate2, (String)"predicate.and(Peripheral\u2026ryToPredicate(bookQuery))");
            predicate = predicate2;
        }
        if ((extractedBook = fromStorage.takeItems(predicate, 1)).m_41619_()) {
            Object[] objectArray = new Object[]{null, "Cannot find book in desired inventory"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find book in desired inventory\")");
            return methodResult;
        }
        Level level2 = this.target.m_58904_();
        Intrinsics.checkNotNull((Object)level2);
        LecternBlock.m_269116_(null, (Level)level2, (BlockPos)this.target.m_58899_(), (BlockState)this.target.m_58900_(), (ItemStack)extractedBook);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    public void onFirstAttach() {
        if (this.getConnectedPeripheral() != null) {
            BlockPos blockPos = this.target.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"target.blockPos");
            IPluggablePeripheral iPluggablePeripheral = this._connectedPeripheral;
            Intrinsics.checkNotNull((Object)iPluggablePeripheral);
            Companion.subscribe(blockPos, iPluggablePeripheral);
        }
    }

    public void onLastDetach() {
        if (this.getConnectedPeripheral() != null) {
            BlockPos blockPos = this.target.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"target.blockPos");
            IPluggablePeripheral iPluggablePeripheral = this._connectedPeripheral;
            Intrinsics.checkNotNull((Object)iPluggablePeripheral);
            Companion.unsubscribe(blockPos, iPluggablePeripheral);
        }
    }

    @Nullable
    public String getAdditionalType() {
        return IObservingPeripheralPlugin.DefaultImpls.getAdditionalType((IObservingPeripheralPlugin)this);
    }

    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IObservingPeripheralPlugin.DefaultImpls.getOperations((IObservingPeripheralPlugin)this);
    }

    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IObservingPeripheralPlugin.DefaultImpls.getMethods((IObservingPeripheralPlugin)this, (MinecraftServer)server);
    }

    private static final boolean injectBook$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.m_150930_(Items.f_42614_) || it.m_150930_(Items.f_42615_);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0011\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0007J\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0007R)\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lsite/siredvin/peripheralworks/computercraft/plugins/specific/LecternPlugin$Companion;", "", "()V", "OBSERVED_LECTERNS", "", "Lnet/minecraft/core/BlockPos;", "Ljava/util/WeakHashMap;", "Lsite/siredvin/peripheralium/api/peripheral/IPluggablePeripheral;", "", "getOBSERVED_LECTERNS", "()Ljava/util/Map;", "sendEvent", "", "pos", "event", "", "arguments", "", "(Lnet/minecraft/core/BlockPos;Ljava/lang/String;[Ljava/lang/Object;)V", "subscribe", "peripheral", "unsubscribe", "peripheralworks-forge-1.20.1"})
    @SourceDebugExtension(value={"SMAP\nLecternPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LecternPlugin.kt\nsite/siredvin/peripheralworks/computercraft/plugins/specific/LecternPlugin$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1855#2,2:203\n*S KotlinDebug\n*F\n+ 1 LecternPlugin.kt\nsite/siredvin/peripheralworks/computercraft/plugins/specific/LecternPlugin$Companion\n*L\n36#1:203,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<BlockPos, WeakHashMap<IPluggablePeripheral, Boolean>> getOBSERVED_LECTERNS() {
            return OBSERVED_LECTERNS;
        }

        public final void sendEvent(@NotNull BlockPos pos, @NotNull String event, Object ... arguments) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            if (this.getOBSERVED_LECTERNS().containsKey(pos)) {
                WeakHashMap<IPluggablePeripheral, Boolean> weakHashMap = this.getOBSERVED_LECTERNS().get(pos);
                Intrinsics.checkNotNull(weakHashMap);
                WeakHashMap<IPluggablePeripheral, Boolean> map = weakHashMap;
                if (map.size() == 0) {
                    this.getOBSERVED_LECTERNS().remove(pos);
                } else {
                    Set<IPluggablePeripheral> set = map.keySet();
                    Intrinsics.checkNotNullExpressionValue(set, (String)"map.keys");
                    Iterable $this$forEach$iv = set;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IPluggablePeripheral it = (IPluggablePeripheral)element$iv;
                        boolean bl = false;
                        it.queueEvent(event, Arrays.copyOf(arguments, arguments.length));
                    }
                }
            }
        }

        public final void subscribe(@NotNull BlockPos pos, @NotNull IPluggablePeripheral peripheral) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
            if (!this.getOBSERVED_LECTERNS().containsKey(pos)) {
                this.getOBSERVED_LECTERNS().put(pos, new WeakHashMap());
            }
            WeakHashMap<IPluggablePeripheral, Boolean> weakHashMap = this.getOBSERVED_LECTERNS().get(pos);
            Intrinsics.checkNotNull(weakHashMap);
            ((Map)weakHashMap).put(peripheral, true);
        }

        public final void unsubscribe(@NotNull BlockPos pos, @NotNull IPluggablePeripheral peripheral) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
            if (this.getOBSERVED_LECTERNS().containsKey(pos)) {
                WeakHashMap<IPluggablePeripheral, Boolean> weakHashMap = this.getOBSERVED_LECTERNS().get(pos);
                Intrinsics.checkNotNull(weakHashMap);
                weakHashMap.remove(peripheral);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

