/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.peripherals;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.common.blocks.GenericBlockEntityBlock;
import site.siredvin.peripheralium.computercraft.peripheral.OwnedPeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.owner.BlockEntityPeripheralOwner;
import site.siredvin.peripheralium.util.representation.LuaInterpretation;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;
import site.siredvin.peripheralworks.common.blockentity.RemoteObserverBlockEntity;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00162\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0012H\u0007J\u001a\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u00120\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0012H\u0007R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/RemoteObserverPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/OwnedPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/owner/BlockEntityPeripheralOwner;", "Lsite/siredvin/peripheralworks/common/blockentity/RemoteObserverBlockEntity;", "blockEntity", "(Lsite/siredvin/peripheralworks/common/blockentity/RemoteObserverBlockEntity;)V", "isEnabled", "", "()Z", "peripheralConfiguration", "", "", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "addPosition", "Ldan200/computercraft/api/lua/MethodResult;", "pos", "", "getPositions", "", "removePosition", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nRemoteObserverPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteObserverPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/RemoteObserverPeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1549#2:59\n1620#2,3:60\n*S KotlinDebug\n*F\n+ 1 RemoteObserverPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/RemoteObserverPeripheral\n*L\n49#1:59\n49#1:60,3\n*E\n"})
public final class RemoteObserverPeripheral
extends OwnedPeripheral<BlockEntityPeripheralOwner<RemoteObserverBlockEntity>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RemoteObserverBlockEntity blockEntity;
    @NotNull
    public static final String TYPE = "remote_observer";

    public RemoteObserverPeripheral(@NotNull RemoteObserverBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        super(TYPE, (IPeripheralOwner)new BlockEntityPeripheralOwner((BlockEntity)blockEntity, null, 2, null));
        this.blockEntity = blockEntity;
    }

    public boolean isEnabled() {
        return PeripheralWorksConfig.INSTANCE.getEnableRemoteObserver();
    }

    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map base = super.getPeripheralConfiguration();
        base.put("maxRange", PeripheralWorksConfig.INSTANCE.getRemoteObserverMaxRange());
        return base;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult addPosition(@NotNull Map<?, ?> pos) {
        Intrinsics.checkNotNullParameter(pos, (String)"pos");
        BlockPos blockPos = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos();
        Comparable comparable = this.blockEntity.m_58900_().m_61143_((Property)GenericBlockEntityBlock.Companion.getFACING());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"blockEntity.blockState.g\u2026cBlockEntityBlock.FACING)");
        BlockPos targetPos = LuaInterpretation.INSTANCE.asBlockPos(blockPos, pos, (Direction)comparable);
        if (!this.blockEntity.isPosApplicable(targetPos)) {
            Object[] objectArray = new Object[]{false, "Position too far away"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(false, \"Position too far away\")");
            return methodResult;
        }
        this.blockEntity.addPosToTrack(targetPos);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult removePosition(@NotNull Map<?, ?> pos) {
        Intrinsics.checkNotNullParameter(pos, (String)"pos");
        BlockPos blockPos = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos();
        Comparable comparable = this.blockEntity.m_58900_().m_61143_((Property)GenericBlockEntityBlock.Companion.getFACING());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"blockEntity.blockState.g\u2026cBlockEntityBlock.FACING)");
        this.blockEntity.removePosToTrack(LuaInterpretation.INSTANCE.asBlockPos(blockPos, pos, (Direction)comparable));
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, Object>> getPositions() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.blockEntity.getTrackedBlocksView();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BlockPos blockPos = (BlockPos)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Comparable comparable = this.blockEntity.m_58900_().m_61143_((Property)GenericBlockEntityBlock.Companion.getFACING());
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"blockEntity.blockState.g\u2026cBlockEntityBlock.FACING)");
            collection.add(LuaRepresentation.INSTANCE.forBlockPos((BlockPos)it, (Direction)comparable, ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos()));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/RemoteObserverPeripheral$Companion;", "", "()V", "TYPE", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

