/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.peripherals;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.api.blockentities.ISyncingBlockEntity;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.computercraft.peripheral.OwnedPeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.owner.BlockEntityPeripheralOwner;
import site.siredvin.peripheralium.util.ValidationHelpersKt;
import site.siredvin.peripheralium.util.representation.LuaInterpretation;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;
import site.siredvin.peripheralium.util.world.ScanUtils;
import site.siredvin.peripheralium.xplat.XplatRegistries;
import site.siredvin.peripheralworks.common.block.FlexibleRealityAnchor;
import site.siredvin.peripheralworks.common.blockentity.FlexibleRealityAnchorBlockEntity;
import site.siredvin.peripheralworks.common.blockentity.RealityForgerBlockEntity;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.tags.BlockTags;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0017H\u0002J\u001a\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u00170\u0019H\u0007J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J*\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u00142\u000e\u0010&\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0017H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/RealityForgerPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/OwnedPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/owner/BlockEntityPeripheralOwner;", "Lsite/siredvin/peripheralworks/common/blockentity/RealityForgerBlockEntity;", "blockEntity", "(Lsite/siredvin/peripheralworks/common/blockentity/RealityForgerBlockEntity;)V", "interactionRadius", "", "getInteractionRadius", "()I", "isEnabled", "", "()Z", "peripheralConfiguration", "", "", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "applyBlockAttrs", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "blockAttrs", "", "detectAnchors", "", "findBlock", "table", "forgeReality", "Ldan200/computercraft/api/lua/MethodResult;", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "forgeRealityPieces", "forgeRealityTileEntity", "", "realityMirror", "Lsite/siredvin/peripheralworks/common/blockentity/FlexibleRealityAnchorBlockEntity;", "targetState", "appearanceTable", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nRealityForgerPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealityForgerPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/RealityForgerPeripheral\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n215#2:204\n216#2:206\n215#2,2:207\n1#3:205\n1855#4,2:209\n*S KotlinDebug\n*F\n+ 1 RealityForgerPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/RealityForgerPeripheral\n*L\n60#1:204\n60#1:206\n125#1:207,2\n176#1:209,2\n*E\n"})
public final class RealityForgerPeripheral
extends OwnedPeripheral<BlockEntityPeripheralOwner<RealityForgerBlockEntity>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TYPE = "reality_forger";
    @NotNull
    private static final Map<String, BooleanProperty> FLAG_MAPPING;

    public RealityForgerPeripheral(@NotNull RealityForgerBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        super(TYPE, (IPeripheralOwner)new BlockEntityPeripheralOwner((BlockEntity)blockEntity, null, 2, null));
    }

    public boolean isEnabled() {
        return PeripheralWorksConfig.INSTANCE.getEnableRealityForger();
    }

    private final int getInteractionRadius() {
        return PeripheralWorksConfig.INSTANCE.getRealityForgerMaxRange();
    }

    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map data = super.getPeripheralConfiguration();
        data.put("interactionRadius", this.getInteractionRadius());
        return data;
    }

    private final BlockState applyBlockAttrs(BlockState state, Map<?, ?> blockAttrs) throws LuaException {
        Object changeableState = null;
        changeableState = state;
        Map<?, ?> $this$forEach$iv = blockAttrs;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Property property;
            Object v1;
            Object object;
            Object[] objectArray;
            Object object2;
            Map.Entry<?, ?> attr;
            block9: {
                Map.Entry<?, ?> element$iv;
                attr = element$iv = iterator.next();
                boolean bl = false;
                Collection collection = state.m_61147_();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"state.properties");
                object2 = collection;
                objectArray = object2.iterator();
                while (objectArray.hasNext()) {
                    object = objectArray.next();
                    Property it = (Property)object;
                    boolean bl2 = false;
                    if (!it.m_61708_().equals(attr.getKey())) continue;
                    v1 = object;
                    break block9;
                }
                v1 = null;
            }
            if ((Property)v1 == null) {
                object2 = "Unknown property name %s";
                objectArray = new Object[]{attr.getKey()};
                String string = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                throw new LuaException(string);
            }
            Property property2 = property;
            if (property2 instanceof EnumProperty) {
                Comparable targetValue;
                Object v5;
                block10: {
                    Intrinsics.checkNotNullExpressionValue((Object)String.valueOf(attr.getValue()).toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    Collection collection = property.m_6908_();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"property.getPossibleValues()");
                    Iterable iterable = collection;
                    for (Object t : iterable) {
                        String value;
                        Comparable it = (Comparable)t;
                        boolean bl = false;
                        String string = it.toString().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                        if (!Intrinsics.areEqual((Object)string, (Object)value)) continue;
                        v5 = t;
                        break block10;
                    }
                    v5 = null;
                }
                if ((Comparable)v5 == null) {
                    object = new Object[2];
                    object[0] = attr.getKey();
                    Collection collection = property.m_6908_();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"property.getPossibleValues()");
                    object[1] = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                    throw new LuaException(String.format("Incorrect value %s, only %s is allowed", object));
                }
                Intrinsics.checkNotNull((Object)property, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.properties.Property<kotlin.Comparable<kotlin.Any>>");
                Property trickedProperty = property;
                Intrinsics.checkNotNull((Object)targetValue, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
                Intrinsics.checkNotNullExpressionValue((Object)changeableState.m_61124_(trickedProperty, targetValue), (String)"changeableState.setValue\u2026Value as Comparable<Any>)");
                continue;
            }
            if (property2 instanceof BooleanProperty) {
                if (!(attr.getValue() instanceof Boolean)) {
                    object2 = "Incorrect value %s, should be boolean";
                    objectArray = new Object[]{attr.getKey()};
                    String string = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                    throw new LuaException(string);
                }
                Object obj = attr.getValue();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Boolean");
                Intrinsics.checkNotNullExpressionValue((Object)changeableState.m_61124_(property, (Comparable)((Boolean)obj)), (String)"changeableState.setValue\u2026y, attr.value as Boolean)");
                continue;
            }
            if (!(property2 instanceof IntegerProperty)) continue;
            if (!(attr.getValue() instanceof Number)) {
                object2 = "Incorrect value %s, should be boolean";
                objectArray = new Object[]{attr.getKey()};
                String string = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                throw new LuaException(string);
            }
            Object obj = attr.getValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
            Intrinsics.checkNotNullExpressionValue((Object)changeableState.m_61124_(property, (Comparable)Integer.valueOf(((Number)obj).intValue())), (String)"changeableState.setValue\u2026value as Number).toInt())");
        }
        return changeableState;
    }

    private final BlockState findBlock(Map<?, ?> table) throws LuaException {
        if (table.containsKey("block")) {
            String blockID = String.valueOf(table.get("block"));
            Block block = (Block)XplatRegistries.INSTANCE.getBLOCKS().get(new ResourceLocation(blockID));
            if (Intrinsics.areEqual((Object)block, (Object)Blocks.f_50016_)) {
                String string = "Cannot find block %s";
                Object[] objectArray = new Object[]{table.get("block")};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                throw new LuaException(string2);
            }
            if (block.m_49966_().m_204336_(BlockTags.INSTANCE.getREALITY_FORGER_FORBIDDEN())) {
                throw new LuaException("You cannot use this block, is blocklisted");
            }
            BlockState targetState = block.m_49966_();
            if (table.containsKey("attrs")) {
                Object obj = table.get("attrs");
                Map map = obj instanceof Map ? (Map)obj : null;
                if (map == null) {
                    throw new LuaException("attrs should be a table");
                }
                Map blockAttrs = map;
                BlockState blockState = targetState;
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"targetState");
                targetState = this.applyBlockAttrs(blockState, blockAttrs);
            }
            return targetState;
        }
        return null;
    }

    private final void forgeRealityTileEntity(FlexibleRealityAnchorBlockEntity realityMirror, BlockState targetState, Map<?, ?> appearanceTable) {
        Map<?, ?> $this$forEach$iv = appearanceTable;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> element$iv;
            Map.Entry<?, ?> it = element$iv = iterator.next();
            boolean bl = false;
            if (it.getValue() instanceof Boolean) {
                BooleanProperty targetProperty = FLAG_MAPPING.get(String.valueOf(it.getKey()));
                if (targetProperty == null) continue;
                Object obj = it.getValue();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Boolean");
                realityMirror.setBooleanStateValue(targetProperty, (Boolean)obj);
                continue;
            }
            if (!Intrinsics.areEqual(it.getKey(), (Object)"lightLevel") || !(it.getValue() instanceof Number)) continue;
            Object obj = it.getValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
            realityMirror.setLightLevel(((Number)obj).intValue());
        }
        if (targetState != null) {
            FlexibleRealityAnchorBlockEntity.setMimic$default(realityMirror, targetState, null, false, 6, null);
        } else {
            ISyncingBlockEntity.DefaultImpls.pushInternalDataChangeToClient$default((ISyncingBlockEntity)((ISyncingBlockEntity)realityMirror), null, (int)1, null);
        }
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, Object>> detectAnchors() {
        List data = new ArrayList();
        Level level = this.getLevel();
        Intrinsics.checkNotNull((Object)level);
        ScanUtils.traverseBlocks$default((ScanUtils)ScanUtils.INSTANCE, (Level)level, (BlockPos)this.getPos(), (int)this.getInteractionRadius(), (arg_0, arg_1) -> RealityForgerPeripheral.detectAnchors$lambda$4(this, data, arg_0, arg_1), (boolean)false, (int)16, null);
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult forgeRealityPieces(@NotNull IArguments arguments) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        List poses = new ArrayList();
        for (Object value : arguments.getTable(0).values()) {
            if (!(value instanceof Map)) {
                throw new LuaException("First argument should be list of block positions");
            }
            poses.add(LuaInterpretation.INSTANCE.asBlockPos(((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos(), (Map)value, ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getFacing()));
        }
        List entities = new ArrayList();
        for (BlockPos pos : poses) {
            FlexibleRealityAnchorBlockEntity entity;
            if (ValidationHelpersKt.radiusCorrect((BlockPos)pos, (BlockPos)((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos(), (int)this.getInteractionRadius())) {
                Object[] objectArray = new Object[]{null, "One of blocks are too far away"};
                MethodResult methodResult = MethodResult.of((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"One of blocks are too far away\")");
                return methodResult;
            }
            Level level = this.getLevel();
            Intrinsics.checkNotNull((Object)level);
            BlockEntity blockEntity = level.m_7702_(pos);
            if ((blockEntity instanceof FlexibleRealityAnchorBlockEntity ? (FlexibleRealityAnchorBlockEntity)blockEntity : null) == null) {
                Object[] objectArray = new Object[]{false, "One of provided coordinate are not correct"};
                MethodResult methodResult = MethodResult.of((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(\n                    \u2026rrect\",\n                )");
                return methodResult;
            }
            entity = entity;
            entities.add(entity);
        }
        Map table = arguments.getTable(1);
        Intrinsics.checkNotNullExpressionValue((Object)table, (String)"table");
        BlockState targetState = this.findBlock(table);
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FlexibleRealityAnchorBlockEntity it = (FlexibleRealityAnchorBlockEntity)((Object)element$iv);
            boolean bl = false;
            this.forgeRealityTileEntity(it, targetState, table);
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult forgeReality(@NotNull IArguments arguments) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Map table = arguments.getTable(0);
        Intrinsics.checkNotNullExpressionValue((Object)table, (String)"table");
        BlockState targetState = this.findBlock(table);
        if (this.getLevel() == null) {
            Object[] objectArray = new Object[]{null, "Level is not loaded, what?"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Level is not loaded, what?\")");
            return methodResult;
        }
        Level level = this.getLevel();
        Intrinsics.checkNotNull((Object)level);
        ScanUtils.traverseBlocks$default((ScanUtils)ScanUtils.INSTANCE, (Level)level, (BlockPos)this.getPos(), (int)this.getInteractionRadius(), (arg_0, arg_1) -> RealityForgerPeripheral.forgeReality$lambda$6(this, targetState, table, arg_0, arg_1), (boolean)false, (int)16, null);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    private static final void detectAnchors$lambda$4(RealityForgerPeripheral this$0, List $data, BlockState blockState, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Level level = this$0.getLevel();
        Intrinsics.checkNotNull((Object)level);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FlexibleRealityAnchorBlockEntity) {
            $data.add(LuaRepresentation.INSTANCE.forBlockPos(pos, ((BlockEntityPeripheralOwner)this$0.getPeripheralOwner()).getFacing(), this$0.getPos()));
        }
    }

    private static final void forgeReality$lambda$6(RealityForgerPeripheral this$0, BlockState $targetState, Map $table, BlockState blockState, BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Level level = this$0.getLevel();
        Intrinsics.checkNotNull((Object)level);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof FlexibleRealityAnchorBlockEntity) {
            FlexibleRealityAnchorBlockEntity flexibleRealityAnchorBlockEntity = (FlexibleRealityAnchorBlockEntity)blockEntity;
            Intrinsics.checkNotNullExpressionValue((Object)$table, (String)"table");
            this$0.forgeRealityTileEntity(flexibleRealityAnchorBlockEntity, $targetState, $table);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"playerPassable", (Object)FlexibleRealityAnchor.Companion.getPLAYER_PASSABLE()), TuplesKt.to((Object)"lightPassable", (Object)FlexibleRealityAnchor.Companion.getLIGHT_PASSABLE()), TuplesKt.to((Object)"skyLightPassable", (Object)FlexibleRealityAnchor.Companion.getSKY_LIGHT_PASSABLE()), TuplesKt.to((Object)"invisible", (Object)FlexibleRealityAnchor.Companion.getINVISIBLE())};
        FLAG_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/RealityForgerPeripheral$Companion;", "", "()V", "FLAG_MAPPING", "", "", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "TYPE", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

