/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.modem;

import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.WorkMonitor;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralworks.computercraft.modem.ModemPeripheral;
import site.siredvin.peripheralworks.computercraft.modem.PeripheralRecord;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0017J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J\"\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u001aH\u0016J\"\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J+\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u000b2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f\"\u00020 H\u0016\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u00020\u001c2\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lsite/siredvin/peripheralworks/computercraft/modem/RemoteComputerWrapper;", "O", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "record", "Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralRecord;", "modemPeripheral", "Lsite/siredvin/peripheralworks/computercraft/modem/ModemPeripheral;", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralRecord;Lsite/siredvin/peripheralworks/computercraft/modem/ModemPeripheral;)V", "getAttachmentName", "", "getAvailablePeripheral", "Ldan200/computercraft/api/peripheral/IPeripheral;", "name", "getAvailablePeripherals", "", "getID", "", "getMainThreadMonitor", "Ldan200/computercraft/api/peripheral/WorkMonitor;", "mount", "desiredLocation", "Ldan200/computercraft/api/filesystem/Mount;", "driveName", "mountWritable", "Ldan200/computercraft/api/filesystem/WritableMount;", "queueEvent", "", "event", "arguments", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "unmount", "location", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nRemoteComputerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteComputerWrapper.kt\nsite/siredvin/peripheralworks/computercraft/modem/RemoteComputerWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1179#2,2:78\n1253#2,4:80\n*S KotlinDebug\n*F\n+ 1 RemoteComputerWrapper.kt\nsite/siredvin/peripheralworks/computercraft/modem/RemoteComputerWrapper\n*L\n64#1:78,2\n64#1:80,4\n*E\n"})
public final class RemoteComputerWrapper<O extends IPeripheralOwner>
implements IComputerAccess {
    @NotNull
    private final IComputerAccess computer;
    @NotNull
    private final PeripheralRecord<O> record;
    @NotNull
    private final ModemPeripheral<O> modemPeripheral;

    public RemoteComputerWrapper(@NotNull IComputerAccess computer, @NotNull PeripheralRecord<O> record, @NotNull ModemPeripheral<O> modemPeripheral) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter(modemPeripheral, (String)"modemPeripheral");
        this.computer = computer;
        this.record = record;
        this.modemPeripheral = modemPeripheral;
    }

    @Nullable
    public String mount(@NotNull String desiredLocation, @NotNull Mount mount) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        return this.computer.mount(desiredLocation, mount, this.record.getName());
    }

    @Nullable
    public String mount(@NotNull String desiredLocation, @NotNull Mount mount, @NotNull String driveName) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        Intrinsics.checkNotNullParameter((Object)driveName, (String)"driveName");
        return this.computer.mount(desiredLocation, mount, driveName);
    }

    @Nullable
    public String mountWritable(@NotNull String desiredLocation, @NotNull WritableMount mount) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        return this.computer.mountWritable(desiredLocation, mount, this.record.getName());
    }

    @Nullable
    public String mountWritable(@NotNull String desiredLocation, @NotNull WritableMount mount, @NotNull String driveName) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        Intrinsics.checkNotNullParameter((Object)driveName, (String)"driveName");
        return this.computer.mountWritable(desiredLocation, mount, driveName);
    }

    public void unmount(@Nullable String location) {
        this.computer.unmount(location);
    }

    public int getID() {
        return this.computer.getID();
    }

    public void queueEvent(@Nonnull @NotNull String event, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.computer.queueEvent(event, Arrays.copyOf(arguments, arguments.length));
    }

    @Nonnull
    @NotNull
    public WorkMonitor getMainThreadMonitor() {
        WorkMonitor workMonitor = this.computer.getMainThreadMonitor();
        Intrinsics.checkNotNullExpressionValue((Object)workMonitor, (String)"computer.mainThreadMonitor");
        return workMonitor;
    }

    @Nonnull
    @NotNull
    public String getAttachmentName() {
        return this.record.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, IPeripheral> getAvailablePeripherals() {
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.modemPeripheral.getPeripheralsRecord();
        synchronized (concurrentMap) {
            void $this$associateTo$iv$iv;
            boolean bl = false;
            Iterable $this$associate$iv = this.modemPeripheral.getPeripheralsRecord().entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to(it.getKey(), (Object)((PeripheralRecord)it.getValue()).getPeripheral());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map map = destination$iv$iv;
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IPeripheral getAvailablePeripheral(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.modemPeripheral.getPeripheralsRecord();
        synchronized (concurrentMap) {
            PeripheralRecord peripheralRecord;
            block4: {
                boolean bl = false;
                if ((PeripheralRecord)this.modemPeripheral.getPeripheralsRecord().get(name) != null) break block4;
                IPeripheral iPeripheral = null;
                return iPeripheral;
            }
            PeripheralRecord record = peripheralRecord;
            IPeripheral iPeripheral = record.getPeripheral();
            return iPeripheral;
        }
    }
}

