/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.modem;

import com.google.common.collect.MapMaker;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.computercraft.peripheral.OwnedPeripheral;
import site.siredvin.peripheralworks.computercraft.modem.ModemPeripheral;
import site.siredvin.peripheralworks.computercraft.modem.PeripheralRecord;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J'\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010#\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&H\u0007J'\u0010'\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010#\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010$J\u0010\u0010(\u001a\u00020)2\u0006\u0010#\u001a\u00020\u0005H\u0007J\b\u0010*\u001a\u00020)H\u0007J\b\u0010+\u001a\u00020\u0013H\u0016J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000fH\u0014R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR2\u0010\r\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lsite/siredvin/peripheralworks/computercraft/modem/ModemPeripheral;", "O", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "Lsite/siredvin/peripheralium/computercraft/peripheral/OwnedPeripheral;", "peripheralType", "", "owner", "(Ljava/lang/String;Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;)V", "peripheralsRecord", "Ljava/util/concurrent/ConcurrentMap;", "Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralRecord;", "getPeripheralsRecord", "()Ljava/util/concurrent/ConcurrentMap;", "remotePeripherals", "", "Ldan200/computercraft/api/peripheral/IPeripheral;", "kotlin.jvm.PlatformType", "", "attach", "", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "attachRemotePeripheral", "peripheral", "internalID", "callRemote", "Ldan200/computercraft/api/lua/MethodResult;", "context", "Ldan200/computercraft/api/lua/ILuaContext;", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "detach", "getMethodsRemote", "", "", "name", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;)[Ljava/lang/Object;", "getNamesRemote", "", "getTypeRemote", "isPresentRemote", "", "isWireless", "purgePeripheral", "removeRemotePeripheral", "selectName", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nModemPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModemPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/modem/ModemPeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1855#2,2:140\n1855#2,2:143\n1855#2:145\n1855#2,2:146\n1856#2:148\n1#3:142\n*S KotlinDebug\n*F\n+ 1 ModemPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/modem/ModemPeripheral\n*L\n40#1:140,2\n51#1:143,2\n61#1:145\n62#1:146,2\n61#1:148\n*E\n"})
public abstract class ModemPeripheral<O extends IPeripheralOwner>
extends OwnedPeripheral<O> {
    @NotNull
    private final ConcurrentMap<String, PeripheralRecord<O>> peripheralsRecord;
    private final Set<IPeripheral> remotePeripherals;

    public ModemPeripheral(@NotNull String peripheralType, @NotNull O owner) {
        Intrinsics.checkNotNullParameter((Object)peripheralType, (String)"peripheralType");
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        super(peripheralType, owner);
        this.peripheralsRecord = new ConcurrentHashMap();
        this.remotePeripherals = Collections.newSetFromMap(new MapMaker().concurrencyLevel(4).weakKeys().makeMap());
    }

    @NotNull
    public final ConcurrentMap<String, PeripheralRecord<O>> getPeripheralsRecord() {
        return this.peripheralsRecord;
    }

    @NotNull
    protected String selectName(@NotNull IPeripheral peripheral) {
        Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
        Integer maxIndex2 = this.peripheralsRecord.keySet().stream().filter(arg_0 -> ModemPeripheral.selectName$lambda$0((Function1)new Function1<String, Boolean>(peripheral){
            final /* synthetic */ IPeripheral $peripheral;
            {
                this.$peripheral = $peripheral;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                String string = this.$peripheral.getType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"peripheral.type");
                return StringsKt.startsWith$default((String)key, (String)string, (boolean)false, (int)2, null);
            }
        }, arg_0)).map(arg_0 -> ModemPeripheral.selectName$lambda$1(selectName.maxIndex.2.INSTANCE, arg_0)).max((arg_0, arg_1) -> ModemPeripheral.selectName$lambda$2(selectName.maxIndex.3.INSTANCE, arg_0, arg_1)).orElse(0);
        return peripheral.getType() + "_" + (maxIndex2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachRemotePeripheral(@NotNull IPeripheral peripheral, @NotNull String internalID) {
        Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
        Intrinsics.checkNotNullParameter((Object)internalID, (String)"internalID");
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralsRecord;
        synchronized (concurrentMap) {
            boolean bl = false;
            ReentrantLock reentrantLock = this.getConnectedComputersLock();
            reentrantLock.lock();
            try {
                boolean bl2 = false;
                if (this.remotePeripherals.contains(peripheral)) {
                    return;
                }
                String peripheralName = this.selectName(peripheral);
                PeripheralRecord record = new PeripheralRecord(peripheral, peripheralName, internalID, this);
                Iterable $this$forEach$iv = this.getConnectedComputers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IComputerAccess computer = (IComputerAccess)element$iv;
                    boolean bl3 = false;
                    record.attach(computer);
                }
                this.remotePeripherals.add(peripheral);
                ((Map)this.peripheralsRecord).put(peripheralName, record);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                reentrantLock.unlock();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemotePeripheral(@NotNull String internalID) {
        Intrinsics.checkNotNullParameter((Object)internalID, (String)"internalID");
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralsRecord;
        synchronized (concurrentMap) {
            PeripheralRecord peripheralRecord;
            boolean bl = false;
            ReentrantLock reentrantLock = this.getConnectedComputersLock();
            reentrantLock.lock();
            try {
                PeripheralRecord peripheralRecord2;
                Object v0;
                block10: {
                    boolean bl2 = false;
                    Iterable iterable = this.peripheralsRecord.values();
                    Iterator iterator = iterable.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        PeripheralRecord it = (PeripheralRecord)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getInternalID(), (Object)internalID)) continue;
                        v0 = t;
                        break block10;
                    }
                    v0 = null;
                }
                if ((PeripheralRecord)v0 == null) {
                    return;
                }
                PeripheralRecord record = peripheralRecord2;
                Iterable $this$forEach$iv = this.getConnectedComputers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IComputerAccess p0 = (IComputerAccess)element$iv;
                    boolean bl4 = false;
                    record.detach(p0);
                }
                this.remotePeripherals.remove(record.getPeripheral());
                peripheralRecord = (PeripheralRecord)this.peripheralsRecord.remove(record.getName());
            }
            finally {
                reentrantLock.unlock();
            }
            PeripheralRecord peripheralRecord3 = peripheralRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void purgePeripheral() {
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralsRecord;
        synchronized (concurrentMap) {
            boolean bl = false;
            ReentrantLock reentrantLock = this.getConnectedComputersLock();
            reentrantLock.lock();
            try {
                boolean bl2 = false;
                Iterable $this$forEach$iv = this.peripheralsRecord.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$forEach$iv2;
                    PeripheralRecord it = (PeripheralRecord)element$iv;
                    boolean bl3 = false;
                    Iterable iterable = this.getConnectedComputers();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    PeripheralRecord peripheralRecord = it;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        IComputerAccess p0 = (IComputerAccess)element$iv2;
                        boolean bl4 = false;
                        peripheralRecord.detach(p0);
                    }
                    this.remotePeripherals.remove(it.getPeripheral());
                    this.peripheralsRecord.remove(it.getName());
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                reentrantLock.unlock();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        super.attach(computer);
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralsRecord;
        synchronized (concurrentMap) {
            boolean bl = false;
            this.peripheralsRecord.values().forEach(arg_0 -> ModemPeripheral.attach$lambda$14$lambda$13(computer, arg_0));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        super.detach(computer);
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralsRecord;
        synchronized (concurrentMap) {
            boolean bl = false;
            this.peripheralsRecord.values().forEach(arg_0 -> ModemPeripheral.detach$lambda$16$lambda$15(computer, arg_0));
            Unit unit = Unit.INSTANCE;
        }
    }

    @LuaFunction
    @NotNull
    public final Collection<String> getNamesRemote() {
        return this.peripheralsRecord.keySet();
    }

    @LuaFunction
    public final boolean isPresentRemote(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.peripheralsRecord.containsKey(name);
    }

    @LuaFunction
    public final boolean isWireless() {
        return false;
    }

    @LuaFunction
    @Nullable
    public final Object[] getTypeRemote(@Nullable IComputerAccess computer, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PeripheralRecord peripheralRecord = (PeripheralRecord)this.peripheralsRecord.get(name);
        if (peripheralRecord == null) {
            return null;
        }
        PeripheralRecord record = peripheralRecord;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)record.getPeripheral().getType(), (String)"record.peripheral.type");
        return objectArray;
    }

    @LuaFunction
    @Nullable
    public final Object[] getMethodsRemote(@Nullable IComputerAccess computer, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PeripheralRecord peripheralRecord = (PeripheralRecord)this.peripheralsRecord.get(name);
        if (peripheralRecord == null) {
            return null;
        }
        PeripheralRecord record = peripheralRecord;
        Object[] objectArray = new Object[]{record.getMethodNames()};
        return objectArray;
    }

    @LuaFunction
    @NotNull
    public final MethodResult callRemote(@NotNull IComputerAccess computer, @Nullable ILuaContext context, @NotNull IArguments arguments) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String remoteName = arguments.getString(0);
        String methodName = arguments.getString(1);
        PeripheralRecord peripheralRecord = (PeripheralRecord)this.peripheralsRecord.get(remoteName);
        if (peripheralRecord == null) {
            throw new LuaException("No peripheral: " + remoteName);
        }
        PeripheralRecord record = peripheralRecord;
        Intrinsics.checkNotNullExpressionValue((Object)methodName, (String)"methodName");
        return record.callMethod(computer, context, methodName, arguments.drop(2));
    }

    private static final boolean selectName$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Integer selectName$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final int selectName$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final void attach$lambda$14$lambda$13(IComputerAccess $computer, PeripheralRecord record) {
        Intrinsics.checkNotNullParameter((Object)$computer, (String)"$computer");
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        record.attach($computer);
    }

    private static final void detach$lambda$16$lambda$15(IComputerAccess $computer, PeripheralRecord record) {
        Intrinsics.checkNotNullParameter((Object)$computer, (String)"$computer");
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        record.detach($computer);
    }
}

