/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.common.events;

import com.google.common.cache.CacheBuilder;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralworks.PeripheralWorksCore;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u001d\"\u00020\u0015\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001fJ\u001e\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"J\u0006\u0010$\u001a\u00020\u001bJ\u0016\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\nJ\u001f\u0010(\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u001d\"\u00020\u0015\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010(\u001a\u00020\u001b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u001fJ\u000e\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u000eJ\u001c\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00062\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000Rb\u0010\u0007\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n \u000b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t \u000b**\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n \u000b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\f\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u000f0\u000f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00061"}, d2={"Lsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus;", "", "()V", "EVENT_QUEUE_MAX_SIZE", "", "_lastEventID", "", "eventQueue", "Lcom/google/common/collect/EvictingQueue;", "Lkotlin/Pair;", "Lsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus$BlockStateUpdateEvent;", "kotlin.jvm.PlatformType", "hookedPlayers", "Ljava/util/concurrent/ConcurrentMap;", "Lnet/minecraft/server/level/ServerPlayer;", "", "lastEventID", "getLastEventID", "()J", "listenedBlockPos", "", "Lnet/minecraft/core/BlockPos;", "trackedBlocks", "", "getTrackedBlocks", "()Ljava/util/List;", "addBlockPos", "", "pos", "", "([Lnet/minecraft/core/BlockPos;)V", "", "onBlockStateChange", "previous", "Lnet/minecraft/world/level/block/state/BlockState;", "current", "postDebugLog", "putEventIntoQueue", "id", "data", "removeBlockPos", "poses", "togglePlayer", "player", "traverseEvents", "lastConsumedID", "consumer", "Ljava/util/function/Consumer;", "BlockStateUpdateEvent", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nBlockStateUpdateEventBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockStateUpdateEventBus.kt\nsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1855#2,2:93\n*S KotlinDebug\n*F\n+ 1 BlockStateUpdateEventBus.kt\nsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus\n*L\n86#1:93,2\n*E\n"})
public final class BlockStateUpdateEventBus {
    @NotNull
    public static final BlockStateUpdateEventBus INSTANCE = new BlockStateUpdateEventBus();
    private static final int EVENT_QUEUE_MAX_SIZE = 200;
    @NotNull
    private static final Set<BlockPos> listenedBlockPos = new LinkedHashSet();
    private static final ConcurrentMap<ServerPlayer, Boolean> hookedPlayers = new MapMaker().weakKeys().concurrencyLevel(4).initialCapacity(1).makeMap();
    private static long _lastEventID;
    private static final EvictingQueue<Pair<Long, BlockStateUpdateEvent>> eventQueue;

    private BlockStateUpdateEventBus() {
    }

    @NotNull
    public final List<BlockPos> getTrackedBlocks() {
        return CollectionsKt.toList((Iterable)listenedBlockPos);
    }

    public final synchronized long getLastEventID() {
        return _lastEventID;
    }

    public final synchronized void postDebugLog() {
        CacheBuilder.newBuilder().weakKeys();
        PeripheralWorksCore.INSTANCE.getLOGGER().info("Current last event ID: " + _lastEventID);
        PeripheralWorksCore.INSTANCE.getLOGGER().info("Current tracked pos: " + listenedBlockPos);
    }

    public final void addBlockPos(BlockPos ... pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        CollectionsKt.addAll((Collection)listenedBlockPos, (Object[])pos);
    }

    public final void addBlockPos(@NotNull Collection<? extends BlockPos> pos) {
        Intrinsics.checkNotNullParameter(pos, (String)"pos");
        listenedBlockPos.addAll(pos);
    }

    public final void removeBlockPos(BlockPos ... pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        listenedBlockPos.removeAll(ArraysKt.toSet((Object[])pos));
    }

    public final void removeBlockPos(@NotNull Collection<? extends BlockPos> poses) {
        Intrinsics.checkNotNullParameter(poses, (String)"poses");
        listenedBlockPos.removeAll(CollectionsKt.toSet((Iterable)poses));
    }

    public final synchronized void putEventIntoQueue(long id, @NotNull BlockStateUpdateEvent data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        eventQueue.add((Object)new Pair((Object)id, (Object)data));
        long l = _lastEventID;
        _lastEventID = l + 1L;
    }

    public final synchronized long traverseEvents(long lastConsumedID, @NotNull Consumer<BlockStateUpdateEvent> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        long consumedTracker = lastConsumedID;
        for (Pair message : eventQueue) {
            if (message == null || ((Number)message.getFirst()).longValue() <= consumedTracker) continue;
            consumer.accept((BlockStateUpdateEvent)message.getSecond());
            consumedTracker = ((Number)message.getFirst()).longValue();
        }
        return consumedTracker;
    }

    public final void togglePlayer(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ConcurrentMap<ServerPlayer, Boolean> concurrentMap = hookedPlayers;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"hookedPlayers");
        if (((Map)concurrentMap).containsKey(player)) {
            hookedPlayers.remove(player);
        } else {
            ConcurrentMap<ServerPlayer, Boolean> concurrentMap2 = hookedPlayers;
            Intrinsics.checkNotNullExpressionValue(concurrentMap2, (String)"hookedPlayers");
            Map map = concurrentMap2;
            Boolean bl = true;
            map.put(player, bl);
        }
    }

    public final void onBlockStateChange(@NotNull BlockPos pos, @NotNull BlockState previous, @NotNull BlockState current) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        if (listenedBlockPos.contains(pos)) {
            this.putEventIntoQueue(this.getLastEventID(), new BlockStateUpdateEvent(pos, previous, current));
            Iterable $this$forEach$iv = hookedPlayers.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerPlayer it = (ServerPlayer)element$iv;
                boolean bl = false;
                it.m_213846_((Component)Component.m_237113_((String)("Block " + pos + " changed")));
            }
        }
    }

    static {
        eventQueue = EvictingQueue.create((int)200);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus$BlockStateUpdateEvent;", "", "pos", "Lnet/minecraft/core/BlockPos;", "previous", "Lnet/minecraft/world/level/block/state/BlockState;", "current", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V", "getCurrent", "()Lnet/minecraft/world/level/block/state/BlockState;", "getPos", "()Lnet/minecraft/core/BlockPos;", "getPrevious", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "peripheralworks-forge-1.20.1"})
    public static final class BlockStateUpdateEvent {
        @NotNull
        private final BlockPos pos;
        @NotNull
        private final BlockState previous;
        @NotNull
        private final BlockState current;

        public BlockStateUpdateEvent(@NotNull BlockPos pos, @NotNull BlockState previous, @NotNull BlockState current) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            this.pos = pos;
            this.previous = previous;
            this.current = current;
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        @NotNull
        public final BlockState getPrevious() {
            return this.previous;
        }

        @NotNull
        public final BlockState getCurrent() {
            return this.current;
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        @NotNull
        public final BlockState component2() {
            return this.previous;
        }

        @NotNull
        public final BlockState component3() {
            return this.current;
        }

        @NotNull
        public final BlockStateUpdateEvent copy(@NotNull BlockPos pos, @NotNull BlockState previous, @NotNull BlockState current) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            return new BlockStateUpdateEvent(pos, previous, current);
        }

        public static /* synthetic */ BlockStateUpdateEvent copy$default(BlockStateUpdateEvent blockStateUpdateEvent, BlockPos blockPos, BlockState blockState, BlockState blockState2, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = blockStateUpdateEvent.pos;
            }
            if ((n & 2) != 0) {
                blockState = blockStateUpdateEvent.previous;
            }
            if ((n & 4) != 0) {
                blockState2 = blockStateUpdateEvent.current;
            }
            return blockStateUpdateEvent.copy(blockPos, blockState, blockState2);
        }

        @NotNull
        public String toString() {
            return "BlockStateUpdateEvent(pos=" + this.pos + ", previous=" + this.previous + ", current=" + this.current + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.previous.hashCode();
            result = result * 31 + this.current.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockStateUpdateEvent)) {
                return false;
            }
            BlockStateUpdateEvent blockStateUpdateEvent = (BlockStateUpdateEvent)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)blockStateUpdateEvent.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.previous, (Object)blockStateUpdateEvent.previous)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.current, (Object)blockStateUpdateEvent.current);
        }
    }
}

