/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.common.blockentity;

import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.blockentities.IObservingBlockEntity;
import site.siredvin.peripheralium.api.blockentities.ISyncingBlockEntity;
import site.siredvin.peripheralium.common.blockentities.MutableNBTBlockEntity;
import site.siredvin.peripheralium.common.blocks.GenericBlockEntityBlock;
import site.siredvin.peripheralium.util.representation.EnrichersKt;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.common.events.BlockStateUpdateEventBus;
import site.siredvin.peripheralworks.common.setup.BlockEntityTypes;
import site.siredvin.peripheralworks.computercraft.peripherals.RemoteObserverPeripheral;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001)B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\nH\u0014J\b\u0010\u001a\u001a\u00020\u0016H\u0016J \u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0005J\u001a\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0016J\u000e\u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005J\u0010\u0010%\u001a\u00020#2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020\u0016H\u0016J\u000e\u0010'\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0005J\b\u0010(\u001a\u00020\u0016H\u0002R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006*"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/RemoteObserverBlockEntity;", "Lsite/siredvin/peripheralium/common/blockentities/MutableNBTBlockEntity;", "Lsite/siredvin/peripheralworks/computercraft/peripherals/RemoteObserverPeripheral;", "Lsite/siredvin/peripheralium/api/blockentities/IObservingBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "facing", "Lnet/minecraft/core/Direction;", "getFacing", "()Lnet/minecraft/core/Direction;", "lastConsumedEventID", "", "trackedBlocks", "", "trackedBlocksView", "", "getTrackedBlocksView", "()Ljava/util/List;", "addPosToTrack", "", "pos", "createPeripheral", "side", "destroy", "handleTick", "level", "Lnet/minecraft/world/level/Level;", "state", "isPosApplicable", "", "loadInternalData", "data", "Lnet/minecraft/nbt/CompoundTag;", "removePosToTrack", "saveInternalData", "setRemoved", "togglePos", "unload", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nRemoteObserverBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteObserverBlockEntity.kt\nsite/siredvin/peripheralworks/common/blockentity/RemoteObserverBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1855#2,2:120\n1855#2,2:122\n1855#2,2:124\n*S KotlinDebug\n*F\n+ 1 RemoteObserverBlockEntity.kt\nsite/siredvin/peripheralworks/common/blockentity/RemoteObserverBlockEntity\n*L\n80#1:120,2\n88#1:122,2\n95#1:124,2\n*E\n"})
public final class RemoteObserverBlockEntity
extends MutableNBTBlockEntity<RemoteObserverPeripheral>
implements IObservingBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long lastConsumedEventID;
    @NotNull
    private final List<BlockPos> trackedBlocks;
    @NotNull
    public static final String TRACKED_BLOCKS_TAG = "trackedBlocks";

    public RemoteObserverBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        BlockEntityType<RemoteObserverBlockEntity> blockEntityType = BlockEntityTypes.INSTANCE.getREMOTE_OBSERVER().get();
        Intrinsics.checkNotNullExpressionValue(blockEntityType, (String)"BlockEntityTypes.REMOTE_OBSERVER.get()");
        super(blockEntityType, blockPos, blockState);
        this.lastConsumedEventID = BlockStateUpdateEventBus.INSTANCE.getLastEventID() - 1L;
        this.trackedBlocks = new ArrayList();
    }

    private final Direction getFacing() {
        Comparable comparable = this.m_58900_().m_61143_((Property)GenericBlockEntityBlock.Companion.getFACING());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"blockState.getValue(Gene\u2026cBlockEntityBlock.FACING)");
        return (Direction)comparable;
    }

    @NotNull
    public final List<BlockPos> getTrackedBlocksView() {
        return this.trackedBlocks;
    }

    @NotNull
    protected RemoteObserverPeripheral createPeripheral(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return new RemoteObserverPeripheral(this);
    }

    public final boolean isPosApplicable(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (Intrinsics.areEqual((Object)pos, (Object)this.m_58899_())) {
            return false;
        }
        return pos.m_123314_((Vec3i)this.m_58899_(), (double)PeripheralWorksConfig.INSTANCE.getRemoteObserverMaxRange());
    }

    public final boolean togglePos(@NotNull BlockPos pos) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.trackedBlocks.contains(pos)) {
            this.removePosToTrack(pos);
            bl = false;
        } else {
            this.addPosToTrack(pos);
            bl = true;
        }
        boolean blockAdded = bl;
        ISyncingBlockEntity.DefaultImpls.pushInternalDataChangeToClient$default((ISyncingBlockEntity)((ISyncingBlockEntity)this), null, (int)1, null);
        return blockAdded;
    }

    public final void addPosToTrack(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.trackedBlocks.add(pos);
        BlockPos[] blockPosArray = new BlockPos[]{pos};
        BlockStateUpdateEventBus.INSTANCE.addBlockPos(blockPosArray);
    }

    public final void removePosToTrack(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.trackedBlocks.remove(pos)) {
            BlockPos[] blockPosArray = new BlockPos[]{pos};
            BlockStateUpdateEventBus.INSTANCE.removeBlockPos(blockPosArray);
        }
    }

    private final void unload() {
        BlockStateUpdateEventBus.INSTANCE.removeBlockPos((Collection<? extends BlockPos>)this.trackedBlocks);
    }

    @NotNull
    public CompoundTag saveInternalData(@NotNull CompoundTag data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ListTag trackedBlockTag = new ListTag();
        Iterable $this$forEach$iv = this.trackedBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            trackedBlockTag.add((Object)NbtUtils.m_129224_((BlockPos)it));
        }
        data.m_128365_(TRACKED_BLOCKS_TAG, (Tag)trackedBlockTag);
        return data;
    }

    @NotNull
    public BlockState loadInternalData(@NotNull CompoundTag data, @Nullable BlockState state) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.m_128441_(TRACKED_BLOCKS_TAG)) {
            ListTag internalList = data.m_128437_(TRACKED_BLOCKS_TAG, 10);
            Intrinsics.checkNotNullExpressionValue((Object)internalList, (String)"internalList");
            Iterable $this$forEach$iv = (Iterable)internalList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tag it = (Tag)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)((CompoundTag)it));
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"readBlockPos(it as CompoundTag)");
                this.addPosToTrack(blockPos);
            }
        }
        if ((blockState = state) == null) {
            BlockState blockState2 = this.m_58900_();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"blockState");
        }
        return blockState;
    }

    public void handleTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.lastConsumedEventID = BlockStateUpdateEventBus.INSTANCE.traverseEvents(this.lastConsumedEventID, arg_0 -> RemoteObserverBlockEntity.handleTick$lambda$3(this, arg_0));
    }

    public void m_7651_() {
        this.unload();
        super.m_7651_();
    }

    public void destroy() {
        this.unload();
    }

    public void blockTick() {
        IObservingBlockEntity.DefaultImpls.blockTick((IObservingBlockEntity)this);
    }

    public void onNeighbourChange(@NotNull BlockPos neighbour) {
        IObservingBlockEntity.DefaultImpls.onNeighbourChange((IObservingBlockEntity)this, (BlockPos)neighbour);
    }

    public void placed() {
        IObservingBlockEntity.DefaultImpls.placed((IObservingBlockEntity)this);
    }

    public void setPlacedBy(@Nullable LivingEntity entity, @NotNull ItemStack stack) {
        IObservingBlockEntity.DefaultImpls.setPlacedBy((IObservingBlockEntity)this, (LivingEntity)entity, (ItemStack)stack);
    }

    private static final void handleTick$lambda$3(RemoteObserverBlockEntity this$0, BlockStateUpdateEventBus.BlockStateUpdateEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = this$0.getConnectedComputers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IComputerAccess computer = (IComputerAccess)element$iv;
            boolean bl = false;
            Map previousState = LuaRepresentation.INSTANCE.forBlockState(it.getPrevious());
            Map currentState = LuaRepresentation.INSTANCE.forBlockState(it.getCurrent());
            EnrichersKt.getStateProperties().accept(it.getPrevious(), previousState);
            EnrichersKt.getStateProperties().accept(it.getCurrent(), currentState);
            Object[] objectArray = new Object[3];
            BlockPos blockPos = it.getPos();
            Direction direction = this$0.getFacing();
            BlockPos blockPos2 = this$0.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"blockPos");
            objectArray[0] = LuaRepresentation.INSTANCE.forBlockPos(blockPos, direction, blockPos2);
            objectArray[1] = previousState;
            objectArray[2] = currentState;
            computer.queueEvent("block_change", objectArray);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/RemoteObserverBlockEntity$Companion;", "", "()V", "TRACKED_BLOCKS_TAG", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

