/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.common.blockentity;

import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.blockentities.IObservingBlockEntity;
import site.siredvin.peripheralium.api.blockentities.ISyncingBlockEntity;
import site.siredvin.peripheralium.api.peripheral.IOwnedPeripheral;
import site.siredvin.peripheralium.common.blockentities.MutableNBTBlockEntity;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;
import site.siredvin.peripheralworks.PeripheralWorksCore;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.common.events.BlockStateUpdateEventBus;
import site.siredvin.peripheralworks.common.setup.BlockEntityTypes;
import site.siredvin.peripheralworks.computercraft.peripherals.PeripheralProxyPeripheral;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u000278B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015J\u000e\u0010%\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0005J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u001cH\u0014J\b\u0010(\u001a\u00020\u0019H\u0016J \u0010)\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0007H\u0016J\u000e\u0010+\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0005J\u001a\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\b\u0010*\u001a\u0004\u0018\u00010\u0007H\u0016J\u000e\u0010/\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0005J\u0010\u00100\u001a\u00020.2\u0006\u0010-\u001a\u00020.H\u0016J\b\u00101\u001a\u00020\u0019H\u0016J\u001e\u00102\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u00103\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u00104\u001a\u00020\u0019H\u0002J\u0010\u00105\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0015H\u0002J\u000e\u00106\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00069"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity;", "Lsite/siredvin/peripheralium/common/blockentities/MutableNBTBlockEntity;", "Lsite/siredvin/peripheralworks/computercraft/peripherals/PeripheralProxyPeripheral;", "Lsite/siredvin/peripheralium/api/blockentities/IObservingBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "itemStackCacheBuilt", "", "getItemStackCacheBuilt", "()Z", "setItemStackCacheBuilt", "(Z)V", "lastConsumedEventID", "", "listenerConnectionIncomplete", "peripheralConnectionIncomplete", "remotePeripherals", "", "Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity$RemotePeripheralRecord;", "getRemotePeripherals", "()Ljava/util/Map;", "addPosToTrack", "", "pos", "direction", "Lnet/minecraft/core/Direction;", "targetPeripheral", "Ldan200/computercraft/api/peripheral/IPeripheral;", "buildPeripheralName", "", "connectBlockPos", "level", "Lnet/minecraft/world/level/Level;", "record", "containsPos", "createPeripheral", "side", "destroy", "handleTick", "state", "isPosApplicable", "loadInternalData", "data", "Lnet/minecraft/nbt/CompoundTag;", "removePosToTrack", "saveInternalData", "setRemoved", "togglePos", "trackRecord", "unload", "untrackRecord", "updateCachedStacks", "Companion", "RemotePeripheralRecord", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nPeripheralProxyBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeripheralProxyBlockEntity.kt\nsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,258:1\n135#2,9:259\n215#2:268\n216#2:270\n144#2:271\n215#2,2:272\n1#3:269\n1855#4,2:274\n1855#4,2:276\n1855#4,2:278\n1747#4,3:280\n1747#4,3:283\n*S KotlinDebug\n*F\n+ 1 PeripheralProxyBlockEntity.kt\nsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity\n*L\n78#1:259,9\n78#1:268\n78#1:270\n78#1:271\n155#1:272,2\n78#1:269\n179#1:274,2\n194#1:276,2\n214#1:278,2\n219#1:280,3\n220#1:283,3\n*E\n"})
public final class PeripheralProxyBlockEntity
extends MutableNBTBlockEntity<PeripheralProxyPeripheral>
implements IObservingBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<BlockPos, RemotePeripheralRecord> remotePeripherals;
    private long lastConsumedEventID;
    private boolean peripheralConnectionIncomplete;
    private boolean listenerConnectionIncomplete;
    private boolean itemStackCacheBuilt;
    @NotNull
    public static final String REMOTE_PERIPHERALS_TAG = "remotePeripherals";
    @NotNull
    public static final String TARGET_BLOCK_TAG = "targetBlock";
    @NotNull
    public static final String DIRECTION_TAG = "direction";

    public PeripheralProxyBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        BlockEntityType<PeripheralProxyBlockEntity> blockEntityType = BlockEntityTypes.INSTANCE.getPERIPHERAL_PROXY().get();
        Intrinsics.checkNotNullExpressionValue(blockEntityType, (String)"BlockEntityTypes.PERIPHERAL_PROXY.get()");
        super(blockEntityType, blockPos, blockState);
        this.remotePeripherals = new LinkedHashMap();
        this.lastConsumedEventID = BlockStateUpdateEventBus.INSTANCE.getLastEventID() - 1L;
    }

    @NotNull
    public final Map<BlockPos, RemotePeripheralRecord> getRemotePeripherals() {
        return this.remotePeripherals;
    }

    public final boolean getItemStackCacheBuilt() {
        return this.itemStackCacheBuilt;
    }

    public final void setItemStackCacheBuilt(boolean bl) {
        this.itemStackCacheBuilt = bl;
    }

    @NotNull
    protected PeripheralProxyPeripheral createPeripheral(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return new PeripheralProxyPeripheral(this);
    }

    public final boolean isPosApplicable(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (Intrinsics.areEqual((Object)pos, (Object)this.m_58899_())) {
            return false;
        }
        return pos.m_123314_((Vec3i)this.m_58899_(), (double)PeripheralWorksConfig.INSTANCE.getPeripheralProxyMaxRange());
    }

    public final boolean containsPos(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.remotePeripherals.containsKey(pos);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildPeripheralName(@NotNull IPeripheral targetPeripheral) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)targetPeripheral, (String)"targetPeripheral");
        String naiveName = targetPeripheral.getType();
        Map<BlockPos, RemotePeripheralRecord> $this$mapNotNull$iv = this.remotePeripherals;
        boolean $i$f$mapNotNull = false;
        Map<BlockPos, RemotePeripheralRecord> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Integer n;
            boolean bl;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry it = element$iv$iv;
            boolean bl3 = false;
            String string = ((RemotePeripheralRecord)it.getValue()).getPeripheralName();
            if (string != null) {
                Intrinsics.checkNotNullExpressionValue((Object)naiveName, (String)"naiveName");
                bl = StringsKt.startsWith$default((String)string, (String)naiveName, (boolean)false, (int)2, null);
            } else {
                bl = false;
            }
            if (bl) {
                String string2 = ((RemotePeripheralRecord)it.getValue()).getPeripheralName();
                Intrinsics.checkNotNull((Object)string2);
                String[] stringArray = new String[]{"_"};
                n = Integer.parseInt((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
            } else {
                n = null;
            }
            if (n == null) continue;
            Integer it$iv$iv = n;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        int maxNumber = n != null ? n : -1;
        return naiveName + "_" + (maxNumber + 1);
    }

    public final boolean togglePos(@NotNull BlockPos pos, @NotNull Direction direction, @NotNull IPeripheral targetPeripheral) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)DIRECTION_TAG);
        Intrinsics.checkNotNullParameter((Object)targetPeripheral, (String)"targetPeripheral");
        if (this.remotePeripherals.containsKey(pos)) {
            this.removePosToTrack(pos);
            bl = false;
        } else {
            this.addPosToTrack(pos, direction, targetPeripheral);
            bl = true;
        }
        boolean blockAdded = bl;
        ISyncingBlockEntity.DefaultImpls.pushInternalDataChangeToClient$default((ISyncingBlockEntity)((ISyncingBlockEntity)this), null, (int)1, null);
        return blockAdded;
    }

    private final void trackRecord(RemotePeripheralRecord record, IPeripheral targetPeripheral) {
        if (!record.getConnectedToListener()) {
            BlockPos[] blockPosArray = new BlockPos[]{record.getTargetBlock()};
            BlockStateUpdateEventBus.INSTANCE.addBlockPos(blockPosArray);
            record.setConnectedToListener(true);
        }
        if (this.getPeripheral() != null) {
            if (record.getPeripheralName() == null) {
                record.setPeripheralName(this.buildPeripheralName(targetPeripheral));
            }
            IOwnedPeripheral iOwnedPeripheral = this.getPeripheral();
            Intrinsics.checkNotNull((Object)iOwnedPeripheral);
            PeripheralProxyPeripheral peripheralProxyPeripheral = (PeripheralProxyPeripheral)iOwnedPeripheral;
            String string = record.getPeripheralName();
            Intrinsics.checkNotNull((Object)string);
            peripheralProxyPeripheral.attachRemotePeripheral(targetPeripheral, string);
            record.setConnectedToPeripheral(true);
        } else if (!record.getConnectedToPeripheral()) {
            this.peripheralConnectionIncomplete = true;
        }
        if (this.f_58857_ != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (level.f_46443_ && record.getStack().m_41619_()) {
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                ItemStack itemStack = level2.m_8055_(record.getTargetBlock()).m_60734_().m_5456_().m_7968_();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"level!!.getBlockState(re\u2026.asItem().defaultInstance");
                record.setStack(itemStack);
            }
        }
    }

    private final void untrackRecord(RemotePeripheralRecord record) {
        block1: {
            BlockPos[] blockPosArray = new BlockPos[]{record.getTargetBlock()};
            BlockStateUpdateEventBus.INSTANCE.removeBlockPos(blockPosArray);
            if (record.getPeripheralName() == null) break block1;
            PeripheralProxyPeripheral peripheralProxyPeripheral = (PeripheralProxyPeripheral)this.getPeripheral();
            if (peripheralProxyPeripheral != null) {
                String string = record.getPeripheralName();
                Intrinsics.checkNotNull((Object)string);
                peripheralProxyPeripheral.removeRemotePeripheral(string);
            }
        }
    }

    public final void addPosToTrack(@NotNull BlockPos pos, @NotNull Direction direction, @NotNull IPeripheral targetPeripheral) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)DIRECTION_TAG);
        Intrinsics.checkNotNullParameter((Object)targetPeripheral, (String)"targetPeripheral");
        RemotePeripheralRecord record = new RemotePeripheralRecord(pos, this.buildPeripheralName(targetPeripheral), direction, false, false, null, 56, null);
        this.remotePeripherals.put(pos, record);
        this.trackRecord(record, targetPeripheral);
    }

    public final boolean removePosToTrack(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.remotePeripherals.containsKey(pos)) {
            RemotePeripheralRecord remotePeripheralRecord = this.remotePeripherals.get(pos);
            Intrinsics.checkNotNull((Object)remotePeripheralRecord);
            RemotePeripheralRecord remoteRecord = remotePeripheralRecord;
            this.remotePeripherals.remove(pos);
            this.untrackRecord(remoteRecord);
            return true;
        }
        return false;
    }

    private final void unload() {
        PeripheralProxyPeripheral peripheralProxyPeripheral = (PeripheralProxyPeripheral)this.getPeripheral();
        if (peripheralProxyPeripheral != null) {
            peripheralProxyPeripheral.purgePeripheral();
        }
        BlockStateUpdateEventBus.INSTANCE.removeBlockPos((Collection<? extends BlockPos>)this.remotePeripherals.keySet());
    }

    @NotNull
    public CompoundTag saveInternalData(@NotNull CompoundTag data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ListTag trackedBlockTag = new ListTag();
        Map<BlockPos, RemotePeripheralRecord> $this$forEach$iv = this.remotePeripherals;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<BlockPos, RemotePeripheralRecord>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, RemotePeripheralRecord> element$iv;
            Map.Entry<BlockPos, RemotePeripheralRecord> it = element$iv = iterator.next();
            boolean bl = false;
            trackedBlockTag.add((Object)it.getValue().toTag());
        }
        data.m_128365_(REMOTE_PERIPHERALS_TAG, (Tag)trackedBlockTag);
        return data;
    }

    public final void connectBlockPos(@NotNull Level level, @NotNull RemotePeripheralRecord record) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        IPeripheral targetPeripheral = PeripheraliumPlatform.Companion.getPeripheral(level, record.getTargetBlock(), Direction.NORTH);
        if (targetPeripheral == null) {
            PeripheralWorksCore.INSTANCE.getLOGGER().debug("Postpone {} for peripheral proxing, it doesn't contains any peripheral for now", (Object)record.getTargetBlock());
            this.peripheralConnectionIncomplete = true;
        } else {
            this.trackRecord(record, targetPeripheral);
            ISyncingBlockEntity.DefaultImpls.pushInternalDataChangeToClient$default((ISyncingBlockEntity)((ISyncingBlockEntity)this), null, (int)1, null);
        }
    }

    public final void updateCachedStacks(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (level.f_46443_) {
            this.itemStackCacheBuilt = true;
            Iterable $this$forEach$iv = this.remotePeripherals.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RemotePeripheralRecord it = (RemotePeripheralRecord)element$iv;
                boolean bl = false;
                if (!it.getStack().m_41619_()) continue;
                ItemStack itemStack = level.m_8055_(it.getTargetBlock()).m_60734_().m_5456_().m_7968_();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"level.getBlockState(it.t\u2026.asItem().defaultInstance");
                it.setStack(itemStack);
                if (!it.getStack().m_41619_()) continue;
                this.itemStackCacheBuilt = false;
            }
        }
    }

    @NotNull
    public BlockState loadInternalData(@NotNull CompoundTag data, @Nullable BlockState state) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.m_128441_(REMOTE_PERIPHERALS_TAG)) {
            this.remotePeripherals.clear();
            ListTag internalList = data.m_128437_(REMOTE_PERIPHERALS_TAG, 10);
            Intrinsics.checkNotNullExpressionValue((Object)internalList, (String)"internalList");
            Iterable $this$forEach$iv = (Iterable)internalList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tag it = (Tag)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                RemotePeripheralRecord record = Companion.fromTag((CompoundTag)it);
                this.remotePeripherals.put(record.getTargetBlock(), record);
                if (this.f_58857_ == null) {
                    this.peripheralConnectionIncomplete = true;
                    this.listenerConnectionIncomplete = true;
                    PeripheralWorksCore.INSTANCE.getLOGGER().debug("Postpone of loading blockPos {}", (Object)this.m_58899_());
                    continue;
                }
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                this.connectBlockPos(level, record);
            }
            Level level = this.f_58857_;
            boolean bl = level != null ? level.f_46443_ : false;
            if (bl) {
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                this.updateCachedStacks(level2);
            }
        }
        if ((blockState = state) == null) {
            BlockState blockState2 = this.m_58900_();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"blockState");
        }
        return blockState;
    }

    public void handleTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.listenerConnectionIncomplete || this.peripheralConnectionIncomplete) {
            boolean bl;
            boolean bl2;
            block10: {
                boolean bl3;
                Iterable $this$any$iv;
                boolean $i$f$any;
                PeripheralProxyBlockEntity peripheralProxyBlockEntity;
                RemotePeripheralRecord it;
                block9: {
                    Iterable $this$forEach$iv = this.remotePeripherals.values();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (RemotePeripheralRecord)element$iv;
                        boolean bl4 = false;
                        if (it.getConnectedToListener() && it.getConnectedToPeripheral()) continue;
                        this.connectBlockPos(level, it);
                    }
                    $this$forEach$iv = this.remotePeripherals.values();
                    peripheralProxyBlockEntity = this;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (RemotePeripheralRecord)element$iv;
                            boolean bl5 = false;
                            if (!(!it.getConnectedToListener())) continue;
                            bl3 = true;
                            break block9;
                        }
                        bl3 = false;
                    }
                }
                peripheralProxyBlockEntity.listenerConnectionIncomplete = bl2 = bl3;
                $this$any$iv = this.remotePeripherals.values();
                peripheralProxyBlockEntity = this;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (RemotePeripheralRecord)element$iv;
                        boolean bl6 = false;
                        if (!(!it.getConnectedToPeripheral())) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            peripheralProxyBlockEntity.peripheralConnectionIncomplete = bl2 = bl;
        }
        Ref.BooleanRef dataModified = new Ref.BooleanRef();
        this.lastConsumedEventID = BlockStateUpdateEventBus.INSTANCE.traverseEvents(this.lastConsumedEventID, arg_0 -> PeripheralProxyBlockEntity.handleTick$lambda$7(this, level, dataModified, arg_0));
        if (dataModified.element) {
            PeripheralWorksCore.INSTANCE.getLOGGER().warn("Pushing information after removing some tracked position");
            PeripheralWorksCore.INSTANCE.getLOGGER().warn(String.valueOf(this.remotePeripherals));
            ISyncingBlockEntity.DefaultImpls.pushInternalDataChangeToClient$default((ISyncingBlockEntity)((ISyncingBlockEntity)this), null, (int)1, null);
        }
    }

    public void m_7651_() {
        this.unload();
        super.m_7651_();
    }

    public void destroy() {
        this.unload();
    }

    public void blockTick() {
        IObservingBlockEntity.DefaultImpls.blockTick((IObservingBlockEntity)this);
    }

    public void onNeighbourChange(@NotNull BlockPos neighbour) {
        IObservingBlockEntity.DefaultImpls.onNeighbourChange((IObservingBlockEntity)this, (BlockPos)neighbour);
    }

    public void placed() {
        IObservingBlockEntity.DefaultImpls.placed((IObservingBlockEntity)this);
    }

    public void setPlacedBy(@Nullable LivingEntity entity, @NotNull ItemStack stack) {
        IObservingBlockEntity.DefaultImpls.setPlacedBy((IObservingBlockEntity)this, (LivingEntity)entity, (ItemStack)stack);
    }

    private static final void handleTick$lambda$7(PeripheralProxyBlockEntity this$0, Level $level, Ref.BooleanRef $dataModified, BlockStateUpdateEventBus.BlockStateUpdateEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$dataModified, (String)"$dataModified");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PeripheralWorksCore.INSTANCE.getLOGGER().debug("Processing event change {} {}", (Object)it, (Object)it.getPos());
        if (this$0.remotePeripherals.containsKey(it.getPos())) {
            RemotePeripheralRecord record = this$0.remotePeripherals.get(it.getPos());
            PeripheralWorksCore.INSTANCE.getLOGGER().debug("Extracted record {} for {}", (Object)record, (Object)it.getPos());
            if (record != null) {
                this$0.untrackRecord(record);
                IPeripheral targetPeripheral = PeripheraliumPlatform.Companion.getPeripheral($level, it.getPos(), record.getDirection());
                if (targetPeripheral == null) {
                    PeripheralWorksCore.INSTANCE.getLOGGER().debug("Cannot find peripheral for {} purging it completely", (Object)it.getPos());
                    $dataModified.element = true;
                    this$0.remotePeripherals.remove(it.getPos());
                } else {
                    PeripheralWorksCore.INSTANCE.getLOGGER().debug("Find peripheral {} for {}", (Object)targetPeripheral, (Object)it.getPos());
                    this$0.trackRecord(record, targetPeripheral);
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity$Companion;", "", "()V", "DIRECTION_TAG", "", "REMOTE_PERIPHERALS_TAG", "TARGET_BLOCK_TAG", "fromTag", "Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity$RemotePeripheralRecord;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemotePeripheralRecord fromTag(@NotNull CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            BlockPos targetBlock = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(PeripheralProxyBlockEntity.TARGET_BLOCK_TAG));
            Direction direction = (Direction)Direction.f_175356_.m_262792_(tag.m_128461_(PeripheralProxyBlockEntity.DIRECTION_TAG), (Enum)Direction.NORTH);
            Intrinsics.checkNotNullExpressionValue((Object)targetBlock, (String)PeripheralProxyBlockEntity.TARGET_BLOCK_TAG);
            Intrinsics.checkNotNullExpressionValue((Object)direction, (String)PeripheralProxyBlockEntity.DIRECTION_TAG);
            return new RemotePeripheralRecord(targetBlock, null, direction, false, false, null, 56, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J\t\u0010%\u001a\u00020\fH\u00c6\u0003JG\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010'\u001a\u00020\t2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010,\u001a\u00020-R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity$RemotePeripheralRecord;", "", "targetBlock", "Lnet/minecraft/core/BlockPos;", "peripheralName", "", "direction", "Lnet/minecraft/core/Direction;", "connectedToListener", "", "connectedToPeripheral", "stack", "Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/core/BlockPos;Ljava/lang/String;Lnet/minecraft/core/Direction;ZZLnet/minecraft/world/item/ItemStack;)V", "getConnectedToListener", "()Z", "setConnectedToListener", "(Z)V", "getConnectedToPeripheral", "setConnectedToPeripheral", "getDirection", "()Lnet/minecraft/core/Direction;", "getPeripheralName", "()Ljava/lang/String;", "setPeripheralName", "(Ljava/lang/String;)V", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "setStack", "(Lnet/minecraft/world/item/ItemStack;)V", "getTargetBlock", "()Lnet/minecraft/core/BlockPos;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "toTag", "Lnet/minecraft/nbt/CompoundTag;", "peripheralworks-forge-1.20.1"})
    public static final class RemotePeripheralRecord {
        @NotNull
        private final BlockPos targetBlock;
        @Nullable
        private String peripheralName;
        @NotNull
        private final Direction direction;
        private boolean connectedToListener;
        private boolean connectedToPeripheral;
        @NotNull
        private ItemStack stack;

        public RemotePeripheralRecord(@NotNull BlockPos targetBlock, @Nullable String peripheralName, @NotNull Direction direction, boolean connectedToListener, boolean connectedToPeripheral, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)targetBlock, (String)PeripheralProxyBlockEntity.TARGET_BLOCK_TAG);
            Intrinsics.checkNotNullParameter((Object)direction, (String)PeripheralProxyBlockEntity.DIRECTION_TAG);
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this.targetBlock = targetBlock;
            this.peripheralName = peripheralName;
            this.direction = direction;
            this.connectedToListener = connectedToListener;
            this.connectedToPeripheral = connectedToPeripheral;
            this.stack = stack;
        }

        public /* synthetic */ RemotePeripheralRecord(BlockPos blockPos, String string, Direction direction, boolean bl, boolean bl2, ItemStack itemStack, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            if ((n & 0x20) != 0) {
                ItemStack itemStack2 = ItemStack.f_41583_;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
                itemStack = itemStack2;
            }
            this(blockPos, string, direction, bl, bl2, itemStack);
        }

        @NotNull
        public final BlockPos getTargetBlock() {
            return this.targetBlock;
        }

        @Nullable
        public final String getPeripheralName() {
            return this.peripheralName;
        }

        public final void setPeripheralName(@Nullable String string) {
            this.peripheralName = string;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public final boolean getConnectedToListener() {
            return this.connectedToListener;
        }

        public final void setConnectedToListener(boolean bl) {
            this.connectedToListener = bl;
        }

        public final boolean getConnectedToPeripheral() {
            return this.connectedToPeripheral;
        }

        public final void setConnectedToPeripheral(boolean bl) {
            this.connectedToPeripheral = bl;
        }

        @NotNull
        public final ItemStack getStack() {
            return this.stack;
        }

        public final void setStack(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
            this.stack = itemStack;
        }

        @NotNull
        public final CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_(PeripheralProxyBlockEntity.TARGET_BLOCK_TAG, (Tag)NbtUtils.m_129224_((BlockPos)this.targetBlock));
            tag.m_128359_(PeripheralProxyBlockEntity.DIRECTION_TAG, this.direction.m_7912_());
            return tag;
        }

        @NotNull
        public final BlockPos component1() {
            return this.targetBlock;
        }

        @Nullable
        public final String component2() {
            return this.peripheralName;
        }

        @NotNull
        public final Direction component3() {
            return this.direction;
        }

        public final boolean component4() {
            return this.connectedToListener;
        }

        public final boolean component5() {
            return this.connectedToPeripheral;
        }

        @NotNull
        public final ItemStack component6() {
            return this.stack;
        }

        @NotNull
        public final RemotePeripheralRecord copy(@NotNull BlockPos targetBlock, @Nullable String peripheralName, @NotNull Direction direction, boolean connectedToListener, boolean connectedToPeripheral, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)targetBlock, (String)PeripheralProxyBlockEntity.TARGET_BLOCK_TAG);
            Intrinsics.checkNotNullParameter((Object)direction, (String)PeripheralProxyBlockEntity.DIRECTION_TAG);
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return new RemotePeripheralRecord(targetBlock, peripheralName, direction, connectedToListener, connectedToPeripheral, stack);
        }

        public static /* synthetic */ RemotePeripheralRecord copy$default(RemotePeripheralRecord remotePeripheralRecord, BlockPos blockPos, String string, Direction direction, boolean bl, boolean bl2, ItemStack itemStack, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = remotePeripheralRecord.targetBlock;
            }
            if ((n & 2) != 0) {
                string = remotePeripheralRecord.peripheralName;
            }
            if ((n & 4) != 0) {
                direction = remotePeripheralRecord.direction;
            }
            if ((n & 8) != 0) {
                bl = remotePeripheralRecord.connectedToListener;
            }
            if ((n & 0x10) != 0) {
                bl2 = remotePeripheralRecord.connectedToPeripheral;
            }
            if ((n & 0x20) != 0) {
                itemStack = remotePeripheralRecord.stack;
            }
            return remotePeripheralRecord.copy(blockPos, string, direction, bl, bl2, itemStack);
        }

        @NotNull
        public String toString() {
            return "RemotePeripheralRecord(targetBlock=" + this.targetBlock + ", peripheralName=" + this.peripheralName + ", direction=" + this.direction + ", connectedToListener=" + this.connectedToListener + ", connectedToPeripheral=" + this.connectedToPeripheral + ", stack=" + this.stack + ")";
        }

        public int hashCode() {
            int result = this.targetBlock.hashCode();
            result = result * 31 + (this.peripheralName == null ? 0 : this.peripheralName.hashCode());
            result = result * 31 + this.direction.hashCode();
            int n = this.connectedToListener ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.connectedToPeripheral ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            result = result * 31 + this.stack.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemotePeripheralRecord)) {
                return false;
            }
            RemotePeripheralRecord remotePeripheralRecord = (RemotePeripheralRecord)other;
            if (!Intrinsics.areEqual((Object)this.targetBlock, (Object)remotePeripheralRecord.targetBlock)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.peripheralName, (Object)remotePeripheralRecord.peripheralName)) {
                return false;
            }
            if (this.direction != remotePeripheralRecord.direction) {
                return false;
            }
            if (this.connectedToListener != remotePeripheralRecord.connectedToListener) {
                return false;
            }
            if (this.connectedToPeripheral != remotePeripheralRecord.connectedToPeripheral) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stack, (Object)remotePeripheralRecord.stack);
        }
    }
}

