/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.util.world;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.ext.BlockPosExtKt;
import site.siredvin.peripheralium.storages.ContainerUtils;
import site.siredvin.peripheralium.util.Pair;
import site.siredvin.peripheralium.util.world.DropConsumer;
import site.siredvin.peripheralium.util.world.FakePlayerProxy;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!J\u001c\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\n2\b\u0010&\u001a\u0004\u0018\u00010\fH\u0002J2\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!J\u001a\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020)0(2\u0006\u0010+\u001a\u00020,J\u001a\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020)0(2\u0006\u0010+\u001a\u00020.J\u0016\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ&\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!J\u0016\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020\u001cJ'\u00104\u001a\u0002H5\"\u0004\b\u0000\u001052\u0006\u00102\u001a\u00020\"2\f\u00106\u001a\b\u0012\u0004\u0012\u0002H507\u00a2\u0006\u0002\u00108J/\u00104\u001a\u0002H5\"\u0004\b\u0000\u001052\u0006\u0010\u0017\u001a\u0002092\u0006\u0010&\u001a\u00020\f2\f\u00106\u001a\b\u0012\u0004\u0012\u0002H507\u00a2\u0006\u0002\u0010:R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lsite/siredvin/peripheralium/util/world/FakePlayerProxy;", "", "fakePlayer", "Lnet/minecraft/server/level/ServerPlayer;", "range", "", "(Lnet/minecraft/server/level/ServerPlayer;I)V", "currentDamage", "", "digBlock", "Lnet/minecraft/world/level/block/Block;", "digPosition", "Lnet/minecraft/core/BlockPos;", "getFakePlayer", "()Lnet/minecraft/server/level/ServerPlayer;", "gameMode", "Lnet/minecraft/server/level/ServerPlayerGameMode;", "getGameMode", "()Lnet/minecraft/server/level/ServerPlayerGameMode;", "inventory", "Lnet/minecraft/world/Container;", "getInventory", "()Lnet/minecraft/world/Container;", "level", "Lnet/minecraft/server/level/ServerLevel;", "getLevel", "()Lnet/minecraft/server/level/ServerLevel;", "findHit", "Lnet/minecraft/world/phys/HitResult;", "skipEntity", "", "skipBlock", "entityFilter", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/entity/Entity;", "setState", "", "block", "pos", "swing", "Lsite/siredvin/peripheralium/util/Pair;", "", "swingBlock", "hit", "Lnet/minecraft/world/phys/BlockHitResult;", "swingEntity", "Lnet/minecraft/world/phys/EntityHitResult;", "use", "Lnet/minecraft/world/InteractionResult;", "useOnSpecificEntity", "entity", "result", "withConsumer", "T", "func", "Lkotlin/Function0;", "(Lnet/minecraft/world/entity/Entity;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lnet/minecraft/world/level/Level;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "peripheralium-forge-1.20.1"})
public final class FakePlayerProxy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerPlayer fakePlayer;
    private final int range;
    @Nullable
    private BlockPos digPosition;
    @Nullable
    private Block digBlock;
    private float currentDamage;
    @NotNull
    private static final GameProfile DUMMY_PROFILE = new GameProfile(UUID.fromString("6e483f02-30db-4454-b612-3a167614b276"), "[peripheralium]");
    private static final Predicate<Entity> collidablePredicate = EntitySelector.f_20408_;

    public FakePlayerProxy(@NotNull ServerPlayer fakePlayer, int range) {
        Intrinsics.checkNotNullParameter((Object)fakePlayer, (String)"fakePlayer");
        this.fakePlayer = fakePlayer;
        this.range = range;
    }

    public /* synthetic */ FakePlayerProxy(ServerPlayer serverPlayer, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 4;
        }
        this(serverPlayer, n);
    }

    @NotNull
    public final ServerPlayer getFakePlayer() {
        return this.fakePlayer;
    }

    private final ServerLevel getLevel() {
        ServerLevel serverLevel = this.fakePlayer.m_284548_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"fakePlayer.serverLevel()");
        return serverLevel;
    }

    private final ServerPlayerGameMode getGameMode() {
        ServerPlayerGameMode serverPlayerGameMode = this.fakePlayer.f_8941_;
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayerGameMode, (String)"fakePlayer.gameMode");
        return serverPlayerGameMode;
    }

    private final Container getInventory() {
        Inventory inventory = this.fakePlayer.m_150109_();
        Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"fakePlayer.inventory");
        return (Container)inventory;
    }

    private final void setState(Block block, BlockPos pos) {
        if (this.digPosition != null) {
            ServerPlayerGameMode serverPlayerGameMode = this.getGameMode();
            BlockPos blockPos = this.digPosition;
            Intrinsics.checkNotNull((Object)blockPos);
            serverPlayerGameMode.m_214168_(blockPos, ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, Direction.EAST, 1, 1);
        }
        this.digPosition = pos;
        this.digBlock = block;
        this.currentDamage = 0.0f;
    }

    public final <T> T withConsumer(@NotNull Entity entity, @NotNull Function0<? extends T> func) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        DropConsumer.configure$default(DropConsumer.INSTANCE, entity, (Function1)new Function1<ItemStack, ItemStack>(this){
            final /* synthetic */ FakePlayerProxy this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ItemStack invoke(@NotNull ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return ContainerUtils.storeItem$default(ContainerUtils.INSTANCE, FakePlayerProxy.access$getInventory(this.this$0), stack, 0, 0, 12, null);
            }
        }, 0.0, 4, null);
        Object result = func.invoke();
        Level level = (Level)this.getLevel();
        BlockPos blockPos = this.fakePlayer.m_20183_().m_7494_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"fakePlayer.blockPosition().above()");
        DropConsumer.INSTANCE.resetAndDrop(level, blockPos);
        return (T)result;
    }

    public final <T> T withConsumer(@NotNull Level level, @NotNull BlockPos pos, @NotNull Function0<? extends T> func) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        DropConsumer.configure$default(DropConsumer.INSTANCE, level, pos, (Function1)new Function1<ItemStack, ItemStack>(this){
            final /* synthetic */ FakePlayerProxy this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ItemStack invoke(@NotNull ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return ContainerUtils.storeItem$default(ContainerUtils.INSTANCE, FakePlayerProxy.access$getInventory(this.this$0), stack, 0, 0, 12, null);
            }
        }, 0.0, 8, null);
        Object result = func.invoke();
        BlockPos blockPos = this.fakePlayer.m_20183_().m_7494_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"fakePlayer.blockPosition().above()");
        DropConsumer.INSTANCE.resetAndDrop(level, blockPos);
        return (T)result;
    }

    @NotNull
    public final HitResult findHit(boolean skipEntity, boolean skipBlock) {
        return this.findHit(skipEntity, skipBlock, null);
    }

    @NotNull
    public final HitResult findHit(boolean skipEntity, boolean skipBlock, @Nullable Predicate<Entity> entityFilter) {
        HitResult hitResult;
        HitResult blockHit;
        Vec3 origin = new Vec3(this.fakePlayer.m_20185_(), this.fakePlayer.m_20186_(), this.fakePlayer.m_20189_());
        Vec3 look = this.fakePlayer.m_20154_();
        Vec3 target = new Vec3(origin.f_82479_ + look.f_82479_ * (double)this.range, origin.f_82480_ + look.f_82480_ * (double)this.range, origin.f_82481_ + look.f_82481_ * (double)this.range);
        ClipContext traceContext = new ClipContext(origin, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.fakePlayer);
        Vec3 directionVec = traceContext.m_45702_().m_82546_(traceContext.m_45693_());
        Direction traceDirection = Direction.m_122366_((double)directionVec.f_82479_, (double)directionVec.f_82480_, (double)directionVec.f_82481_);
        if (skipBlock) {
            Vec3 vec3 = traceContext.m_45693_();
            Vec3 vec32 = traceContext.m_45693_();
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"traceContext.to");
            BlockHitResult blockHitResult = BlockHitResult.m_82426_((Vec3)vec3, (Direction)traceDirection, (BlockPos)BlockPosExtKt.toBlockPos(vec32));
            Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"{\n            BlockHitRe\u2026o.toBlockPos())\n        }");
            v2 = (HitResult)blockHitResult;
        } else {
            Object object = BlockGetter.m_151361_((Vec3)traceContext.m_45702_(), (Vec3)traceContext.m_45693_(), (Object)traceContext, (arg_0, arg_1) -> FakePlayerProxy.findHit$lambda$0(this, traceDirection, arg_0, arg_1), arg_0 -> FakePlayerProxy.findHit$lambda$1(traceDirection, arg_0));
            Intrinsics.checkNotNull((Object)object);
            v2 = blockHit = (HitResult)object;
        }
        if (skipEntity) {
            return blockHit;
        }
        List entities = this.getLevel().m_6249_((Entity)this.fakePlayer, this.fakePlayer.m_20191_().m_82363_(look.f_82479_ * (double)this.range, look.f_82480_ * (double)this.range, look.f_82481_ * (double)this.range).m_82377_(1.0, 1.0, 1.0), collidablePredicate);
        LivingEntity closestEntity = null;
        Vec3 closestVec = null;
        double closestDistance = 0.0;
        for (Entity entityHit : entities) {
            if (!(entityHit instanceof LivingEntity) || entityFilter != null && !entityFilter.test(entityHit)) continue;
            AABB box = entityHit.m_20191_().m_82400_((double)entityHit.m_6143_() + 0.5);
            Optional clipResult = box.m_82371_(origin, target);
            if (box.m_82390_(origin)) {
                if (!(closestDistance >= 0.0)) continue;
                closestEntity = (LivingEntity)entityHit;
                closestVec = clipResult.orElse(origin);
                closestDistance = 0.0;
                continue;
            }
            if (!clipResult.isPresent()) continue;
            Object t = clipResult.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"clipResult.get()");
            Vec3 clipVec = (Vec3)t;
            double distance = origin.m_82554_(clipVec);
            if (!(distance < closestDistance) && !(closestDistance == 0.0)) continue;
            if (entityHit == entityHit.m_20201_()) {
                if (!(closestDistance == 0.0)) continue;
                closestEntity = (LivingEntity)entityHit;
                closestVec = clipVec;
                continue;
            }
            closestEntity = (LivingEntity)entityHit;
            closestVec = clipVec;
            closestDistance = distance;
        }
        if (closestEntity != null && closestDistance <= (double)this.range && (blockHit.m_6662_() == HitResult.Type.MISS || this.fakePlayer.m_20238_(blockHit.m_82450_()) > closestDistance * closestDistance)) {
            Entity entity = (Entity)closestEntity;
            Vec3 vec3 = closestVec;
            Intrinsics.checkNotNull(vec3);
            hitResult = (HitResult)new EntityHitResult(entity, vec3);
        } else {
            hitResult = blockHit;
        }
        return hitResult;
    }

    @NotNull
    public final InteractionResult useOnSpecificEntity(@NotNull Entity entity, @NotNull HitResult result) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return PeripheraliumPlatform.Companion.interactWithEntity(this.fakePlayer, InteractionHand.MAIN_HAND, entity, (EntityHitResult)result);
    }

    @NotNull
    public final InteractionResult use(boolean skipEntity, boolean skipBlock, @Nullable Predicate<Entity> entityFilter) {
        HitResult hit = this.findHit(skipEntity, skipBlock, entityFilter);
        if (hit instanceof BlockHitResult) {
            Level level = (Level)this.getLevel();
            BlockPos blockPos = ((BlockHitResult)hit).m_82425_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"hit.blockPos");
            return (InteractionResult)this.withConsumer(level, blockPos, (Function0)new Function0<InteractionResult>(this, hit){
                final /* synthetic */ FakePlayerProxy this$0;
                final /* synthetic */ HitResult $hit;
                {
                    this.this$0 = $receiver;
                    this.$hit = $hit;
                    super(0);
                }

                @NotNull
                public final InteractionResult invoke() {
                    if (this.this$0.getFakePlayer().m_20089_() != Pose.CROUCHING) {
                        ServerPlayer serverPlayer = this.this$0.getFakePlayer();
                        ItemStack itemStack = this.this$0.getFakePlayer().m_21205_();
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"fakePlayer.mainHandItem");
                        InteractionResult useOnResult = PeripheraliumPlatform.Companion.useOn(serverPlayer, itemStack, (BlockHitResult)this.$hit, use.1::invoke$lambda$0);
                        if (useOnResult.m_19077_()) {
                            return useOnResult;
                        }
                    }
                    FakePlayerProxy.access$getLevel(this.this$0).m_6801_(this.this$0.getFakePlayer().m_19879_(), ((BlockHitResult)this.$hit).m_82425_(), -1);
                    InteractionResult useItemResult = FakePlayerProxy.access$getGameMode(this.this$0).m_7179_(this.this$0.getFakePlayer(), (Level)FakePlayerProxy.access$getLevel(this.this$0), this.this$0.getFakePlayer().m_21205_(), InteractionHand.MAIN_HAND, (BlockHitResult)this.$hit);
                    if (useItemResult.m_19077_()) {
                        Intrinsics.checkNotNullExpressionValue((Object)useItemResult, (String)"useItemResult");
                        return useItemResult;
                    }
                    InteractionResult interactionResult = FakePlayerProxy.access$getGameMode(this.this$0).m_6261_(this.this$0.getFakePlayer(), (Level)FakePlayerProxy.access$getLevel(this.this$0), this.this$0.getFakePlayer().m_21205_(), InteractionHand.MAIN_HAND);
                    Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"gameMode.useItem(fakePla\u2026nteractionHand.MAIN_HAND)");
                    return interactionResult;
                }

                private static final boolean invoke$lambda$0(BlockState it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return true;
                }
            });
        }
        if (hit instanceof EntityHitResult) {
            Entity entity = ((EntityHitResult)hit).m_82443_();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"hit.entity");
            return (InteractionResult)this.withConsumer(entity, (Function0)new Function0<InteractionResult>(this, hit){
                final /* synthetic */ FakePlayerProxy this$0;
                final /* synthetic */ HitResult $hit;
                {
                    this.this$0 = $receiver;
                    this.$hit = $hit;
                    super(0);
                }

                @NotNull
                public final InteractionResult invoke() {
                    Entity entity = ((EntityHitResult)this.$hit).m_82443_();
                    Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"hit.entity");
                    return this.this$0.useOnSpecificEntity(entity, this.$hit);
                }
            });
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public final InteractionResult use(boolean skipEntity, boolean skipBlock) {
        return this.use(skipEntity, skipBlock, null);
    }

    @NotNull
    public final Pair<Boolean, String> swing(boolean skipEntity, boolean skipBlock, @Nullable Predicate<Entity> entityFilter) {
        HitResult hit = this.findHit(skipEntity, skipBlock, entityFilter);
        if (hit.m_6662_() == HitResult.Type.MISS) {
            return Pair.Companion.of(false, "Nothing to swing");
        }
        if (hit instanceof BlockHitResult) {
            return this.swingBlock((BlockHitResult)hit);
        }
        if (hit instanceof EntityHitResult) {
            return this.swingEntity((EntityHitResult)hit);
        }
        return Pair.Companion.of(false, "Nothing found");
    }

    @NotNull
    public final Pair<Boolean, String> swingBlock(@NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        BlockPos pos = new BlockPos((int)hit.m_82450_().f_82479_, (int)hit.m_82450_().f_82480_, (int)hit.m_82450_().f_82481_);
        BlockState state = this.getLevel().m_8055_(pos);
        Block block = state.m_60734_();
        ItemStack tool = this.fakePlayer.m_21205_();
        if (!Intrinsics.areEqual((Object)block, (Object)this.digBlock) || !Intrinsics.areEqual((Object)pos, (Object)this.digPosition)) {
            this.setState(block, pos);
        }
        if (!this.getLevel().m_46859_(pos) && !state.m_278721_()) {
            Intrinsics.checkNotNullExpressionValue((Object)state, (String)"state");
            if (PeripheraliumPlatform.Companion.isBlockProtected(pos, state, this.fakePlayer)) {
                return Pair.Companion.of(false, "Cannot break protected block");
            }
            if (Intrinsics.areEqual((Object)block, (Object)Blocks.f_50752_) || state.m_60800_((BlockGetter)this.getLevel(), pos) <= -1.0f) {
                return Pair.Companion.of(false, "Unbreakable block detected");
            }
            float breakSpeed = 0.5f * tool.m_41691_(state) / state.m_60800_((BlockGetter)this.getLevel(), pos) - 0.1f;
            this.currentDamage += (float)9 * breakSpeed;
            this.getLevel().m_6801_(this.fakePlayer.m_19879_(), pos, (int)this.currentDamage);
            if (this.currentDamage > 9.0f) {
                this.withConsumer((Level)this.getLevel(), pos, (Function0)new Function0<Unit>(this, pos, state){
                    final /* synthetic */ FakePlayerProxy this$0;
                    final /* synthetic */ BlockPos $pos;
                    final /* synthetic */ BlockState $state;
                    {
                        this.this$0 = $receiver;
                        this.$pos = $pos;
                        this.$state = $state;
                        super(0);
                    }

                    public final void invoke() {
                        FakePlayerProxy.access$getLevel(this.this$0).m_5594_(null, this.$pos, this.$state.m_60827_().m_56775_(), SoundSource.NEUTRAL, 0.25f, 1.0f);
                        FakePlayerProxy.access$getGameMode(this.this$0).m_214168_(this.$pos, ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, this.this$0.getFakePlayer().m_6350_().m_122424_(), 1, 1);
                        FakePlayerProxy.access$getGameMode(this.this$0).m_9280_(this.$pos);
                        FakePlayerProxy.access$getLevel(this.this$0).m_6801_(this.this$0.getFakePlayer().m_19879_(), this.$pos, -1);
                        FakePlayerProxy.access$setState(this.this$0, null, null);
                    }
                });
            }
            return Pair.Companion.of(true, "");
        }
        return Pair.Companion.of(false, "Nothing to dig here");
    }

    @NotNull
    public final Pair<Boolean, String> swingEntity(@NotNull EntityHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        ItemStack tool = this.fakePlayer.m_21205_();
        if (tool.m_41619_()) {
            return Pair.Companion.of(false, "Cannot swing without tool");
        }
        Entity entity = hit.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return Pair.Companion.of(false, "Incorrect entity hit");
        }
        if (!this.fakePlayer.m_6779_((LivingEntity)entity)) {
            return Pair.Companion.of(false, "Can't swing this entity");
        }
        this.withConsumer(entity, (Function0)new Function0<Unit>(this, entity){
            final /* synthetic */ FakePlayerProxy this$0;
            final /* synthetic */ Entity $entity;
            {
                this.this$0 = $receiver;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.getFakePlayer().m_5706_(this.$entity);
            }
        });
        this.fakePlayer.m_36335_().m_41524_(tool.m_41720_(), 1);
        return Pair.Companion.of(true, "");
    }

    private static final BlockHitResult findHit$lambda$0(FakePlayerProxy this$0, Direction $traceDirection, ClipContext clipContext, BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        if (this$0.getLevel().m_46859_(blockPos)) {
            return null;
        }
        return new BlockHitResult(new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), $traceDirection, blockPos, false);
    }

    private static final BlockHitResult findHit$lambda$1(Direction $traceDirection, ClipContext rayTraceContext) {
        Intrinsics.checkNotNullParameter((Object)rayTraceContext, (String)"rayTraceContext");
        Vec3 vec3 = rayTraceContext.m_45693_();
        Vec3 vec32 = rayTraceContext.m_45693_();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"rayTraceContext.to");
        return BlockHitResult.m_82426_((Vec3)vec3, (Direction)$traceDirection, (BlockPos)BlockPosExtKt.toBlockPos(vec32));
    }

    public static final /* synthetic */ Container access$getInventory(FakePlayerProxy $this) {
        return $this.getInventory();
    }

    public static final /* synthetic */ ServerLevel access$getLevel(FakePlayerProxy $this) {
        return $this.getLevel();
    }

    public static final /* synthetic */ ServerPlayerGameMode access$getGameMode(FakePlayerProxy $this) {
        return $this.getGameMode();
    }

    public static final /* synthetic */ void access$setState(FakePlayerProxy $this, Block block, BlockPos pos) {
        $this.setState(block, pos);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lsite/siredvin/peripheralium/util/world/FakePlayerProxy$Companion;", "", "()V", "DUMMY_PROFILE", "Lcom/mojang/authlib/GameProfile;", "getDUMMY_PROFILE", "()Lcom/mojang/authlib/GameProfile;", "collidablePredicate", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/entity/Entity;", "kotlin.jvm.PlatformType", "peripheralium-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GameProfile getDUMMY_PROFILE() {
            return DUMMY_PROFILE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

