/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.util.world;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0012J4\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000bJ\u0016\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0005J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cJ\u0016\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lsite/siredvin/peripheralium/util/world/DropConsumer;", "", "()V", "consumer", "Lkotlin/Function1;", "Lnet/minecraft/world/item/ItemStack;", "dropBounds", "Lnet/minecraft/world/phys/AABB;", "remainingDrop", "", "targetEntity", "Lnet/minecraft/world/entity/Entity;", "targetLevel", "Lnet/minecraft/world/level/Level;", "configure", "", "entity", "range", "", "level", "pos", "Lnet/minecraft/core/BlockPos;", "consume", "stack", "onEntitySpawn", "", "onLivingDrop", "reset", "", "resetAndDrop", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nDropConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropConsumer.kt\nsite/siredvin/peripheralium/util/world/DropConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1855#2,2:77\n*S KotlinDebug\n*F\n+ 1 DropConsumer.kt\nsite/siredvin/peripheralium/util/world/DropConsumer\n*L\n48#1:77,2\n*E\n"})
public final class DropConsumer {
    @NotNull
    public static final DropConsumer INSTANCE = new DropConsumer();
    @Nullable
    private static Function1<? super ItemStack, ItemStack> consumer;
    @Nullable
    private static List<ItemStack> remainingDrop;
    @Nullable
    private static Level targetLevel;
    @Nullable
    private static Entity targetEntity;
    @Nullable
    private static AABB dropBounds;

    private DropConsumer() {
    }

    public final void configure(@NotNull Level level, @NotNull BlockPos pos, @NotNull Function1<? super ItemStack, ItemStack> consumer, double range) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        remainingDrop = new ArrayList();
        targetLevel = level;
        DropConsumer.consumer = consumer;
        targetEntity = null;
        dropBounds = new AABB(pos).m_82400_(range);
    }

    public static /* synthetic */ void configure$default(DropConsumer dropConsumer, Level level, BlockPos blockPos, Function1 function1, double d, int n, Object object) {
        if ((n & 8) != 0) {
            d = 2.0;
        }
        dropConsumer.configure(level, blockPos, (Function1<? super ItemStack, ItemStack>)function1, d);
    }

    public final void configure(@NotNull Entity entity, @NotNull Function1<? super ItemStack, ItemStack> consumer, double range) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        remainingDrop = new ArrayList();
        targetLevel = entity.m_9236_();
        DropConsumer.consumer = consumer;
        targetEntity = null;
        dropBounds = new AABB(entity.m_20183_()).m_82400_(range);
    }

    public static /* synthetic */ void configure$default(DropConsumer dropConsumer, Entity entity, Function1 function1, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 2.0;
        }
        dropConsumer.configure(entity, (Function1<? super ItemStack, ItemStack>)function1, d);
    }

    @NotNull
    public final List<ItemStack> reset() {
        List<ItemStack> list = remainingDrop;
        if (list == null) {
            throw new IllegalCallerException("Double reset detected");
        }
        List<ItemStack> result = list;
        remainingDrop = null;
        consumer = null;
        targetEntity = null;
        targetLevel = null;
        dropBounds = null;
        return result;
    }

    public final void resetAndDrop(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List<ItemStack> toDrop = this.reset();
        Iterable $this$forEach$iv = toDrop;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)it);
        }
    }

    public final void consume(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Function1<? super ItemStack, ItemStack> function1 = consumer;
        Intrinsics.checkNotNull(function1);
        ItemStack leftStack = (ItemStack)function1.invoke((Object)stack);
        if (!leftStack.m_41619_()) {
            List<ItemStack> list = remainingDrop;
            Intrinsics.checkNotNull(list);
            list.add(leftStack);
        }
    }

    public final boolean onEntitySpawn(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (Intrinsics.areEqual((Object)targetLevel, (Object)entity.m_9236_()) && entity instanceof ItemEntity) {
            AABB aABB = dropBounds;
            Intrinsics.checkNotNull((Object)aABB);
            if (aABB.m_82390_(entity.m_20182_())) {
                ItemStack itemStack = ((ItemEntity)entity).m_32055_();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"entity.item");
                this.consume(itemStack);
                return true;
            }
        }
        return false;
    }

    public final boolean onLivingDrop(@NotNull Entity entity, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!Intrinsics.areEqual((Object)entity, (Object)targetEntity)) {
            return false;
        }
        this.consume(stack);
        return true;
    }
}

