/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.util.representation;

import dan200.computercraft.api.lua.LuaException;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.ext.BlockPosExtKt;
import site.siredvin.peripheralium.util.representation.LuaInterpretation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lsite/siredvin/peripheralium/util/representation/LuaInterpretation;", "", "()V", "asBlockPos", "Lnet/minecraft/core/BlockPos;", "table", "", "center", "facing", "Lnet/minecraft/core/Direction;", "asRotation", "Lnet/minecraft/world/level/block/Rotation;", "rotation", "", "peripheralium-forge-1.20.1"})
public final class LuaInterpretation {
    @NotNull
    public static final LuaInterpretation INSTANCE = new LuaInterpretation();

    private LuaInterpretation() {
    }

    @NotNull
    public final BlockPos asBlockPos(@NotNull Map<?, ?> table) throws LuaException {
        Intrinsics.checkNotNullParameter(table, (String)"table");
        if (!(table.containsKey("x") && table.containsKey("y") && table.containsKey("z"))) {
            throw new LuaException("Table should be block position table");
        }
        Object x = table.get("x");
        Object y = table.get("y");
        Object z = table.get("z");
        if (!(x instanceof Number && y instanceof Number && z instanceof Number)) {
            throw new LuaException("Table should be block position table");
        }
        return new BlockPos(((Number)x).intValue(), ((Number)y).intValue(), ((Number)z).intValue());
    }

    @NotNull
    public final BlockPos asBlockPos(@NotNull BlockPos center, @NotNull Map<?, ?> table) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter(table, (String)"table");
        BlockPos relative = this.asBlockPos(table);
        return new BlockPos(center.m_123341_() + relative.m_123341_(), center.m_123342_() + relative.m_123342_(), center.m_123343_() + relative.m_123343_());
    }

    @NotNull
    public final BlockPos asBlockPos(@NotNull BlockPos center, @NotNull Map<?, ?> table, @NotNull Direction facing) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter(table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        BlockPos blockPos = this.asBlockPos(table);
        Direction direction = facing.m_122424_();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"facing.opposite");
        BlockPos relative = BlockPosExtKt.toRelative(blockPos, direction);
        return new BlockPos(center.m_123341_() + relative.m_123341_(), center.m_123342_() + relative.m_123342_(), center.m_123343_() + relative.m_123343_());
    }

    @NotNull
    public final Rotation asRotation(@NotNull String rotation) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        try {
            String string = rotation.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return Rotation.valueOf((String)string);
        }
        catch (IllegalArgumentException exc) {
            String allValues2 = ArraysKt.joinToString$default((Object[])Rotation.values(), (CharSequence)", ", null, null, (int)0, null, (Function1)asRotation.allValues.1.INSTANCE, (int)30, null);
            throw new LuaException("Rotation should be one of: " + allValues2);
        }
    }
}

