/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.util;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lsite/siredvin/peripheralium/util/TextBookUtils;", "", "()V", "BOOK_MAX_LINES", "", "MAX_WIDTH_PER_LINE", "getBookText", "", "", "book", "Lnet/minecraft/world/item/ItemStack;", "getCharacterWidth", "c", "", "resolvePage", "string", "stripText", "text", "peripheralium-forge-1.20.1"})
public final class TextBookUtils {
    @NotNull
    public static final TextBookUtils INSTANCE = new TextBookUtils();
    private static final int BOOK_MAX_LINES = 14;
    private static final int MAX_WIDTH_PER_LINE = 95;

    private TextBookUtils() {
    }

    private final String resolvePage(String string) {
        Component component = null;
        try {
            component = (Component)Component.Serializer.m_130714_((String)string);
            if (component == null) {
                throw new IllegalArgumentException("Cannot parse it, fallback");
            }
            component = (Component)ComponentUtils.m_130731_(null, (Component)component, null, (int)0);
        }
        catch (Exception var5) {
            component = (Component)Component.m_237115_((String)string);
        }
        Component component2 = component;
        Intrinsics.checkNotNull((Object)component2);
        String string2 = component2.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"component!!.string");
        return string2;
    }

    @NotNull
    public final List<String> getBookText(@NotNull ItemStack book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Item item = book.m_41720_();
        if (Intrinsics.areEqual((Object)item, (Object)Items.f_42614_)) {
            CompoundTag compoundTag = book.m_41783_();
            ListTag listTag = compoundTag != null ? compoundTag.m_128437_("pages", 8) : null;
            if (listTag == null) {
                return CollectionsKt.emptyList();
            }
            ListTag pagesData = listTag;
            List pages = new ArrayList();
            int n = pagesData.size();
            for (int i = 0; i < n; ++i) {
                String string = pagesData.m_128778_(i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pagesData.getString(i)");
                pages.add(string);
            }
            return pages;
        }
        if (Intrinsics.areEqual((Object)item, (Object)Items.f_42615_)) {
            CompoundTag compoundTag = book.m_41783_();
            ListTag listTag = compoundTag != null ? compoundTag.m_128437_("pages", 8) : null;
            if (listTag == null) {
                return CollectionsKt.emptyList();
            }
            ListTag pagesData = listTag;
            List pages = new ArrayList();
            int n = pagesData.size();
            for (int i = 0; i < n; ++i) {
                String string = pagesData.m_128778_(i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pagesData.getString(i)");
                pages.add(this.resolvePage(string));
            }
            return pages;
        }
        return CollectionsKt.emptyList();
    }

    public final int getCharacterWidth(char c) {
        char c2 = c;
        return ((((((((c2 == ' ' ? true : c2 == '!') ? true : c2 == '\'') ? true : c2 == ',') ? true : c2 == '.') ? true : c2 == ':') ? true : c2 == ';') ? true : c2 == 'i') ? true : c2 == '|') ? 1 : ((c2 == '`' ? true : c2 == 'l') ? 2 : ((((((((((c2 == '\"' ? true : c2 == '(') ? true : c2 == ')') ? true : c2 == '*') ? true : c2 == 'I') ? true : c2 == '[') ? true : c2 == ']') ? true : c2 == 't') ? true : c2 == '{') ? true : c2 == '}') ? 3 : ((((c2 == '<' ? true : c2 == '>') ? true : c2 == 'f') ? true : c2 == 'k') ? 4 : ((c2 == '@' ? true : c2 == '~') ? 6 : 5))));
    }

    @NotNull
    public final String stripText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int lineCounter = 0;
        int currentWidth = 0;
        boolean skipNext = false;
        StringBuffer buffer = new StringBuffer();
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (skipNext) {
                skipNext = false;
                continue;
            }
            char c2 = c;
            if (c2 == '\n') {
                currentWidth = 0;
                if (++lineCounter > 14) {
                    String string = buffer.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
                    return string;
                }
            } else if (c2 == '\u00a7') {
                skipNext = true;
            } else {
                int nextWidth = this.getCharacterWidth(c);
                if (currentWidth + nextWidth > 95) {
                    currentWidth = nextWidth;
                    if (++lineCounter > 14) {
                        String string = buffer.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
                        return string;
                    }
                } else {
                    currentWidth += nextWidth;
                }
            }
            buffer.append(c);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }
}

