/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/peripheralium/util/NBTUtil;", "", "()V", "blockPosFromNBT", "Lnet/minecraft/core/BlockPos;", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "chunkPosFromNBT", "Lnet/minecraft/world/level/ChunkPos;", "fromBinary", "base64", "", "fromText", "json", "isSubSet", "", "set", "subset", "toDirectNBT", "Lnet/minecraft/nbt/Tag;", "object", "toNBT", "pos", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nNBTUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NBTUtil.kt\nsite/siredvin/peripheralium/util/NBTUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class NBTUtil {
    @NotNull
    public static final NBTUtil INSTANCE = new NBTUtil();

    private NBTUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Tag toDirectNBT(@Nullable Object object) {
        Tag tag;
        if (object == null) {
            tag = null;
        } else if (object instanceof Boolean) {
            tag = (Tag)ByteTag.m_128266_((byte)((byte)((Boolean)object != false ? 1 : 0)));
        } else if (object instanceof Integer) {
            tag = (Tag)IntTag.m_128679_((int)((Integer)object));
        } else if (object instanceof Number) {
            tag = (Tag)DoubleTag.m_128500_((double)((Number)object).doubleValue());
        } else if (object instanceof String) {
            tag = (Tag)StringTag.m_129297_((String)((String)object).toString());
        } else if (object instanceof Map) {
            void var2_2;
            CompoundTag nbt = new CompoundTag();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                Object key = entry.getKey();
                Object value1 = entry.getValue();
                Tag value = this.toDirectNBT(value1);
                if (key == null || value == null) continue;
                nbt.m_128365_(key.toString(), value);
            }
            tag = (Tag)var2_2;
        } else {
            tag = null;
        }
        return tag;
    }

    @Nullable
    public final CompoundTag fromText(@Nullable String json) {
        CompoundTag compoundTag;
        try {
            String string = json;
            compoundTag = string == null ? null : TagParser.m_129359_((String)string);
        }
        catch (CommandSyntaxException ex) {
            ex.printStackTrace();
            compoundTag = null;
        }
        return compoundTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final CompoundTag fromBinary(@Nullable String base64) {
        if (base64 == null) {
            return null;
        }
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            Object object = base64;
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            object = decoder.wrap(new ByteArrayInputStream(byArray));
            Throwable throwable = null;
            try {
                InputStream inputStream = (InputStream)object;
                boolean bl = false;
                CompoundTag compoundTag = NbtIo.m_128939_((InputStream)inputStream);
                return compoundTag;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @NotNull
    public final CompoundTag toNBT(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        CompoundTag data = new CompoundTag();
        data.m_128405_("x", pos.m_123341_());
        data.m_128405_("y", pos.m_123342_());
        data.m_128405_("z", pos.m_123343_());
        return data;
    }

    @NotNull
    public final BlockPos blockPosFromNBT(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        return new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
    }

    @NotNull
    public final CompoundTag toNBT(@NotNull ChunkPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        CompoundTag data = new CompoundTag();
        data.m_128405_("x", pos.f_45578_);
        data.m_128405_("z", pos.f_45579_);
        return data;
    }

    @NotNull
    public final ChunkPos chunkPosFromNBT(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        return new ChunkPos(nbt.m_128451_("x"), nbt.m_128451_("z"));
    }

    public final boolean isSubSet(@NotNull CompoundTag set, @NotNull CompoundTag subset) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)subset, (String)"subset");
        for (String key : subset.m_128431_()) {
            if (!set.m_128441_(key)) {
                return false;
            }
            Tag original = subset.m_128423_(key);
            Tag setData = set.m_128423_(key);
            if (original instanceof CompoundTag) {
                if (!(setData instanceof CompoundTag)) {
                    return false;
                }
                if (!this.isSubSet((CompoundTag)setData, (CompoundTag)original)) {
                    return false;
                }
            }
            if (original == null || Intrinsics.areEqual((Object)original, (Object)setData)) continue;
            return false;
        }
        return true;
    }
}

