/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.item;

import dan200.computercraft.api.lua.LuaException;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\rJ@\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\"2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lsite/siredvin/peripheralium/storages/item/ItemStorageUtils;", "", "()V", "ALWAYS", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/item/ItemStack;", "getALWAYS", "()Ljava/util/function/Predicate;", "canMerge", "", "first", "second", "stackLimit", "", "canStack", "inplaceMerge", "mergeLimit", "naiveMove", "from", "Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "to", "Lsite/siredvin/peripheralium/storages/item/ItemSink;", "limit", "fromSlot", "toSlot", "takePredicate", "toInventoryOrToWorld", "", "output", "inventory", "outputPos", "Lnet/minecraft/core/BlockPos;", "level", "Lnet/minecraft/world/level/Level;", "Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "startSlot", "peripheralium-forge-1.20.1"})
public final class ItemStorageUtils {
    @NotNull
    public static final ItemStorageUtils INSTANCE = new ItemStorageUtils();
    @NotNull
    private static final Predicate<ItemStack> ALWAYS = ItemStorageUtils::ALWAYS$lambda$0;

    private ItemStorageUtils() {
    }

    @NotNull
    public final Predicate<ItemStack> getALWAYS() {
        return ALWAYS;
    }

    public final int naiveMove(@NotNull ItemStorage from, @NotNull ItemSink to, int limit, int fromSlot, int toSlot, @NotNull Predicate<ItemStack> takePredicate) {
        ItemStack itemStack;
        ItemStack stack;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(takePredicate, (String)"takePredicate");
        if (fromSlot < 0) {
            v0 = from.takeItems(takePredicate, limit);
        } else {
            if (!(from instanceof SlottedItemStorage)) {
                throw new LuaException("From storage doesn't support slotting");
            }
            v0 = stack = ((SlottedItemStorage)from).takeItems(limit, fromSlot, fromSlot, takePredicate);
        }
        if (stack.m_41619_()) {
            return 0;
        }
        int stackCount = stack.m_41613_();
        if (toSlot < 0) {
            itemStack = to.storeItem(stack);
        } else {
            if (!(to instanceof SlottedItemStorage)) {
                throw new LuaException("To storage doesn't support slotting");
            }
            itemStack = ((SlottedItemStorage)to).storeItem(stack, toSlot, toSlot);
        }
        ItemStack remainder = itemStack;
        int count = stackCount - remainder.m_41613_();
        if (!remainder.m_41619_()) {
            if (fromSlot < 0) {
                from.storeItem(remainder);
            } else {
                if (!(from instanceof SlottedItemStorage)) {
                    throw new LuaException("From storage doesn't support slotting");
                }
                ((SlottedItemStorage)from).storeItem(remainder, fromSlot, fromSlot);
            }
        }
        return count;
    }

    public static /* synthetic */ int naiveMove$default(ItemStorageUtils itemStorageUtils, ItemStorage itemStorage, ItemSink itemSink, int n, int n2, int n3, Predicate predicate, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n2 = -1;
        }
        if ((n4 & 0x10) != 0) {
            n3 = -1;
        }
        return itemStorageUtils.naiveMove(itemStorage, itemSink, n, n2, n3, predicate);
    }

    public final boolean canStack(@NotNull ItemStack first, @NotNull ItemStack second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (!ItemStack.m_41656_((ItemStack)first, (ItemStack)second)) {
            return false;
        }
        return first.m_41773_() == second.m_41773_() && ItemStack.m_150942_((ItemStack)first, (ItemStack)second);
    }

    public final boolean canMerge(@NotNull ItemStack first, @NotNull ItemStack second, int stackLimit) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (!this.canStack(first, second)) {
            return false;
        }
        int realStackLimit = stackLimit == -1 ? first.m_41741_() : Math.min(stackLimit, first.m_41741_());
        return first.m_41613_() < realStackLimit;
    }

    public static /* synthetic */ boolean canMerge$default(ItemStorageUtils itemStorageUtils, ItemStack itemStack, ItemStack itemStack2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        return itemStorageUtils.canMerge(itemStack, itemStack2, n);
    }

    @NotNull
    public final ItemStack inplaceMerge(@NotNull ItemStack first, @NotNull ItemStack second, int mergeLimit) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (!this.canMerge(first, second, mergeLimit)) {
            return second;
        }
        int mergeSize = Math.min(second.m_41613_(), Math.min(first.m_41741_() - first.m_41613_(), mergeLimit));
        first.m_41769_(mergeSize);
        second.m_41774_(mergeSize);
        if (second.m_41619_()) {
            ItemStack itemStack = ItemStack.f_41583_;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        return second;
    }

    public static /* synthetic */ ItemStack inplaceMerge$default(ItemStorageUtils itemStorageUtils, ItemStack itemStack, ItemStack itemStack2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        return itemStorageUtils.inplaceMerge(itemStack, itemStack2, n);
    }

    public final void toInventoryOrToWorld(@NotNull ItemStack output, @NotNull ItemSink inventory, @NotNull BlockPos outputPos, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)outputPos, (String)"outputPos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack rest = inventory.storeItem(output);
        if (!rest.m_41619_()) {
            Containers.m_18992_((Level)level, (double)outputPos.m_123341_(), (double)outputPos.m_123342_(), (double)outputPos.m_123343_(), (ItemStack)rest);
        }
    }

    public final void toInventoryOrToWorld(@NotNull ItemStack output, @NotNull SlottedItemStorage inventory, int startSlot, @NotNull BlockPos outputPos, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)outputPos, (String)"outputPos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack rest = inventory.storeItem(output, startSlot);
        if (!rest.m_41619_()) {
            Containers.m_18992_((Level)level, (double)outputPos.m_123341_(), (double)outputPos.m_123342_(), (double)outputPos.m_123343_(), (ItemStack)rest);
        }
    }

    private static final boolean ALWAYS$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

